/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef LINEHPP
#define LINEHPP

#include "vertex.h"

typedef enum { LINE_CLASS = 0, SPLINE_CLASS, ARC_CLASS } CLASS_LINE_TYPE;

// something for us to edit
class LineClass : public ObjectClass
{
public:
  VertexClass* P1;
  VertexClass* P2;
  BYTE Type;
  BYTE Width;  // pixel width assuming line length is greater
  LineClass* L1; // previous line which uses same vertex (not saved)
  LineClass* L2; // following line ditto.                (saved)
  LineClass* PL1; // previous Parrallel line for forming mesh (not saved)
  LineClass* PL2; // Next                                (saved if L1 is null)
  
  CLASS_LINE_TYPE Class;  // 0=Line 1=Spline 2=Arc
  LineClass();
};

#define LINE ((LineClass*)object)

// base class for creator of any object based on objectclass
class LineControlClass : public Object3DControlClass
{
public:
  LineControlClass();
  virtual ObjectClass* Create();
  virtual void Remove(ObjectClass*);
  virtual void NewForOld( ObjectClass*,ObjectClass*,ObjectClass*);
  virtual long Size();
  virtual bool Match(ObjectClass*,BlockClass*,LayerClass*);
  virtual bool Include(ObjectClass*, int, int, int, int);
  virtual bool DependantOn(ObjectClass*,ObjectClass*);
  virtual bool Inside(ObjectClass*,int,int);
  virtual int GetProperty(ObjectClass*,int n, void** p, char** name,
                            void**); // returns type or -1 for fail
  virtual int Summary(ObjectClass*,char*,int,int=0);
  virtual int SetProperty(ObjectClass*,int n, void* p); // -1 for fail
  virtual void GetRealLimits(ObjectClass*, fixed&,fixed&,fixed&,fixed&,fixed&,fixed&);
  virtual bool GetLimits(ObjectClass*,int&,int&,int&,int&,int&,int&);
  virtual void SetLimits(ObjectClass*,int,int,int,int);
  virtual void Draw(BITMAP*,ObjectClass*);
  virtual void Indicate(BITMAP*,ObjectClass*,int,int,int,int,int,int);
};

extern LineControlClass LineControl;

#endif
