/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "line.h"
#include "drawline.h"
#include "obj3ctrl.h"

#include "visulist.h"
#include "arc.h"
#include "spline.h"

LineClass::LineClass() : ObjectClass()
{ P1 = P2 = NULL;
  Class = LINE_CLASS;  // as opposed to Spline or Arc
  Type = 0;   // SOLID_LINE_TYPE;
  Width = 1;
  L1=L2=PL1=PL2= NULL;
}

/*
LineClass::~LineClass()
{
  // fix polyline connections
  if(L1 && (L1->L2 == this)) {
    L1->L2 = NULL;
  }
  if(L2 && (L2->L1 == this)) {
    L2->L1 = NULL;
    if(L2->Class == 1)
      ((SplineClass*)L2)->Flags ^= (SPLINE_V1_CALC^0xFFFF);
  }
  if(PL1 && (PL1->PL2 == this))
    PL1->PL2 = NULL;
  if(PL2 && (PL2->PL1 == this))
    PL2->PL1 = NULL;
}
*/

LineControlClass LineControl;

#define LINE ((LineClass*)object)

LineControlClass:: LineControlClass() : Object3DControlClass()
{ Name = "Line"; Properties = 8;
  Color = LIGHT_BLUE;
}

ObjectClass* LineControlClass::Create()
{
  return(new LineClass);
}

void LineControlClass::Remove(ObjectClass* object)
{
  // remove remote references - ie cut this line from chain of lines
  if(LINE->L1 &&                                     // linked
     (LINE->L1->L2 == LINE)  // which is linked to this
    )  {
    LINE->L1->L2 = NULL;         // cut it's link
    if(LINE->L1->Class == SPLINE_CLASS)
      ((SplineClass*)LINE->L1)->Flags &= ((SPLINE_V1_CALC|SPLINE_V2_CALC)^0xFFFF);
  }
    
  if(LINE->L2 &&                                     // linked
     (LINE->L2->L1 == LINE)  // which is linked to this
    ) {
    LINE->L2->L1 = NULL;        // cut it's link
    if(LINE->L2->Class == SPLINE_CLASS)
      ((SplineClass*)LINE->L2)->Flags &= ((SPLINE_V1_CALC|SPLINE_V2_CALC)^0xFFFF);
  }
  if(LINE->PL1 && (LINE->PL1->PL2 == LINE))
    LINE->PL1->PL2 = NULL;
  if(LINE->PL2 && (LINE->PL2->PL1 == LINE))
    LINE->PL2->PL1 = NULL;
  delete LINE;
}

void LineControlClass::NewForOld( ObjectClass* object, ObjectClass* oldobj, ObjectClass* newobj)
{
  if(LINE->P1 == (VertexClass*)oldobj)
    LINE->P1 = (VertexClass*)newobj;
  if(LINE->P2 == (VertexClass*)oldobj)
    LINE->P2 = (VertexClass*)newobj;
  if(LINE->L1 == (LineClass*)oldobj)
    LINE->L1 = (LineClass*)newobj;
  if(LINE->L2 == (LineClass*)oldobj)
    LINE->L2 = (LineClass*)newobj;
  if(LINE->PL1 == (LineClass*)oldobj)
    LINE->PL1 = (LineClass*)newobj;
  if(LINE->PL2 == (LineClass*)oldobj)
    LINE->PL2 = (LineClass*)newobj;
}

long LineControlClass::Size()
{
  return(sizeof(LineClass));
}

bool LineControlClass::Match(ObjectClass* object,BlockClass* block ,LayerClass* layer)
{ if(LINE->P1)
    return(LINE->P1->Block == block && (AllLayers || LINE->P1->Layer == layer));
  return false;
}

bool LineControlClass::Include(ObjectClass* object, int, int, int, int)
{
  if(LINE->P1 && LINE->P1->Block == Base_Block)
    return(Current_Visual->Include(Type,LINE->P1->Layer));
  return false;
}

bool LineControlClass::DependantOn(ObjectClass* object, ObjectClass* dependant)
{ return((dependant == LINE->P1 || dependant == LINE->P2));
}

bool LineControlClass::Inside(ObjectClass* object, int mx, int my)
{
  if(!LINE->P1 || !LINE->P2 || LINE->P1->Block != Base_Block)
    return false;
// only comes here after passing rough check on limits
  long x1, x2, y1, y2, z;
  Current_Visual->RealToFlat(&LINE->P1->Pos,x1,y1,z);
  Current_Visual->RealToFlat(&LINE->P2->Pos,x2,y2,z);
  int xc = (x1 + x2)>>1;
  int yc = (y1 + y2)>>1;
  return((mx > xc - 2) && (mx < xc + 2) && (my > yc - 2) && (my < yc + 2));
/*
  long d1x = x2 - x1;
  long d1y = y2 - y1;
  long d2x = x - x1;
  long d2y = y - y1;
  long de = 0;
  // check for simple zero gradients and protect later calcs from overflow
  if(d1x == 0)
    return(d2x == 0);
  if(d1y == 0)
    return(d2y == 0);
  // make an approximation of distance from line based on gradient error
  if(labs(d1x) > labs(d1y))
    de = (d2x * d1y)/d1x - d2y;
  else
    de = (d2y * d1x)/d1y - d2x;
  return(!de);
*/
/*  int x = MAX(x1,x2);
  x1 = MIN(x1,x2);
  x2 = x;
  int y = MAX(x1,x2);
  y1 = MIN(x1,x2);
  y2 = y;
  if(
  int y3 =
*/
}

/*
int LineControlClass::Distance(ObjectClass* object, int x, int y)
{
  int x1, x2, y1, y2, z;
  Current_Visual->RealToFlat(&LINE->P1->Pos,x1,y1,z);
  Current_Visual->RealToFlat(&LINE->P2->Pos,x2,y2,z);
  int dx = x2 - x1;
  int dy = y2 - y1;
  return(0);
}
*/

// should be called Get Pointer to and Name of Property
int LineControlClass::GetProperty(ObjectClass* object, int n, void** p, char** name,
                                               void** select_function)
{
  *select_function = NULL;
  VertexClass* vtx;
  switch(n)
  { case 0:
      vtx = LINE->P1;
      break;
    case 1:
      vtx = LINE->P2;
      break;
  }
  // user wants to have a better reference than a hexdecimal pointer so convert to link count
  if(n < 2)
  { static int vertex;
    vertex = TargetList->Find_OfType(vtx,&VertexControl);
    *p = &vertex;
  }
  switch(n)
  { case 0:
      *name = "P1:";
      return(INT_TYPE | INDEX_TYPE);
    case 1:
      *name = "P2:";
      return(INT_TYPE | INDEX_TYPE);
    case 2:
      *p = &(LINE->Type);
      *name = "Type";
      return(BYTE_TYPE);
    case 3:
      *p = &(LINE->Width);
      *name = "Width";
      return(BYTE_TYPE);
  }
  LineClass* line = NULL;
  switch(n)
  { case 4:
      line = LINE->L1;
      break;
    case 5:
      line = LINE->L2;
      break;
    case 6:
      line = LINE->PL1;
      break;
    case 7:
      line = LINE->PL2;
      break;
  }
  // user wants to have a better reference than a hexdecimal pointer so convert to link count
  static int linenumber;
  if(n >= 4 && n <= 7)
  { linenumber = TargetList->Find_OfType(line,&LineControl,&ArcControl,&SplineControl);
    *p = &linenumber;
  }
  switch(n) {
    case 4:
      *name = "L1:";
      return(INT_TYPE | INDEX_TYPE);
    case 5:
      *name = "L2:";
      return(INT_TYPE | INDEX_TYPE);
    case 6:
      *name = "PL1:";
      return(INT_TYPE | INDEX_TYPE);
    case 7:
      *name = "PL2:";
      return(INT_TYPE | INDEX_TYPE);
  }
/*
  if(n < 6)
    VertexControl.GetProperty(LINE->P1,n%3,p+n/3,name);
  switch(n)
  { case 0:
      *name = "X1:";
      return(LONG_TYPE);
    case 1:
      *name = "Y1:";
      return(LONG_TYPE);
    case 2:
      *name = "Z1:";
      return(LONG_TYPE);
    case 3:
      *name = "X2:";
      return(LONG_TYPE);
    case 4:
      *name = "Y2:";
      return(LONG_TYPE);
    case 5:
      *name = "Z2:";
      return(LONG_TYPE);
    case 6:
      *p = &(LINE->Type);
      *name = "Type";
      return(INT_TYPE);
  }
*/
  return(-1);
}

int LineControlClass::Summary(ObjectClass* object,char* str, int maxstr, int flags)
{
  if((flags & 1) && LINE->P1 && LINE->P1->Block != Base_Block) {
    str[0] = 0;
    return(0);
  }
  int p1 = -1;
  int p2 = -1;
  if(LINE->P1)
    p1 = TargetList->Find_OfType(LINE->P1,&VertexControl);
  if(LINE->P2)
    p2 = TargetList->Find_OfType(LINE->P2,&VertexControl);
  int i = uszprintf(str,maxstr,"%s P1=%d P2=%d",Name,p1,p2);
  LINETYPE t = (LINETYPE)LINE->Type;
  if(t > LINETYPES)
    t = (LINETYPE)LINETYPES;  // equivilant to "unknown"
  i += uszprintf(str+i,maxstr-i," Type= %s Width=%u",Line_Type_String[t],LINE->Width);
  i += VertexControl.Summary_Layer(LINE->P1,str+i,maxstr-i);
  i += VertexControl.Summary_Pos(LINE->P1,str+i,maxstr-i);
  i += VertexControl.Summary_Pos(LINE->P2,str+i,maxstr-i);
  return(i);
}

#include "visulist.h"

int LineControlClass::SetProperty(ObjectClass* object, int n, void* p)
{
  VertexClass* vtx;
  LineClass* line;
  if(n < 2)
    vtx = (VertexClass*)TargetList->Find_OfType(*(int*)p,&VertexControl);
  else if(n >= 4)
    line = (LineClass*)TargetList->Find_OfType(*(int*)p,
                     &LineControl,&ArcControl,&SplineControl);
  switch(n)
  { case 0:
      LINE->P1 = vtx;
      break;
    case 1:
      LINE->P2 = vtx;
      break;
    case 2:
      LINE->Type = *((BYTE*)p);
      break;
    case 3:
      LINE->Width = *((BYTE*)p);
      break;
    case 4:
      LINE->L1 = line;
      break;
    case 5:
      LINE->L2 = line;
      break;
    case 6:
      LINE->PL1 = line;
      break;
    case 7:
      LINE->PL2 = line;
      break;
    default:
      return(-1);
  }
  return(0);
}

void LineControlClass::GetRealLimits(ObjectClass* object, fixed& x1, fixed& y1, fixed& z1,
                                                          fixed& x2, fixed& y2, fixed& z2)
{
  x1 = MIN(LINE->P1->Pos.X,LINE->P2->Pos.X);
  x2 = MAX(LINE->P1->Pos.X,LINE->P2->Pos.X);
  y1 = MIN(LINE->P1->Pos.Y,LINE->P2->Pos.Y);
  y2 = MAX(LINE->P1->Pos.Y,LINE->P2->Pos.Y);
  z1 = MIN(LINE->P1->Pos.Z,LINE->P2->Pos.Z);
  z2 = MAX(LINE->P1->Pos.Z,LINE->P2->Pos.Z);
}

bool LineControlClass::GetLimits(ObjectClass* object,int& x,int& y,int &z,
                                                       int& w,int& h,int &d)
{
  // use current visual mode to map object limits onto a flat plane
  int x1,y1,x2,y2,z1,z2;
  Current_Visual->RealToFlat(&LINE->P1->Pos,x1,y1,z1);
  Current_Visual->RealToFlat(&LINE->P2->Pos,x2,y2,z2);
  x = MIN(x1,x2);
  y = MIN(y1,y2);
  z = MIN(z1,z2);
  w = MAX(x1,x2)-x + 1;
  h = MAX(y1,y2)-y + 1;
  d = MAX(z1,z2)-z + 1;
  // don't use x,y,w,h for any line drawing nosense
  return(Current_Visual->Show(Type,LINE->P1->Layer));
}

void LineControlClass::SetLimits(ObjectClass* object,int x,int y,
                                                       int w,int h)
{
  // not sure if changing the vertex settings makes any sense
  // use current visual mode to map flat plane onto object limits
  //  VertexControl.SetLimits(LINE->P1,x,y,w,h);
  //  VertexControl.SetLimits(LINE->P2,x,y,w,h);
}

void LineControlClass::Draw(BITMAP* bmp,ObjectClass* object)
{
  if(!Current_Visual->Show(Type,LINE->P1->Layer))
    return;
  // use current visual mode to protray object on bmp
  int x1, x2, y1, y2, z;
  Current_Visual->RealToFlat(&LINE->P1->Pos,x1,y1,z);
  Current_Visual->RealToFlat(&LINE->P2->Pos,x2,y2,z);
  // at present all line types are the same
  drawline(bmp,x1,y1,x2,y2,
                VertexControl.GetColor(LINE->P1,Color),
                (LINETYPE)LINE->Type);
//  if(VertexControl->Visible)
  int xc = (x1 + x2)>>1;
  int yc = (y1 + y2)>>1;
  rect(bmp,xc-2,yc-2,xc+2,yc+2,RED);
}

void LineControlClass::Indicate(BITMAP* bmp, ObjectClass* object,
     int,int,int,int, int fg, int bg)
{
  int x1, x2, y1, y2, z;
  Current_Visual->RealToFlat(&LINE->P1->Pos,x1,y1,z);
  Current_Visual->RealToFlat(&LINE->P2->Pos,x2,y2,z);
  dotted_line(bmp,x1,y1,x2,y2,fg,bg);
}

