/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <allegro.h>
#include <tdgui.h>
#include <stdio.h>

bool Joystick_Initialised = false;
const char* joyfile = "joystick.cfg";
int Max_Joysticks = 4;
int Joystick_Calibrate()
{
  const char* heading = "JOYSTICK CALIBRATION";
  billalert((char*)heading,NULL,"Center all sticks","&Ok", NULL, 'o', 0);
  if(Joystick_Initialised)
    remove_joystick();
  if(install_joystick(JOY_TYPE_2PADS) != 0)   //JOY_TYPE_AUTODETECT won't detect 2nd stick
    return 1;
//  num_joysticks = 1;
  for (int i = 0;
       i < num_joysticks && i < Max_Joysticks;   // (i < max_sticks) && (i < 4);
       i++) {
    while (joy[i].flags & JOYFLAG_CALIBRATE) {
      const char *msg = calibrate_joystick_name(i);
      char joystr[8];
      sprintf(joystr,"STICK#%1d",i);
      billalert((char*)heading,joystr,(char*)msg,"&Ok", NULL, 'o', 0);
      int err = calibrate_joystick(i);
      if(err != 0) {
        char errorstr[20];
        sprintf(errorstr,"ERROR %d",err);
        billalert((char*)heading,joystr,errorstr,"&Ok", NULL, 'o', 0);
        return 2;
      }
    }
//    if(billalert((char*)heading,"Do you have","more sticks?","Yes","No",'Y','N') == 0)
//      break;
//    num_joysticks++;
  }
  save_joystick_data(joyfile);
  Joystick_Initialised =true;
  return 0;
}

int Joystick_Init(int max_sticks)
{
  if(Joystick_Initialised)  // already done
    return 0;
  Max_Joysticks = max_sticks;
  if(load_joystick_data(joyfile))
    return(Joystick_Calibrate());
  Joystick_Initialised =true;
  return 0;
}

