/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "findvisu.h"

VertexClass* FindorMakeVertex(fixed x, fixed y, fixed z, BlockClass* block, LayerClass* layer)
{
  VisualLinkClass* link = (VisualLinkClass*)(TargetList->FirstLink());
  VertexClass* p = NULL;
  while(link)
  { if(link->Control == &VertexControl)
    { VertexClass* pt = (VertexClass*)(link->Object);
      if( pt->Block == block && pt->Layer == layer &&
          pt->Pos.X == x && pt->Pos.Y == y && pt->Pos.Z == z)  // this is the same vertex
      { p = pt;
        break;
      }
    }
    link = (VisualLinkClass*)(link->NextLink());
  }
  if(!p)   // no existing block found, so create one
  { p = new VertexClass();
    p->Pos.X = x;
    p->Pos.Y = y;
    p->Pos.Z = z;
    p->Block = block;
    p->Layer = layer;
    TargetList->Add(p,&VertexControl);
  }
  return(p);
}

BlockClass* FindorMakeBlock(char* name)
{
  LinkClass* link = BlockList.FirstLink();
  BlockClass* block = NULL;
  while(link)
  { char* n = ((BlockClass*)(link->Object))->Name;
    if(n && !ustrcmp(n,name))
    { block = (BlockClass*)(link->Object);
      break;
    }
    link = link->NextLink();
  }
  if(!block)   // no existing block found, so create one
  { block = new BlockClass();
    block->Name = new char[ustrsizez(name)];
    strcpy(block->Name,name);
    BlockList.Add(block);
  }
  return(block);
}

unsigned CountMatchingObject(Object3DControlClass* control, BlockClass* block, LayerClass* layer)
{
   int count = 0;
   VisualLinkClass* link = (VisualLinkClass*)(TargetList->FirstLink());
   while(link)
   { if(link->Control == control)
     { if(control->Match(link->Object,block,layer))
         count++;
     }
     link = (VisualLinkClass*)(link->NextLink());
   }
   return(count);
}

VisualLinkClass* NextMatchingObject(VisualLinkClass* vl, Object3DControlClass* control,
                             BlockClass* block, LayerClass* layer)
{  VisualLinkClass* link;
   if(vl)
     link = (VisualLinkClass*)(vl->NextLink());
   else
     link = (VisualLinkClass*)(TargetList->FirstLink());
   while(link)
   { if(link->Control == control)
     { if(control->Match(link->Object,block,layer))
         return(link);
     }
     link = (VisualLinkClass*)(link->NextLink());
   }
   return(NULL);
}

VisualLinkClass* FirstMatchingObject(Object3DControlClass* control, BlockClass* block,
                               LayerClass* layer)
{   return(NextMatchingObject(NULL,control,block,layer));
}

// the following two findmatchingvertex functions work by counting the vertex in
// targetlist sequencially, but only those for the given block and layer
int FindMatchingVertex(VertexClass* p,BlockClass* block, LayerClass* layer)
{
   int matchcount = 0;
   VisualLinkClass* link = (VisualLinkClass*)(TargetList->FirstLink());
   while(link)
   { if(link->Control == &VertexControl)
     { VertexClass* v = (VertexClass*)(link->Object);
       if(v == p)   // no need to check block and layer if they match
         return(matchcount);
       if(v->Block == block && v->Layer==layer)
         matchcount++;
     }
     link = (VisualLinkClass*)(link->NextLink());
   }
   return(-1);
}

VertexClass* FindMatchingVertex(unsigned p,BlockClass* block, LayerClass* layer)
{
   int count = 0;
   if(p == (unsigned)-1)
     return(NULL);   // not intended to find it
   VisualLinkClass* link = (VisualLinkClass*)(TargetList->FirstLink());
   while(link)
   { if(link->Control == &VertexControl)
     { VertexClass* v = (VertexClass*)(link->Object);
       if(v->Block == block && v->Layer==layer)
       { if(p == count)
           return(v);
         count++;
       }
     }
     link = (VisualLinkClass*)(link->NextLink());
   }
   return(NULL);
}

int FindMatchingLine(LineClass* p,BlockClass* block, LayerClass* layer)
{
   int matchcount = 0;
   VisualLinkClass* link = (VisualLinkClass*)(TargetList->FirstLink());
   while(link)
   { if(link->Control == &LineControl ||
        link->Control == &ArcControl ||
        link->Control == &SplineControl
       )
     { LineClass* v = (LineClass*)(link->Object);
       if(v == p)   // no need to check block and layer if they match
         return(matchcount);
       if(v->P1->Block == block && v->P1->Layer==layer)
         matchcount++;
     }
     link = (VisualLinkClass*)(link->NextLink());
   }
   return(-1);
}

LineClass* FindMatchingLine(unsigned p,BlockClass* block, LayerClass* layer)
{
   int count = 0;
   VisualLinkClass* link = (VisualLinkClass*)(TargetList->FirstLink());
   while(link)
   { if(link->Control == &LineControl ||
        link->Control == &ArcControl ||   // based on line
        link->Control == &SplineControl   // also based on line
       )
     { LineClass* v = (LineClass*)(link->Object);
       if(v->P1->Block == block && v->P1->Layer==layer)
       { if(p == count)
           return(v);
         count++;
       }
     }
     link = (VisualLinkClass*)(link->NextLink());
   }
   return(NULL);
}


// limit calling of inserts within blocks to a certain layer to prevent
// blocks inadvertently calling themselves too deeply
unsigned RecursionLevel = 0;
#define MAXDRAWRECURSION 256
#include "render.h"
#include "insert.h"
#include "face.h"

// DrawVisu is called in View.cpp and Insert.cpp
// For Inserts, the block space adjustment is done using the Current_Visual
// DrawVisu has to continually scan the TargetList for the relevnant objects
// so this is not the way you'd use the 3d info for a fast refresh
// In that case, each block would be located in a seperate targetlist
void DrawVisu(BITMAP* bmp, BlockClass* block = NULL)
{
  if(RecursionLevel > MAXDRAWRECURSION)
    return;
  if(RecursionLevel == 0)
    FirstFacet = NULL; // assume no faces qualify for render
  RecursionLevel++;
  VisualLinkClass* vl = (VisualLinkClass*)(TargetList->FirstLink());
  while(vl)
  { if(((Object3DControlClass*)vl->Control)->Match(vl->Object,block)) {    // note: no layer preference here
      if((RenderMode == WIREFRAME_RENDER) ||   // not render so just wire frame faces
         (!Current_Visual->Render) ||
         (vl->Control == &InsertControl))
        vl->Draw(bmp);
      else if(vl->Control == &FaceControl)  // only do faces for render
        ((FaceControlClass*)vl->Control)->Render(vl->Object);  // unique to face.cpp
    }
    vl = (VisualLinkClass*)(vl->NextLink());
  }
  RecursionLevel--;
  if((RecursionLevel == 0) && (RenderMode != WIREFRAME_RENDER) && Current_Visual->Render)
    RenderFaces(bmp);  // see render.cpp
}

void ScanLimits(fixed& x1, fixed& y1, fixed& z1, fixed& x2, fixed& y2, fixed& z2)
{
  VisualLinkClass* link = (VisualLinkClass*)(TargetList->FirstLink());
  x1 = y1 = z1 = x2 = y2 = z1 = 0;  // assumes inclusion of origin
  fixed xo1,yo1,zo1,xo2,yo2,zo2;
  while(link)
  { if(link->Control == &VertexControl || link->Control == &InsertControl)
    { if(((Object3DControlClass*)link->Control)->Match(link->Object,NULL))  // no sense including subblocks?
      { ((Object3DControlClass*)link->Control)->GetRealLimits(link->Object,xo1,yo1,zo1,xo2,yo2,zo2);
        x1 = MIN(x1,xo1);
        x2 = MAX(x2,xo1);
        y1 = MIN(y1,yo1);
        y2 = MAX(y2,yo1);
        z1 = MIN(z1,zo1);
        z2 = MAX(z2,zo1);
      }
    }
    link = (VisualLinkClass*)(link->NextLink());
  }
}

