/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef LINKLISTHPP
#define LINKLISTHPP

#include "define.h"
#include "obj.h"

extern void (*Link_Notify)(void*);

class ListClass;   // predefine

class LinkClass
{
  friend ListClass;
  LinkClass* Previous;
  LinkClass* Next;
public:
  ObjectClass* Object;
  bool Selected;
  // extra parameters in derived classes

  LinkClass(ObjectClass*);
  LinkClass* NextLink() { return(Next); };
  ~LinkClass();
private:   // private functions only to be called by ListClass so this must fix Start
  void Destroy_Followers();
  int Promote();
  int Demote();
public:
  virtual void Update() { if(Object) Object->Update(); };
};

class ListClass
{
  LinkClass* Start;
public:
  LinkClass* (*LinkMaker)(ObjectClass*);
  LinkClass* Undone;
  ListClass();
  ~ListClass();
  LinkClass* FirstLink() { return(Start); };
  void UnDo();
  bool CanUnDo();
  void ReDo();
  bool CanReDo();
  void Cat(LinkClass*); // puts link on the end of the list and removes Undone
  void Insert(LinkClass*,LinkClass* = NULL);
  LinkClass* Add(ObjectClass*,LinkClass* = NULL);
  LinkClass* Copy(LinkClass*,LinkClass* = NULL);  // copies link which looks at same object
  void Clear();
  void Destroy(LinkClass*);
  void Destroy_Undone();
  void Update();

  int Promote(LinkClass*);
  int Demote(LinkClass*);
  
  void Select(bool = TRUE);
  void Select_All();
  void Select_None();
  void SelectOnly(LinkClass*);
  void Invert_Selection();
  void Delete_Selected();
  
  LinkClass* First_Selected(unsigned* = NULL);
  LinkClass* Find(unsigned);
  int Find(ObjectClass*);
//  ObjectClass* Find_Gozump(unsigned n, ObjectClass* obj);
};

#endif
