/*  Source file for the BasicGUI program by Robert Parker using the Allegro 
    and Bgui2 - see credits else where.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "grid.h"

char Grid_Str[3][20];
int Grid_W[4] = { 1, 5, 10, 20 };
int Grid_H[4] = { 1, 5, 10, 20 };
int Grid = 2;
int* Grid_Offset_X = NULL;
int* Grid_Offset_Y = NULL;
int Snap_Factor = 1;   // snap to division of grid - usual either 1 or 2

//int Grid_Checker();
//int Grid_Resizer();
//int Grid_Checker();
//int Grid_Hider();



int SnapX(int x)
{   // for no snap, select Grid = 0 which is always unity
    if(!Grid || !Grid_Offset_X)
      return(x);
    x -= *Grid_Offset_X;
    x += Grid_W[Grid]/2/Snap_Factor;
    x -= x % (Grid_W[Grid]/Snap_Factor);
    x += *Grid_Offset_X;
    return x;
}

int SnapY(int y)
{
    if(!Grid || !Grid_Offset_Y)
      return(y);
    y -= *Grid_Offset_Y;
    y += Grid_H[Grid]/2/Snap_Factor;
    y -= y % (Grid_H[Grid]/Snap_Factor);
    y += *Grid_Offset_Y;
    return y;
}

/* checks/unchecks the Grid->Hide menu item */
int Grid_Hider(void)
{
    active_menu->flags ^= D_SELECTED;
    return D_REDRAW;
}



/* select the 'Grid*' menu item that was clicked, and unselect the others */
int Grid_Checker(void)
{
    Menu_Grid[Grid].flags = 0;
    active_menu->flags = D_SELECTED;
    Grid = active_menu - Menu_Grid;

    if(Grid == 0)
      Menu_Grid[7].flags = D_DISABLED;
    else
      Menu_Grid[7].flags = 0;

    return D_REDRAW;
}

/* pop up a dialog to edit the different grid sizes */
int Grid_Resizer(void)
{
    int i;
    char w[3][20], h[3][20];

    DIALOG Grid_dlg[] =
    {
       /* (proc)            (x)  (y) (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)           (dp2) (dp3) */
       { d_billwin_proc,    0,   0,  208, 112, 0,   0,   0,    0,      0,   0,   (void*)" Grid sizes", NULL, NULL },
       { d_billtext_proc,   8,   40, 48,  8,   0,   0,   0,    0,      0,   0,   (void*)"Width",       NULL, NULL },
       { d_billtext_proc,   8,   56, 48,  8,   0,   0,   0,    0,      0,   0,   (void*)"Height",      NULL, NULL },
       { d_billtext_proc,   64,  24, 40,  8,   0,   0,   0,    0,      0,   0,   (void*)"Grid1",       NULL, NULL },
       { d_billedit_proc,   64,  40, 40,  12,  0,   0,   0,    0,      4,   0,   w[0],          NULL, NULL },
       { d_billedit_proc,   64,  56, 40,  12,  0,   0,   0,    0,      4,   0,   h[0],          NULL, NULL },
       { d_billtext_proc,   112, 24, 40,  8,   0,   0,   0,    0,      0,   0,   (void*)"Grid2",       NULL, NULL },
       { d_billedit_proc,   112, 40, 40,  12,  0,   0,   0,    0,      4,   0,   w[1],          NULL, NULL },
       { d_billedit_proc,   112, 56, 40,  12,  0,   0,   0,    0,      4,   0,   h[1],          NULL, NULL },
       { d_billtext_proc,   160, 24, 40,  8,   0,   0,   0,    0,      0,   0,   (void*)"Grid3",       NULL, NULL },
       { d_billedit_proc,   160, 40, 40,  12,  0,   0,   0,    0,      4,   0,   w[2],          NULL, NULL },
       { d_billedit_proc,   160, 56, 40,  12,  0,   0,   0,    0,      4,   0,   h[2],          NULL, NULL },
       { d_billbutton_proc, 40,  88, 56,  16,  0,   0,   13,   D_EXIT, 0,   0,   (void*)"OK",          NULL, NULL },
       { d_billbutton_proc, 104, 88, 64,  16,  0,   0,   27,   D_EXIT, 0,   0,   (void*)"Cancel",      NULL, NULL },
       { NULL,              0,   0,  0,   0,   0,   0,   0,    0,      0,   0,   NULL,          NULL, NULL }
    };

    // write the values in the d_edit_proc's
    for(i=0; i<3; i++)
    {
      usprintf(w[i], "%d", Grid_W[i+1]);
      usprintf(h[i], "%d", Grid_H[i+1]);
    }

    // do the dialog
    set_dialog_color(Grid_dlg, gui_fg_color, gui_bg_color);
    centre_dialog(Grid_dlg);
    i = popup_dialog(Grid_dlg, 4);

    // read the modified values back, if 'Ok' was clicked
    if(i == 12)
      for(i=1; i<4; i++)
      {
        Grid_W[i] = MAX(1, ustrtol(w[i-1], NULL, 0));
        Grid_H[i] = MAX(1, ustrtol(h[i-1], NULL, 0));
        usprintf(Grid_Str[i-1], "Grid&%d %dx%d", i, Grid_W[i], Grid_H[i]);
      }

    return D_REDRAW;
}

int Half_Snap_Checker(void)
{
    active_menu->flags ^= D_SELECTED;
    if(active_menu->flags & D_SELECTED)
      Snap_Factor = 2;
    else
      Snap_Factor = 1;
    return D_REDRAW;
}

MENU Menu_Grid[] =
{
//  (text)                  (proc)          (child)     (flags)     (dp)
    { "&No Grid",           Grid_Checker,   NULL,       0,          NULL },
    { Grid_Str[0],          Grid_Checker,   NULL,       0,          NULL },
    { Grid_Str[1],          Grid_Checker,   NULL,       0,          NULL },
    { Grid_Str[2],          Grid_Checker,   NULL,       0,          NULL },
    { "",                   NULL,           NULL,       0,          NULL },
    { "&Hide",              Grid_Hider,     NULL,       0,          NULL },
    { "&Resize",            Grid_Resizer,   NULL,       0,          NULL },
    { "Half&Snap",        Half_Snap_Checker,NULL,       0,          NULL },
    { 0 }
};

void Init_Grid()
{   // grid menu text
    Menu_Grid[Grid].flags = D_SELECTED;
    for(int i=1; i<4; i++)
      usprintf(Grid_Str[i-1], "Grid&%d %dx%d", i, Grid_W[i], Grid_H[i]);
}

void Draw_Grid(BITMAP* bmp, int w, int h, int sx, int sy)
{ int x, y;
  if(Grid && !(Menu_Grid[5].flags & D_SELECTED))
  {
    int c = makecol(0, 64, 0);
    for(x=sx; x < sx+w && x < bmp->w; x += Grid_W[Grid])
      for(y=sy; y < sy+h && y < bmp->h; y += Grid_H[Grid])
        putpixel(bmp, x, y, c);
  }
}

