#include <dlgraph.h>
#include "data.h"

typedef struct Coordinate
{
	int x,y,c;
} Coordinate;

class Hauki
{
private:
	DATAFILE *data;
	Coordinate coordinate[5];
	int open_spot;
	int turn;
	DButton button[3];
public:
	void gameOver();
	bool noMoves();
	bool check_open(int i);
	bool check_click(int x,int y);
	void drawBoard();
	void drawPieces();
	void drawAll();
	void initGame();
	void cleanUp();
	void help();
	void newGame();
	void Start();
};


class Fox
{
private:
	DATAFILE *data;
	Coordinate coordinate[49];
	int geese;
	int fox;
	int turn;
	int select;
	DButton button[3];
public:
	void gameOver();
	bool noMoves(int p);
	bool check_open(int i,int p);
	bool check_click(int x,int y);
	bool goose_jumped(int i,int select);
	void drawBoard();
	void drawPieces();
	void drawAll();
	void initGame();
	void cleanUp();
	void help();
	void newGame();
	void Start();
};

class Fox_S
{
private:
	DATAFILE *data;
	Coordinate coordinate[49];
	int geese;
	int select;
	DButton button[3];
public:
	void gameOver();
	bool noMoves();
	bool check_open(int i);
	bool check_click(int x,int y);
	bool goose_jumped(int i);
	void drawBoard();
	void drawPieces();
	void drawAll();
	void initGame();
	void cleanUp();
	void help();
	void newGame();
	void Start();
};

class Magic
{
private:
	DATAFILE *data;
	Coordinate coordinate[10];
	DButton button[3];
public:
	void gameOver();
	bool noMoves();
	bool check_open(int i);
	int check_click(int x,int y);
	void drawBoard();
	void drawPieces();
	void drawAll();
	void initGame();
	void cleanUp();
	void help();
	void newGame();
	void Start();
};


class Conqueror
{
private:
	DATAFILE *data;
	Coordinate coordinate[15];
	int pawns;
	int select;
	DButton button[3];
public:
	void gameOver();
	bool noMoves();
	bool check_open(int i);
	void check_click(int x,int y);
	void pawn_jumped(int i);
	void drawBoard();
	void drawPieces();
	void drawAll();
	void initGame();
	void cleanUp();
	void help();
	void newGame();
	void Start();
};


class Universe
{
private:
	DATAFILE *data;
	Coordinate coordinate[49];
	int empty;
	int select;
	DButton button[3];
	int avail[8][3];
public:
	void gameOver();
	bool noMoves();
	bool check_open();
	void check_click(int x,int y);
	void drawBoard();
	void drawPieces();
	void drawAll();
	void initGame();
	void cleanUp();
	void help();
	void newGame();
	void Start();
};


class TicTacToe
{
private:
	DATAFILE *data;
	Coordinate coordinate[9];
	DButton button[3];
	int turn;
	int empty;
	int tic;
	bool gameover;
public:
	bool check_win();
	void gameOver();
	bool noMoves();
	bool check_tictactoe();
	void check_click(int x,int y);
	void drawBoard();
	void drawPieces();
	void drawAll();
	void initGame();
	void doAI();
	void cleanUp();
	void help();
	void newGame();
	void Start();
};


class FiveThree
{
private:
	DATAFILE *data;
	Coordinate coordinate[15];
	DButton button[3];
	bool gameover;
	int select;
	int column;
public:
	int find_next(int s);
	void gameOver();
	bool check_complete();
	void check_click(int x,int y);
	void drawBoard();
	void drawPieces();
	void drawAll();
	void initGame();
	void cleanUp();
	void help();
	void newGame();
	void Start();
};


void initAll();
void deleteAll();
int main();
