#include "main.h"

void Conqueror::drawAll()
{
	drawBoard();
	drawPieces();
	button[0].Draw(Screen);
	button[1].Draw(Screen);
	button[2].Draw(Screen);
	Draw_Screen();
}

void Conqueror::drawBoard()
{

	Title_Window(Screen,80,80,560,400,"Conqueror");
	masked_blit((BITMAP*)data[BOARD_CONQUEROR].dat,Screen.Bitmap,0,0,192,128,257,225);
}

void Conqueror::drawPieces()
{
	int i;
	for (i=0; i<15; i++)
	{
		if (coordinate[i].c==1)
		{
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_RED].dat,coordinate[i].x-15,coordinate[i].y-15);
			if (i==select)
				draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_BLUE_S].dat,coordinate[i].x-15,coordinate[i].y-15);
		}
	}
}

void Conqueror::newGame()
{
	int i,x[15]={128,98,158,68,128,188,38,98,158,218,8,68,128,188,248},
		  y[15]={8,60,60,112,112,112,164,164,164,164,216,216,216,216,216};		
	
	for (i=0; i<15; i++)
	{
		coordinate[i].x=192+x[i];
		coordinate[i].y=128+y[i];
		coordinate[i].c=1;		
	}

	select=16;
	pawns=16;
}

void Conqueror::initGame()
{
	data=load_datafile("data.dat");

	button[0].Create(480,115,60,20,"New");
	button[1].Create(480,140,60,20,"Quit");
	button[2].Create(480,165,60,20,"Help");

	Title_Window(Screen,80,80,560,400,"Conqueror");

	newGame();

}

void Conqueror::cleanUp()
{
	button[0].Delete();
	button[1].Delete();
	button[2].Delete();
	unload_datafile(data);
}

bool Conqueror::noMoves()
{
	int i;
	for (i=0; i<15; i++)
	{
		if (check_open(i))
			return false;
	}
	if (pawns==16) return false;
	return true;
}

bool Conqueror::check_open(int i)
{
	int c2[15]={ 1, 3, 4, 4, 7, 8, 7, 4, 4, 5, 6, 7, 7, 8, 9},
		d2[15]={ 2, 4, 5, 6, 8, 9, 3, 8, 7, 8,11,12, 8,12,13},
		e2[15]={16,16,16, 7,16, 4,16,16,16,16,16,16,16,16,16},
		c1[15]={ 3, 6, 7, 5,11,12, 8, 2, 1, 2, 3, 4, 3, 4, 5},
		d1[15]={ 5, 8, 9,10,13,14, 1, 9, 6, 7,12,13, 5,11,12},
		e1[15]={16,16,16,12,16, 3,16,16,16,16,16,16,16,16,16};
	
	if (c1[i]!=16 && coordinate[c1[i]].c==0 && coordinate[c2[i]].c==1)
	{
		return true;
	}
	if (d1[i]!=16 && coordinate[d1[i]].c==0 && coordinate[d2[i]].c==1)
	{
		return true;
	}
	if (e1[i]!=16 && coordinate[e1[i]].c==0 && coordinate[e2[i]].c==1)
	{
		return true;
	}
	return false;
}

void Conqueror::pawn_jumped(int i)
{
	int c1[15]={ 3, 6, 7, 5,11, 3, 8, 2, 1, 2, 3, 4, 3, 4, 5},
		d1[15]={ 5, 8, 9,10,13,12, 1, 9, 6, 7,12,13, 5,11,12},
		e1[15]={16,16,16,12,16,14,16,16,16,16,16,16,16,16,16},
		c2[15]={ 1, 3, 4, 4, 7, 8, 7, 4, 4, 5, 6, 7, 7, 8, 9},
		d2[15]={ 2, 4, 5, 6, 8, 9, 3, 8, 7, 8,11,12, 8,12,13},
		e2[15]={16,16,16, 7,16,16,16,16,16,16,16,16,16,16,16};
	
	if (c1[select]==i && coordinate[i].c==0 && coordinate[c2[select]].c==1)
	{
		coordinate[select].c=0;
		coordinate[i].c=1;
		coordinate[c2[select]].c=0;		
	}
	if (d1[select]==i && coordinate[i].c==0 && coordinate[d2[select]].c==1)
	{
		coordinate[select].c=0;
		coordinate[i].c=1;
		coordinate[d2[select]].c=0;		
	}
	if (e1[select]==i && coordinate[i].c==0 && coordinate[e2[select]].c==1)
	{
		coordinate[select].c=0;
		coordinate[i].c=1;
		coordinate[e2[select]].c=0;		
	}
}

void Conqueror::check_click(int x,int y)
{
	int i,p=100;
	for (i=0; i<15; i++)
	{
		if ((x>coordinate[i].x-16 && x<coordinate[i].x+16) &&
			(y>coordinate[i].y-16 && y<coordinate[i].y+16))
		{
			p=i;
		}
	}
	if (p!=100)
	{
		if (pawns==16)
		{
			coordinate[p].c=0;
			pawns--;
		}
		else
		{
			if (select==16)
			{
				if (check_open(p))
				{
					select=p;
				}
			}
			else
			{
				pawn_jumped(p);
				select=16;
				pawns--;				
			}
		}
	}
}

void Conqueror::gameOver()
{
	drawAll();
	if (pawns==0)
	{
		Info_Box(Screen,"Congratulations","  Ok  ",
			"You won the game!",END);
	}
	else
	{
		Info_Box(Screen,"Game Over","  Ok  ",
			"Sorry, you lost",
			"No more moves left!",END);
	}
}

void Conqueror::help()
{
	Info_Box(Screen,"Help!"," Done ",
			"Start by removing any pawn.",
			"---",
			"Then conitnue by jumping pawns.",
			"When you jump a pawn it is removed",
			"---",
			"Win the game by removing all but one",
			"pawn!",
			END);	
}

void Conqueror::Start()
{
	int dn=0,quit=0,l=0;

	initGame();
	drawAll();

	while (!dn)
	{
		drawAll();

		if (key[KEY_ESC]) quit=1;
		if (Mouse.Click())
		{
			check_click(mouse_x,mouse_y);
			
			if (l==0 && noMoves()) 
			{
				l=1;
				gameOver();				
			}
			if (button[0].Pressed())
			{
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to","Start Over?","@@@")==0)
				{
					newGame();
				}
			}
			if (button[1].Pressed()) quit=1;
			if (button[2].Pressed()) 
			{
				help();
			}
		}

		if (quit==1)
		{
			if (l==0)
			{
				quit=0;
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to Quit?","@@@")==0)
				{
					dn=1;
				}
			}
			else
			{
				dn=1;
			}
		}

	}
	cleanUp();

}