#include "main.h"

void Universe::drawAll()
{
	drawBoard();
	drawPieces();
	button[0].Draw(Screen);
	button[1].Draw(Screen);
	button[2].Draw(Screen);
	Draw_Screen();
}

void Universe::drawBoard()
{

	Title_Window(Screen,80,80,560,400,"Universe");
	masked_blit((BITMAP*)data[BOARD_UNIVERSE].dat,Screen.Bitmap,0,0,210,140,257,225);
}

void Universe::drawPieces()
{
	int i;
	for (i=0; i<8; i++)
	{
		if (coordinate[i].c==1)
		{
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_BLUE].dat,coordinate[i].x-15,coordinate[i].y-15);
			if (select==i)
				draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_BLUE_S].dat,coordinate[i].x-15,coordinate[i].y-15);
		}
	}
}

void Universe::newGame()
{
	int i,j,c[8]={0,0,0,0,0,0,0,0},
		x[8]={74,141,8,207,8,207,74,141},
		y[8]={8,8,74,74,141,141,207,207},
		d[8][3]={
			{8,4,6},
			{8,4,7},
			{8,5,7},
			{8,4,6},
			{0,1,3},
			{8,2,6},
			{0,3,5},
			{8,1,2}};
		
	
	for (i=0; i<8; i++)
	{
		coordinate[i].x=210+x[i];
		coordinate[i].y=140+y[i];
		coordinate[i].c=c[i];		
		for (j=0; j<3; j++)
		{
			avail[i][j]=d[i][j];
		}
	}

	select=8;
	empty=8;
}

void Universe::initGame()
{
	data=load_datafile("data.dat");

	button[0].Create(480,115,60,20,"New");
	button[1].Create(480,140,60,20,"Quit");
	button[2].Create(480,165,60,20,"Help");

	Title_Window(Screen,80,80,560,400,"Universe");

	newGame();

}

void Universe::cleanUp()
{
	button[0].Delete();
	button[1].Delete();
	button[2].Delete();
	unload_datafile(data);
}

bool Universe::noMoves()
{
	if (check_open())
	{
		return false;
	}	

	return true;
}

bool Universe::check_open()
{
	if (select==8) return true;
	if (coordinate[avail[select][0]].c==0 && avail[select][0]!=8)
	{
		return true;
	}
	if (coordinate[avail[select][1]].c==0 && avail[select][1]!=8)
	{
		return true;
	}
	if (coordinate[avail[select][2]].c==0 && avail[select][2]!=8)
	{
		return true;
	}

	return false;
}

void Universe::check_click(int x,int y)
{
	int i,p=100;
	for (i=0; i<8; i++)
	{
		if ((x>coordinate[i].x-10 && x<coordinate[i].x+10) &&
			(y>coordinate[i].y-10 && y<coordinate[i].y+10) &&
			(coordinate[i].c==0))
		{
			p=i;
		}
	}

	if (p!=100)
	{
		if (select==8)
		{
			select=p;
			empty--;
			coordinate[select].c=1;
		}
		else
		{
			if (p==avail[select][0])
			{
				select=p;
				empty--;
				coordinate[select].c=1;
			}
			if (p==avail[select][1])
			{
				select=p;
				empty--;
				coordinate[select].c=1;
			}
			if (p==avail[select][2])
			{
				select=p;
				empty--;
				coordinate[select].c=1;
			}
		}
	}	
}

void Universe::gameOver()
{
	drawAll();
	if (empty==0)
	{
		Info_Box(Screen,"Congratulations","  Ok  ",
			"You won the game!",END);
	}
	else
	{
		Info_Box(Screen,"Game Over","  Ok  ",
			"Sorry, you lost",
			"No more moves left!",END);
	}
}

void Universe::help()
{
	Info_Box(Screen,"Help!"," Done ",
			"Start at any point.",
			"Continue to any connected",
			"point until all points",
			"are filled.",
			"------------------------",
			"Fill up all 8 points to win",
			"the game.",
			"Get stuck and you lose.",END);

}

void Universe::Start()
{
	int dn=0,quit=0,l=0;

	initGame();

	while (!dn)
	{
		drawAll();

		if (key[KEY_ESC]) quit=1;
		if (key[KEY_S]) help();
		if (Mouse.Click())
		{
			check_click(mouse_x,mouse_y);
			if (l==0 && noMoves()) 
			{
				l=1;
				gameOver();				
			}
			if (button[0].Pressed())
			{
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to","Start Over?","@@@")==0)
				{
					newGame();
				}
			}
			if (button[1].Pressed()) quit=1;
			if (button[2].Pressed()) 
			{
				help();
			}
		}

		if (quit==1)
		{
			if (l==0)
			{
				quit=0;
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to Quit?","@@@")==0)
				{
					dn=1;
				}
			}
			else
			{
				dn=1;
			}
		}

	}
	cleanUp();

}