#include "main.h"

void FiveThree::drawAll()
{
	drawBoard();
	drawPieces();
	button[0].Draw(Screen);
	button[1].Draw(Screen);
	button[2].Draw(Screen);
	Draw_Screen();
}

void FiveThree::drawBoard()
{

	Title_Window(Screen,80,80,560,400,"Five and Three");
	masked_blit((BITMAP*)data[BOARD_FIVE].dat,Screen.Bitmap,0,0,170,140,300,200);
}

void FiveThree::drawPieces()
{
	int i;
	for (i=0; i<15; i++)
	{
		if (coordinate[i].c!=0)
		{
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_FIVE1+coordinate[i].c-1].dat,coordinate[i].x,coordinate[i].y);
			if (i==select)
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_FIVES1+coordinate[i].c-1].dat,coordinate[i].x,coordinate[i].y);
		}
	}
}

void FiveThree::newGame()
{
	int i,c[15]={1,2,3,4,5,0,0,0,0,0,0,0,0,0,0},
		x[15]={0,0,0,0,0,100,100,100,100,100,200,200,200,200,200},
		y[15]={90,110,130,150,170,90,110,130,150,170,90,110,130,150,170};

	
	for (i=0; i<15; i++)
	{
		coordinate[i].x=170+x[i];
		coordinate[i].y=140+y[i];
		coordinate[i].c=c[i];		
	}
	gameover=false;
	select=16;
	column=4;
}

void FiveThree::initGame()
{
	data=load_datafile("data.dat");

	button[0].Create(480,115,60,20,"New");
	button[1].Create(480,140,60,20,"Quit");
	button[2].Create(480,165,60,20,"Help");

	Title_Window(Screen,80,80,560,400,"Five and Three");

	newGame();

}

void FiveThree::cleanUp()
{
	button[0].Delete();
	button[1].Delete();
	button[2].Delete();
	unload_datafile(data);
}

bool FiveThree::check_complete()
{
	if (coordinate[5].c==1 &&
		coordinate[6].c==2 &&
		coordinate[7].c==3 &&
		coordinate[8].c==4 &&
		coordinate[9].c==5) return true;
	if (coordinate[10].c==1 &&
		coordinate[11].c==2 &&
		coordinate[12].c==3 &&
		coordinate[13].c==4 &&
		coordinate[14].c==5) return true;
	return false;
}

int FiveThree::find_next(int s)
{
	int l,i,p=100;
	l=s+5;
	for (i=s; i<l; i++)
	{
		if (coordinate[i].c!=0 && coordinate[i-1].c==0) p=i;
	}
	if (p!=100)
	{
		return p-1;
	}
	return l-1;
}

void FiveThree::check_click(int x,int y)
{
	int i,p=100,e=4,f,s;
	if (select==16)
	{
		for (i=0; i<15; i++)
		{
			if (x>=coordinate[i].x && x<=coordinate[i].x+100 &&
				y>=coordinate[i].y && y<=coordinate[i].y+20 &&
				coordinate[i].c!=0)
			{
				if (i==0 || i==5 || i==10)
				{
					p=i;
				}
				else
				{
					if (coordinate[i-1].c==0)
						p=i;
				}
			}
		}
		if (p!=100)
		{
			select=p;
			if (p>=0 && p<5) column=1;
			if (p>=5 && p<10) column=2;
			if (p>=10 && p<15) column=3;
		}
	}
	else
	{
		if (y>=140 && y<=340)
		{
			e=4;
			if (x>=170 && x<270 && coordinate[0].c==0)
			{
				e=1;
			}
			if (x>=270 && x<370 && coordinate[5].c==0)
			{
				e=2;
			}
			if (x>=370 && x<470 && coordinate[10].c==0)
			{
				e=3;
			}
		
			if (e!=4 && e!=column)
			{
				s=100;
				f=find_next((e-1)*5);
				if (f==4 || f==9 || f==14)
				{
					s=f;
				}
				else
				{
					if (coordinate[f+1].c>coordinate[select].c)
						s=f;
				}
				if (s<100)
				{
					coordinate[s].c=coordinate[select].c;
					coordinate[select].c=0;
					select=16;
					column=4;
				}
			}
			select=16;			
		}
	}
}

void FiveThree::gameOver()
{
	int p=0;
	gameover=true;
	drawAll();
	Info_Box(Screen,"Congratulations!","  Ok  ",
			"You won the Game!",END);	
}

void FiveThree::help()
{
	Info_Box(Screen,"Help!"," Done ",
			"Five discs and Three pegs.",
			"The challenge of the game is to move",
			"a disc to an empty pile, or onto a",
			"larger disc. Transfer the entire pile",
			"or discs to another peg.",END);
}

void FiveThree::Start()
{
	int dn=0,quit=0,l=0;


	initGame();
	drawAll();

	while (!dn)
	{
		drawAll();

		if (key[KEY_ESC]) quit=1;
		if (Mouse.Click())
		{
			if (!gameover)
			{
				check_click(mouse_x,mouse_y);
			}
			if (l==0 && check_complete()) 
			{
				l=1;
				gameOver();				
			}
			if (button[0].Pressed())
			{
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to","Start Over?","@@@")==0)
				{
					newGame();
					l=0;
				}
			}
			if (button[1].Pressed()) quit=1;
			if (button[2].Pressed()) 
			{
				help();
			}
		}

		if (quit==1)
		{
			if (l==0)
			{
				quit=0;
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to Quit?","@@@")==0)
				{
					dn=1;
				}
			}
			else
			{
				dn=1;
			}
		}

	}
	cleanUp();

}