#include "main.h"

void Hauki::drawAll()
{
	drawBoard();
	drawPieces();
	button[0].Draw(Screen);
	button[1].Draw(Screen);
	button[2].Draw(Screen);
	Draw_Screen();
}

void Hauki::drawBoard()
{

	Title_Window(Screen,80,80,560,400,"Pong hau k'i");
	masked_blit((BITMAP*)data[BOARD_HAUKI].dat,Screen.Bitmap,0,0,220,140,199,199);
}

void Hauki::drawPieces()
{
	int i;
	for (i=0; i<5; i++)
	{
		if (coordinate[i].c==1)
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_BLUE].dat,coordinate[i].x,coordinate[i].y);		
		if (coordinate[i].c==2)
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_RED].dat,coordinate[i].x,coordinate[i].y);		
	}

	if (turn==1)
		draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_BLUE].dat,140,224);		
	if (turn==2)
		draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_RED].dat,140,224);		
}

void Hauki::newGame()
{
	int i,x[5]={0,167,83,0,167},y[5]={0,0,83,167,167},c[5]={1,1,0,2,2};
	for (i=0; i<5; i++)
	{
		coordinate[i].x=220+x[i];
		coordinate[i].y=140+y[i];
		coordinate[i].c=c[i];
	}
	open_spot=2;
	turn=1;
}

void Hauki::initGame()
{
	data=load_datafile("data.dat");

	button[0].Create(480,115,60,20,"New");
	button[1].Create(480,140,60,20,"Quit");
	button[2].Create(480,165,60,20,"Help");

	Title_Window(Screen,80,80,560,400,"Pong hau k'i");
	newGame();
}

void Hauki::cleanUp()
{
	button[0].Delete();
	button[1].Delete();
	button[2].Delete();
	unload_datafile(data);
}

bool Hauki::noMoves()
{
	int i;
	for (i=0; i<5; i++)
	{
		if (check_open(i))
		{
			return false;
		}
	}
	return true;
}

bool Hauki::check_open(int i)
{
	int a[5][5]={{0,0,1,1,0},
				{0,0,1,0,1},
				{1,1,0,1,1},
				{1,0,1,0,1},
				{0,1,1,1,0}};
	
	if (coordinate[i].c==turn && a[i][open_spot]==1)
	{
		return true;	
	}
	return false;
}

bool Hauki::check_click(int x,int y)
{
	int i,a[5][5]={	{0,0,1,1,0},
					{0,0,1,0,1},
					{1,1,0,1,1},
					{1,0,1,0,1},
					{0,1,1,1,0}};
	for (i=0; i<5; i++)
	{
		if ((x>=coordinate[i].x && x<coordinate[i].x+32) &&
			(y>=coordinate[i].y && y<coordinate[i].y+32) && 
			check_open(i))
		{
			coordinate[i].c=0;
			coordinate[open_spot].c=turn;
			open_spot=i;
			return true;	
		}
	}

	return false;
}

void Hauki::gameOver()
{
	char t[2][6]={"Red","Blue"};
	drawAll();
	Info_Box(Screen,"Game Over","  Ok  ",
		t[turn-1],
		"Won the Game!",
		END);
}

void Hauki::help()
{
	Info_Box(Screen,"Help!","  Ok  ",
			"Move your pawn to the open",
			"space. Player wins if the",
			"other player cannot move!",END);
}

void Hauki::Start()
{
	int dn=0,quit=0,l=0;
//	OPPONENT_TYPE p;

	initGame();
	drawAll();
//	choosePlayerTypes("Blue","Red",p);
	while (!dn)
	{
		drawAll();

		if (key[KEY_ESC]) quit=1;
		if (Mouse.Click())
		{
			if (check_click(mouse_x,mouse_y))
			{
				turn++;
				if (turn==3) turn=1;
			}
			if (l==0 && noMoves()) 
			{
				l=1;
				gameOver();				
			}
			if (button[0].Pressed())
			{
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to","Start Over?","@@@")==0)
				{
					newGame();
				}
			}
			if (button[1].Pressed()) quit=1;
			if (button[2].Pressed()) 
			{
				help();
			}
		}

		if (quit==1)
		{
			if (l==0)
			{
				quit=0;
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to Quit?","@@@")==0)
				{
					dn=1;
				}
			}
			else
			{
				dn=1;
			}
		}

	}
	cleanUp();

}