#include "main.h"

void TicTacToe::drawAll()
{
	drawBoard();
	drawPieces();
	button[0].Draw(Screen);
	button[1].Draw(Screen);
	button[2].Draw(Screen);
	Draw_Screen();
}

void TicTacToe::drawBoard()
{

	Title_Window(Screen,80,80,560,400,"Tic Tac Toe");
	masked_blit((BITMAP*)data[BOARD_TIC].dat,Screen.Bitmap,0,0,268,188,104,104);
}

void TicTacToe::drawPieces()
{
	int i;
	for (i=0; i<9; i++)
	{
		if (coordinate[i].c==2 || coordinate[i].c==4)
		{
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_BLUE].dat,coordinate[i].x,coordinate[i].y);
		}
		if (coordinate[i].c==1 || coordinate[i].c==3)
		{
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_RED].dat,coordinate[i].x,coordinate[i].y);
		}
		if (coordinate[i].c>2)
		{
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_BLUE_S].dat,coordinate[i].x,coordinate[i].y);
		}
	}

		if (turn==2)
		{
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_BLUE].dat,200,188);
		}
		if (turn==1)
		{
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_RED].dat,200,188);
		}
}

void TicTacToe::newGame()
{
	int i,x[9]={2,36,70,2,36,70,2,36,70},
		y[9]={2,2,2,36,36,36,70,70,70};
		
	
	for (i=0; i<9; i++)
	{
		coordinate[i].x=268+x[i];
		coordinate[i].y=188+y[i];
		coordinate[i].c=0;		
	}
	turn=1;
	empty=9;
	gameover=false;
	tic=0;
}

void TicTacToe::initGame()
{
	data=load_datafile("data.dat");

	button[0].Create(480,115,60,20,"New");
	button[1].Create(480,140,60,20,"Quit");
	button[2].Create(480,165,60,20,"Help");

	Title_Window(Screen,80,80,560,400,"Tic Tac Toe");

	newGame();

}

void TicTacToe::cleanUp()
{
	button[0].Delete();
	button[1].Delete();
	button[2].Delete();
	unload_datafile(data);
}

bool TicTacToe::noMoves()
{
	if (empty==0 || check_tictactoe()) return true;
	return false;
}

bool TicTacToe::check_tictactoe()
{
	int c1[8]={0,3,6,0,1,2,0,2},
		c2[8]={1,4,7,3,4,5,4,4},
		c3[8]={2,5,8,6,7,8,8,6},i;
	for (i=0; i<8; i++)
	{
		if (coordinate[c1[i]].c>0 && 
			coordinate[c1[i]].c==coordinate[c2[i]].c && 
			coordinate[c1[i]].c==coordinate[c3[i]].c)
		{
			coordinate[c1[i]].c+=2;
			coordinate[c2[i]].c+=2;
			coordinate[c3[i]].c+=2;
			tic=coordinate[c1[i]].c-2;
			return true;
		}
	}
	return false;
}

void TicTacToe::check_click(int x,int y)
{
	int i,p=100;
	for (i=0; i<9; i++)
	{
		if ((x>=coordinate[i].x && x<=coordinate[i].x+32) &&
			(y>=coordinate[i].y && y<=coordinate[i].y+32) &&
			(coordinate[i].c==0))
		{
			p=i;
		}
	}	
	if (p!=100)
	{
		empty--;
		coordinate[p].c=turn;
		turn=2;
	}
}

bool TicTacToe::check_win()
{
	int c1[8]={0,3,6,0,1,2,0,2},
		c2[8]={1,4,7,3,4,5,4,4},
		c3[8]={2,5,8,6,7,8,8,6},i;

	for (i=0; i<8; i++)
	{

		// check to see if computer will win

		if (coordinate[c1[i]].c==2 &&
			coordinate[c2[i]].c==2 &&
			coordinate[c3[i]].c==0)
		{
			empty--;
			coordinate[c3[i]].c=2;
			return true;
		}
		if (coordinate[c1[i]].c==2 &&
			coordinate[c2[i]].c==0 &&
			coordinate[c3[i]].c==2)
		{
			empty--;
			coordinate[c2[i]].c=2;
			return true;
		}
		if (coordinate[c1[i]].c==0 &&
			coordinate[c2[i]].c==2 &&
			coordinate[c3[i]].c==2)
		{
			empty--;
			coordinate[c1[i]].c=2;
			return true;
		}

		// no check if I'm gonna win
		if (coordinate[c1[i]].c==1 &&
			coordinate[c2[i]].c==1 &&
			coordinate[c3[i]].c==0)
		{
			empty--;
			coordinate[c3[i]].c=2;
			return true;
		}
		if (coordinate[c1[i]].c==1 &&
			coordinate[c2[i]].c==0 &&
			coordinate[c3[i]].c==1)
		{
			empty--;
			coordinate[c2[i]].c=2;
			return true;
		}
		if (coordinate[c1[i]].c==0 &&
			coordinate[c2[i]].c==1 &&
			coordinate[c3[i]].c==1)
		{
			empty--;
			coordinate[c1[i]].c=2;
			return true;
		}


	}
	return false;
}

void TicTacToe::doAI()
{
	int dn=0,moves[9] = {4,0,2,6,8,1,3,5,7},i;
	if (!check_win())
	{
		while (!dn)
		{
			if (coordinate[moves[i]].c==0)
			{
				coordinate[moves[i]].c=2;
				empty--;
				dn=1;
			}
			else
			{
				i++;
			}
		}		
	}
}

void TicTacToe::gameOver()
{
	gameover=true;
	drawAll();
	if (empty>0)
	{
		if (tic==1)
		{
			Info_Box(Screen,"Congratulations","  Ok  ",
					"You won the game!",END);
		}
		else
		{
			Info_Box(Screen,"Game Over","  Ok  ",
				"Sorry, you lost!",END);
		}
	}
	else
	{
		Info_Box(Screen,"Game Over","  Ok  ",
			"It's a Tie!",
			"No more moves left!",END);
		
	}
}

void TicTacToe::help()
{
	Info_Box(Screen,"Help!"," Done ",
			"Get three pawns in a row to win.",
			"Either horizontally, vertically",
			"or diagonal.",
			END);
}

void TicTacToe::Start()
{
	int dn=0,quit=0,l=0;


	initGame();
	drawAll();

	while (!dn)
	{
		drawAll();

		if (key[KEY_ESC]) quit=1;
		if (Mouse.Click())
		{
			if (!gameover)
			{
				check_click(mouse_x,mouse_y);
				if (turn==2 && empty>0 && !(noMoves()))
				{
					doAI();
					turn=1;
				}
			}
			if (l==0 && noMoves()) 
			{
				l=1;
				gameOver();				
			}
			if (button[0].Pressed())
			{
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to","Start Over?","@@@")==0)
				{
					newGame();
					l=0;
				}
			}
			if (button[1].Pressed()) quit=1;
			if (button[2].Pressed()) 
			{
				help();
			}
		}

		if (quit==1)
		{
			if (l==0)
			{
				quit=0;
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to Quit?","@@@")==0)
				{
					dn=1;
				}
			}
			else
			{
				dn=1;
			}
		}

	}
	cleanUp();

}