#include "main.h"

DATAFILE *data;
DButton button[2];
DRadioGroup r;

void initAll()
{
	install_dlib(640,480,16);
	Title_Window(Screen,0,0,640,480,"Board Games");
	Mouse.Show();
	data=load_datafile("data.dat");
	install_d_font((FONT*)data[MY_FONT].dat);

	button[0].Create(240,360,60,20,"Play");
	button[1].Create(340,360,60,20,"Quit");
	
	
	r.Create(100,140,0,20,240,0,
		"Pong hau k'i",
		"Fox and Geese",
		"Fox and Geese (Solitaire)",
		"Magic",
		"Universe",
		"Conqueror",
		"Tic Tac Toe",
		"Five and Three",
		END);

}

void deleteAll()
{	
	unload_datafile(data);
	button[0].Delete();
	button[1].Delete();
	uninstall_dlib();
}

void drawAll()
{
	Title_Window(Screen,0,0,640,480,"Board Games");
	Title_Window(Screen,80,80,560,400,"Choose Game");
	button[0].Draw(Screen);
	button[1].Draw(Screen);
	r.Draw(Screen);
	Draw_Screen();
}

int main(void)
{
	int dn=0;
	Hauki		f0;
	Fox			f1;
	Fox_S		f2;
	Magic		f3;
	Universe	f4;
	Conqueror	f5;
	TicTacToe	f6;
	FiveThree	f7;

	initAll();

	while (!dn)
	{
		drawAll();

		if (Mouse.Click())
		{
			r.Check_Button();
			if (button[0].Pressed())
			{
				switch(r.Which_Select())
				{
				case 0:f0.Start();break;
				case 1:f1.Start();break;
				case 2:f2.Start();break;
				case 3:f3.Start();break;
				case 4:f4.Start();break;
				case 5:f5.Start();break;
				case 6:f6.Start();break;
				case 7:f7.Start();break;
				}
			}
			if (button[1].Pressed())
			{
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to Quit?","@@@")==0)
				{
					dn=1;
				}
			}
		}
	}
	deleteAll();

return 0;
}
END_OF_MAIN();