#include "main.h"

void Magic::drawAll()
{
	drawBoard();
	drawPieces();
	button[0].Draw(Screen);
	button[1].Draw(Screen);
	button[2].Draw(Screen);
	Draw_Screen();
}

void Magic::drawBoard()
{

	Title_Window(Screen,80,80,560,400,"Magic");
	masked_blit((BITMAP*)data[BOARD_MAGIC].dat,Screen.Bitmap,0,0,131,220,378,17);
}

void Magic::drawPieces()
{
	int i;
	for (i=0; i<10; i++)
	{
		if (coordinate[i].c==1)
		{
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_BLUE].dat,coordinate[i].x-15,coordinate[i].y-15);
		}
		if (coordinate[i].c==2)
		{
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_RED].dat,coordinate[i].x-15,coordinate[i].y-15);
		}
	}
}

void Magic::newGame()
{
	int i,c[10]={1,1,1,1,0,0,2,2,2,2};
		
	
	for (i=0; i<10; i++)
	{
		coordinate[i].x=139+40*i;
		coordinate[i].y=228;
		coordinate[i].c=c[i];		
	}
}

void Magic::initGame()
{
	data=load_datafile("data.dat");

	button[0].Create(480,115,60,20,"New");
	button[1].Create(480,140,60,20,"Quit");
	button[2].Create(480,165,60,20,"Help");

	Title_Window(Screen,80,80,560,400,"Magic");

	newGame();

}

void Magic::cleanUp()
{
	button[0].Delete();
	button[1].Delete();
	button[2].Delete();
	unload_datafile(data);
}

bool Magic::noMoves()
{
	return false;
}

bool Magic::check_open(int i)
{

	return true;
}

int Magic::check_click(int x,int y)
{
	int i,p=100;
	for (i=0; i<10; i++)
	{
		if ((x>coordinate[i].x-18 && x<coordinate[i].x+18) &&
			(y>coordinate[i].y-18 && y<coordinate[i].y+18) &&
			(coordinate[i].c!=0))
		{
			p=i;
		}
	}	
	if (p!=100)
	{
		if (coordinate[p].c==1)
		{
			if (p<9)
			{
				if (coordinate[p+1].c==0)
				{
					coordinate[p].c=0;
					coordinate[p+1].c=1;
					return 0;
				}
			}
			if (p<8)
			{
				if (coordinate[p+1].c!=0 && coordinate[p+2].c==0)
				{
					coordinate[p].c=0;
					coordinate[p+2].c=1;
					return 0;
				}
			}
		}
		else
		{
			if (p>0)
			{
				if (coordinate[p-1].c==0)
				{
					coordinate[p].c=0;
					coordinate[p-1].c=2;
					return 0;
				}
			}
			if (p>1)
			{
				if (coordinate[p-1].c!=0 && coordinate[p-2].c==0)
				{
					coordinate[p].c=0;
					coordinate[p-2].c=2;
					return 0;
				}
			}

		}
	}
	return 0;
}

void Magic::gameOver()
{
	int i,p=0,s[10]={2,2,2,2,0,0,1,1,1,1};
	drawAll();
	for (i=0; i<10; i++)
	{
		if (coordinate[i].c==s[i]) p++;
	}

	if (p==10)
	{
		Info_Box(Screen,"Congratulations","  Ok  ",
			"You won the game!",END);
	}
	else
	{
		Info_Box(Screen,"Game Over","  Ok  ",
			"Sorry, you lost",
			"No more moves left!",END);
	}
}

void Magic::help()
{
	Info_Box(Screen,"Help!"," Done ",
			"You can move one space or jump",
			"a pawn. The blue pawns can only",
			"go right, and the red can only",
			"go left.",
			"------------------------------",
			"To win the game move the red pawns",
			"all the way to the left and the blue",
			"pawns to the right.",
			END);
}

void Magic::Start()
{
	int dn=0,quit=0,l=0;


	initGame();
	drawAll();

	while (!dn)
	{
		drawAll();

		if (key[KEY_ESC]) quit=1;
		if (Mouse.Click())
		{
			check_click(mouse_x,mouse_y);
			if (l==0 && noMoves()) 
			{
				l=1;
				gameOver();				
			}
			if (button[0].Pressed())
			{
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to","Start Over?","@@@")==0)
				{
					newGame();
				}
			}
			if (button[1].Pressed()) quit=1;
			if (button[2].Pressed()) 
			{
				help();
			}
		}

		if (quit==1)
		{
			if (l==0)
			{
				quit=0;
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to Quit?","@@@")==0)
				{
					dn=1;
				}
			}
			else
			{
				dn=1;
			}
		}

	}
	cleanUp();

}