#include "main.h"

void Fox_S::drawAll()
{
	char msg[80];
	sprintf(msg,"Geese: %d",geese);
	drawBoard();
	drawPieces();
	button[0].Draw(Screen);
	button[1].Draw(Screen);
	button[2].Draw(Screen);

	Draw_Screen();
}

void Fox_S::drawBoard()
{

	Title_Window(Screen,80,80,560,400,"Fox and Geese (Solitaire)");
	masked_blit((BITMAP*)data[BOARD_FOX].dat,Screen.Bitmap,0,0,220,140,200,200);
}

void Fox_S::drawPieces()
{
	int i;
	for (i=0; i<49; i++)
	{
		if (coordinate[i].c==1)
		{
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_GREEN].dat,coordinate[i].x-7,coordinate[i].y-7);
			if (select==i)
				draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_GREEN_S].dat,coordinate[i].x-7,coordinate[i].y-7);
		}
	}
}

void Fox_S::newGame()
{
	int i,j,a=-1,
		c[49]={ a,a,1,1,1,a,a,
				a,a,1,1,1,a,a,
				1,1,1,1,1,1,1,
				1,1,1,0,1,1,1,
				1,1,1,1,1,1,1,
				a,a,1,1,1,a,a,
				a,a,1,1,1,a,a};
		
	
	for (i=0; i<7; i++)
	{
		for (j=0; j<7; j++)
		{
			coordinate[7*j+i].x=220+33*i;
			coordinate[7*j+i].y=140+33*j;
			coordinate[7*j+i].c=c[7*j+i];
		}
	}

	select=0;
	geese=32;
}

void Fox_S::initGame()
{
	data=load_datafile("data.dat");

	button[0].Create(480,115,60,20,"New");
	button[1].Create(480,140,60,20,"Quit");
	button[2].Create(480,165,60,20,"Help");
	Title_Window(Screen,80,80,560,400,"Fox and Geese (Solitaire)");
	newGame();
}

void Fox_S::cleanUp()
{
	button[0].Delete();
	button[1].Delete();
	button[2].Delete();
	unload_datafile(data);
}

bool Fox_S::noMoves()
{
	int i;
	for (i=0; i<49; i++)
	{
		if (check_open(i))
		{
			return false;
		}
	}
	
	return true;
}

bool Fox_S::check_open(int s)
{
	bool u,d,l,r;
	u=d=l=r=true;

	if (coordinate[s].x<286)
		l=false;
	if (coordinate[s].x>352)
		r=false;
	if (coordinate[s].y<206)
		u=false;
	if (coordinate[s].y>272)
		d=false;

	if (l)
	{
		if (coordinate[s-1].c==1 && coordinate[s-2].c==0)
			return true;
	}

	if (r)
	{
		if (coordinate[s+1].c==1 && coordinate[s+2].c==0)
			return true;
	}

	if (u)
	{
		if (coordinate[s-7].c==1 && coordinate[s-14].c==0)
			return true;
	}

	if (d)
	{
		if (coordinate[s+7].c==1 && coordinate[s+14].c==0)
			return true;
	}
	return false;
}

bool Fox_S::goose_jumped(int i)
{
	if (i==select-2 && coordinate[select-1].c==1)
	{
		coordinate[select].c=coordinate[select-1].c=0;
		coordinate[i].c=1;
		geese--;
		return true;
	}
	if (i==select+2 && coordinate[select+1].c==1)
	{
		coordinate[select].c=coordinate[select+1].c=0;
		coordinate[i].c=1;
		geese--;
		return true;
	}
	if (i==select-14 && coordinate[select-7].c==1)
	{
		coordinate[select].c=coordinate[select-7].c=0;
		coordinate[i].c=1;
		geese--;
		return true;
	}
	if (i==select+14 && coordinate[select+7].c==1)
	{
		coordinate[select].c=coordinate[select+7].c=0;
		coordinate[i].c=1;
		geese--;
		return true;
	}
	
	return false;
}

bool Fox_S::check_click(int x,int y)
{
	int i;
	if (select==0)
	{
		for (i=0; i<49; i++)
		{
			if ((x>coordinate[i].x-10 && x<coordinate[i].x+10) &&
				(y>coordinate[i].y-10 && y<coordinate[i].y+10) &&
				(coordinate[i].c==1))
			{
				select=i;
			}
		}
	}
	else
	{
		for (i=0; i<49; i++)
		{
			if ((x>coordinate[i].x-10 && x<coordinate[i].x+10) &&
				(y>coordinate[i].y-10 && y<coordinate[i].y+10))
			{
				if (coordinate[i].c==1)
				{
					select=i;
				}
				else
				{
					if (coordinate[i].c==0)
					{
						if (check_open(select))
						{
							if (goose_jumped(i))
								select=0;
						}				
					}
				}
			}
		}
	}
	return false;
}

void Fox_S::gameOver()
{
	drawAll();
	if (geese==1)
	{
	Info_Box(Screen,"You Won!"," Done ",
			"Congratulations!!",
			"You won the game."
			END);
	}
	else
	{
	Info_Box(Screen,"Game Over"," Done ",
			"You lose.",
			END);
	}
}

void Fox_S::help()
{
	Info_Box(Screen,"Help!"," Done ",
			"Remove all the geese by",
			"jumping over each other.",
			"------------------------------",
			"If there is only one goose left",
			"then you win.",
			"------------------------------",
			"For a harder game, try to get the",
			"last goose to land in the center.",
			END);	
}

void Fox_S::Start()
{
	int dn=0,quit=0,l=0;

	initGame();
	drawAll();
	while (!dn)
	{
		drawAll();

		if (key[KEY_ESC]) quit=1;
		if (Mouse.Click())
		{
			check_click(mouse_x,mouse_y);

			if (l==0 && noMoves()) 
			{
				l=1;
				gameOver();				
			}
			if (button[0].Pressed())
			{
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to","Start Over?","@@@")==0)
				{
					newGame();
				}
			}
			if (button[1].Pressed()) quit=1;
			if (button[2].Pressed()) 
			{
				help();
			}
		}

		if (quit==1)
		{
			if (l==0)
			{
				quit=0;
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to Quit?","@@@")==0)
				{
					dn=1;
				}
			}
			else
			{
				dn=1;
			}
		}

	}
	cleanUp();

}