#include "main.h"

void Fox::drawAll()
{
	char msg[80];

	sprintf(msg,"Geese: %d",geese);

	drawBoard();
	drawPieces();

	button[0].Draw(Screen);
	button[1].Draw(Screen);
	button[2].Draw(Screen);

	Screen.Text(msg,100,220);
	Screen.Text("Fox",100,150);
	draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_BLUE].dat,100,160);
	draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_GREEN].dat,107,230);

	Draw_Screen();
}

void Fox::drawBoard()
{

	Title_Window(Screen,80,80,560,400,"Fox and Geese");
	masked_blit((BITMAP*)data[BOARD_FOX].dat,Screen.Bitmap,0,0,220,140,200,200);
}

void Fox::drawPieces()
{
	int i;
	for (i=0; i<49; i++)
	{
		if (coordinate[i].c==1)
		{
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_BLUE].dat,coordinate[i].x-15,coordinate[i].y-15);
			if (i==select)
				draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_BLUE_S].dat,coordinate[i].x-15,coordinate[i].y-15);
		}
		if (coordinate[i].c==2)
		{
			draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_GREEN].dat,coordinate[i].x-7,coordinate[i].y-7);
			if (select==i)
				draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_GREEN_S].dat,coordinate[i].x-7,coordinate[i].y-7);
		}
	}

	Screen.Text("Whose Turn:",100,360);

	if (turn==1)
	{
		draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_BLUE].dat,200,349);			
	}
	else
	{
		draw_sprite(Screen.Bitmap,(BITMAP*)data[PAWN_GREEN].dat,200,357);				
	}
}

void Fox::newGame()
{
	int i,j,c[49]={-1,-1,0,0,0,-1,-1,
					-1,-1,0,0,0,-1,-1,
					0,0,0,1,0,0,0,
					0,0,0,0,0,0,0,
					2,2,2,2,2,2,2,
					-1,-1,2,2,2,-1,-1,
					-1,-1,2,2,2,-1,-1};
		
	
	for (i=0; i<7; i++)
	{
		for (j=0; j<7; j++)
		{
			coordinate[7*j+i].x=220+33*i;
			coordinate[7*j+i].y=140+33*j;
			coordinate[7*j+i].c=c[7*j+i];
		}
	}

	turn=2;
	select=0;
	geese=13;
	fox=17;
}

void Fox::initGame()
{
	data=load_datafile("data.dat");

	button[0].Create(480,115,60,20,"New");
	button[1].Create(480,140,60,20,"Quit");
	button[2].Create(480,165,60,20,"Help");

	Title_Window(Screen,80,80,560,400,"Fox and Geese");

	newGame();
}

void Fox::cleanUp()
{
	button[0].Delete();
	button[1].Delete();
	button[2].Delete();
	unload_datafile(data);
}

bool Fox::noMoves(int p)
{
	int i;
	if (turn==1)
	{
		for (i=0; i<49; i++)
		{
			if (check_open(i,p))
			{
				return false;
			}
		}
	}
	else
	{
		if (geese>0)
			return false;
	}
	return true;
}

bool Fox::check_open(int i,int p)
{
	if (coordinate[i].c!=0) return false;
	if (turn==1)
	{
		if (p==0)
		{
			if ((ABS(coordinate[i].x-coordinate[select].x)==33 && coordinate[i].y==coordinate[select].y) ||	
				(ABS(coordinate[i].y-coordinate[select].y)==33 && coordinate[i].x==coordinate[select].x))
			{
				return true;
			}
		}
		if (coordinate[i].x-coordinate[select].x==66 && coordinate[i].y==coordinate[select].y)
		{
			if (coordinate[select+1].c==2)
			{
				return true;
			}
		}
		if (coordinate[select].x-coordinate[i].x==66 && coordinate[i].y==coordinate[select].y)
		{
			if (coordinate[select-1].c==2)
			{
				return true;
			}
		}
		if (coordinate[i].y-coordinate[select].y==66 && coordinate[i].x==coordinate[select].x)
		{
			if (coordinate[select+7].c==2)
			{
				return true;
			}
		}
		if (coordinate[select].y-coordinate[i].y==66 && coordinate[i].x==coordinate[select].x)
		{
			if (coordinate[select-7].c==2)
			{
				return true;
			}
		}
	}
	else
	{ 
		if ((ABS(coordinate[i].x-coordinate[select].x)==33 && coordinate[i].y==coordinate[select].y) ||	
			(ABS(coordinate[i].y-coordinate[select].y)==33 && coordinate[i].x==coordinate[select].x))
		{
			return true;
		}
	}
	return false;
}

bool Fox::goose_jumped(int i,int s)
{
	if (i==select-2 && coordinate[i+1].c==2)
	{
		coordinate[i+1].c=0;
		geese--;
		return true;
	}
	if (i==select+2 && coordinate[i-1].c==2)
	{
		coordinate[i-1].c=0;
		geese--;
		return true;
	}
	if (i==select-14 && coordinate[i+7].c==2)
	{
		coordinate[i+7].c=0;
		geese--;
		return true;
	}
	if (i==select+14 && coordinate[i-7].c==2)
	{
		coordinate[i-7].c=0;
		geese--;
		return true;
	}
	
	return false;
}

bool Fox::check_click(int x,int y)
{
	int i;
	if (select==0)
	{
		for (i=0; i<49; i++)
		{
			if ((x>coordinate[i].x-8 && x<coordinate[i].x+8) &&
				(y>coordinate[i].y-8 && y<coordinate[i].y+8) &&
				(turn==coordinate[i].c))
			{
				select=i;
			}
		}
	}
	else
	{
		for (i=0; i<49; i++)
		{
			if ((x>coordinate[i].x-10 && x<coordinate[i].x+10) &&
				(y>coordinate[i].y-10 && y<coordinate[i].y+10))
			{
				if (coordinate[i].c==0)
				{
					if (i!=select)
					{
						if (check_open(i,0))
						{
							if (turn==1)
							{
								if (goose_jumped(i,select))
								{
									coordinate[i].c=turn;
									coordinate[select].c=0;
									select=fox=i;
									if (noMoves(1))
									{
										return true;
									}
									return false;
								}
								coordinate[i].c=turn;
								coordinate[select].c=0;
								fox=i;
								return true;
							}
							else
							{
								coordinate[i].c=turn;
								coordinate[select].c=0;
								return true;	
							}
						}
					}
				}
				else
				{
					if (turn==2 && coordinate[i].c==2)
					{
						select=i;
					}
				}
			}
		}
	}
	return false;
}

void Fox::gameOver()
{
	char t[2][10]={"The Geese","The Fox"};
	drawAll();
	Info_Box(Screen,"Game Over","  Ok  ",
		t[turn-1],
		"Won the Game!",
		END);
}

void Fox::help()
{
	if (Message(Screen,"Help!"," Next "," Done ",
			"The fox and the geese can move",
			"in any direction along a line.",
			"---------------",
			"If the fox jumps over a goose,",
			"then that goose is killed. The",
			"fox can jump more than one goose",
			"in a turn.",
			END)==0)
	{
	
	Info_Box(Screen,"Help!"," Done ",
			"The geese cannot jump over the fox,",
			"but they can crowd him into a",
			"corner.",
			"---------------",
			"If all the geese are killed then",
			"the fox wins. If the fox cannot",
			"make a move then the geese win.",
			END);
	}
}

void Fox::Start()
{
	int dn=0,quit=0,l=0;

	initGame();

	while (!dn)
	{
		drawAll();

		if (key[KEY_ESC]) quit=1;
		if (Mouse.Click())
		{
			if (check_click(mouse_x,mouse_y))
			{
				turn++;
				select=0;
				if (turn==3) 
				{
					turn=1;
					select=fox;
				}
			}
			if (l==0 && noMoves(0)) 
			{
				l=1;
				gameOver();				
			}
			if (button[0].Pressed())
			{
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to","Start Over?","@@@")==0)
				{
					newGame();
				}
			}
			if (button[1].Pressed()) quit=1;
			if (button[2].Pressed()) 
			{
				help();
			}
		}

		if (quit==1)
		{
			if (l==0)
			{
				quit=0;
				if (Message(Screen,"Are You Sure","Yes","No",
								"Do you want to Quit?","@@@")==0)
				{
					dn=1;
				}
			}
			else
			{
				dn=1;
			}
		}

	}
	cleanUp();

}