/***************************************************
                 Blocks Rain
Author:    Rogerio Mazakina
E-Mail:    gpr2k@hotmail.com
Home Page: http://gpr2k.cjb.net

Voce pode modificar ou redistribuir o jogo, contanto
que mantenha o codigo fonte e o readme.txt junto
com a copia.
This is a Free Software. Use, distribute and maybe
learn from it.
***************************************************/

#include <stdio.h>
#include <allegro.h>
#include <time.h>

#define TABLE_W 12
#define TABLE_H 25

#define PrintLog(x) Log(__LINE__, (x))

PALLETE pal;
BITMAP *buffer;
BITMAP *block_img;
BITMAP *background;

SAMPLE *nline;
SAMPLE *move;
SAMPLE *rotate;
SAMPLE *down;

volatile int FPS=0;
volatile int Frame=0;

void frame_count(void){
	FPS		= Frame;
	Frame	= 0;
}
END_OF_FUNCTION(frame_count)

// USED FOR GameSpeed CONTROL
volatile int TimerCount = 0;
static void UpdateTimerCount(void)
{
	TimerCount++;
}
END_OF_FUNCTION(UpdateTimerCount)


typedef struct
{
	int shape[4][4];
} BLOCK;

BLOCK NextBlock;
BLOCK CurrentBlock;
int TableLine[TABLE_H];
int Table[TABLE_W][TABLE_H];

int GameExit	= 0;
int BlockX		= 6;
int BlockY		= 0;
int Timer		= 0;
int Wait		= 0;
int PauseGame	= 0;
int GameOver	= 3;
int Score		= 0;
int Combo		= 0;
int GameSpeed	= 1;
int Lines		= 0;
int Level		= 10000;
int GameType	= 1;

void intro(void);
BLOCK CreateBlock(void);
void DrawBlock(BLOCK bl, int x, int y); 
int CheckLine(void);
int CheckBlock(int X, int Y);
void RotateBlock(BLOCK *bl);
void GetInput(void);
void UpdateGame(void);
void DrawGame(void);
// MAIN //
int main(void) {
	allegro_init();
	install_keyboard();
	install_timer();
	install_mouse();
	install_sound(DIGI_AUTODETECT,MIDI_NONE,"a");

	LOCK_VARIABLE(Frame);
	LOCK_VARIABLE(FPS);
	LOCK_FUNCTION(frame_count);
	install_int(frame_count,1000);

	LOCK_VARIABLE(TimerCount);
	LOCK_FUNCTION(UpdateTimerCount);
	install_int(UpdateTimerCount,30);

	set_color_depth(16);

	if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) < 0){
		printf(allegro_error);
		return 1;
	}

	buffer = create_bitmap(SCREEN_W,SCREEN_H);
	clear(buffer);
	block_img  = load_bmp("block.bmp",pal);
	background = load_bmp("bg.bmp",pal);

	nline = load_sample("line.wav");
	move = load_sample("move.wav");
	down = load_sample("down.wav");
	rotate = load_sample("rotate.wav");

	if (!nline || !move || !down || !rotate)
	{
		set_gfx_mode(GFX_TEXT,0,0,0,0);
		printf("Can not load sample file");
		return 1;
	}

	set_palette(pal);

	text_mode(-1);
	srand(time(0));

	while (!GameExit)
	{
		intro();
		while(key[KEY_ENTER]);
		while (!GameExit && GameOver!=3)
		{
			while (TimerCount > 0)
			{
				GetInput();
				UpdateGame();
				TimerCount--;
			}
			DrawGame();
		}
	}
	allegro_exit();
	return 0;
}
// END MAIN

BLOCK CreateBlock(void)
{
	int a = 0;
	int b = 0;
	int type = 0;

	BLOCK new_block;

	for (a=0; a<4; a++)
		for (b=0; b<4; b++)
			new_block.shape[a][b] = 0;

	if (GameType == 1)		 // Game WITHOUT Extra blocks
		type = rand()%7;
	else if (GameType == 2) // Game WITH Extra blocks
		type = rand()%11;
	
	switch (type)
	{
		case 0: // #
			new_block.shape[0][2] = 1;
			new_block.shape[0][3] = 1;
			new_block.shape[1][2] = 1;
			new_block.shape[1][3] = 1;
			break;
		case 1: // |
			new_block.shape[0][0] = 1;
			new_block.shape[0][1] = 1;
			new_block.shape[0][2] = 1;
			new_block.shape[0][3] = 1;
			break;
		case 2: // T
			new_block.shape[0][3] = 1;
			new_block.shape[1][2] = 1;
			new_block.shape[1][3] = 1;
			new_block.shape[2][3] = 1;
			break;
		case 3: // L
			new_block.shape[0][1] = 1;
			new_block.shape[0][2] = 1;
			new_block.shape[0][3] = 1;
			new_block.shape[1][3] = 1;
			break;
		case 4: // L
			new_block.shape[0][3] = 1;
			new_block.shape[1][1] = 1;
			new_block.shape[1][2] = 1;
			new_block.shape[1][3] = 1;
			break;
		case 5: //
			new_block.shape[0][2] = 1;
			new_block.shape[0][3] = 1;
			new_block.shape[1][1] = 1;
			new_block.shape[1][2] = 1;
			break;
		case 6: //
			new_block.shape[0][1] = 1;
			new_block.shape[0][2] = 1;
			new_block.shape[1][2] = 1;
			new_block.shape[1][3] = 1;
			break;
		case 7: // +
			new_block.shape[0][2] = 1;
			new_block.shape[1][1] = 1;
			new_block.shape[1][2] = 1;
			new_block.shape[1][3] = 1;
			new_block.shape[2][2] = 1;
			break;
		case 8: // U
			new_block.shape[0][2] = 1;
			new_block.shape[0][3] = 1;
			new_block.shape[1][3] = 1;
			new_block.shape[2][2] = 1;
			new_block.shape[2][3] = 1;
			break;
		case 9: // Z
			new_block.shape[0][1] = 1;
			new_block.shape[1][1] = 1;
			new_block.shape[1][2] = 1;
			new_block.shape[1][3] = 1;
			new_block.shape[2][3] = 1;
			break;
		case 10: // S
			new_block.shape[0][3] = 1;
			new_block.shape[1][1] = 1;
			new_block.shape[1][2] = 1;
			new_block.shape[1][3] = 1;
			new_block.shape[2][1] = 1;
			break;
		default:

			break;
	}
	return new_block;
}

void DrawBlock(BLOCK bl, int x, int y)
{
	int a,b;
	for (a=0; a<4; a++)
	for (b=0; b<4; b++)
	if (bl.shape[a][b])
		blit(block_img, buffer, 0, 0, x+(a*10), y+(b*10), 10, 10);
}

// Check if a line was complete
int CheckLine(void)
{
	int a		= 0;
	int b		= 0;
	int line	= 1;
	int res		= 0;

	for (b=TABLE_H-1; b>=0; b--)
	{
		line = 1;
		for (a=0; a<TABLE_W; a++)
		{
			if (Table[a][b] == 0)
			{
				line=0;
				break;
			}
		}
		if (line)
		{
			res = 1;
			TableLine[b] = 1;
			for (a=0; a<TABLE_W; a++)
				Table[a][b] = 2;
		}
	}
	return res;
}

// check if the block is not over another and can move
int CheckBlock(int X, int Y)
{
	int a,b;

	for (a=0; a<4; a++) {
		for (b=0; b<4; b++) {
			if (CurrentBlock.shape[a][b]){
				if (X == 1 && BlockX+a+1 > TABLE_W-1) return 1;
				if (X ==-1 && BlockX+a-1 < 0)         return 1;
				if (Y == 1 && BlockY+b+1 > TABLE_H-1) return 1;
				if (Table[a+BlockX+X][b+BlockY+Y])  return 1;
			}
		}
	}
	return 0;
}

// Rotate the entire block
void RotateBlock(BLOCK *bl)
{
	int a,b,c,vazio;
	BLOCK temp;
	BLOCK original = *bl;
	for (a=0; a<4; a++)
		for (b=0; b<4; b++)
		temp.shape[3-b][a] = bl->shape[a][b];

	*bl = temp;
	for (a=0; a<4; a++)
		for (b=0; b<4; b++)
			temp.shape[a][b]=0;

	for (a=0; a<2; a++) {
		vazio = 1;
		for (b=0; b<4; b++) {
			if (bl->shape[0][b]) {
				vazio=0;
				break;
			}
		}

		if (vazio) {
			for (c=0; c<3;c++) {
				temp.shape[c][0] = bl->shape[c+1][0];
				temp.shape[c][1] = bl->shape[c+1][1];
				temp.shape[c][2] = bl->shape[c+1][2];
				temp.shape[c][3] = bl->shape[c+1][3];
			}
			*bl = temp;
			for (a=0; a<4; a++)
			for (b=0; b<4; b++)
			temp.shape[a][b]=0;
		}
	}

	for (a=0; a<2; a++)	{
		vazio = 1;
		for (b=0; b<4; b++) {
			if (bl->shape[b][3]) {
				vazio=0;
				break;
			}
		}

		if (vazio) {
			for (c=3; c>0;c--) {
				temp.shape[0][c] = bl->shape[0][c-1];
				temp.shape[1][c] = bl->shape[1][c-1];
				temp.shape[2][c] = bl->shape[2][c-1];
				temp.shape[3][c] = bl->shape[3][c-1];
			}
			*bl = temp;
		}
	}

	for (a=0; a<4; a++) {
		for (b=0; b<4; b++) {
			if (bl->shape[a][b]) {
				if (BlockX+a >= TABLE_W && !CheckBlock(-1,0))
					BlockX--;
				else if (Table[BlockX+a][BlockY+b]) {
					if (!CheckBlock(-1,0))
						BlockX--;
					else if (!CheckBlock(1,0))
						BlockX++;
					else
						*bl = original;
				}
			}
		}
	}
}


void GetInput(void)
{
	static int kl,kr,ks,ke;
	// MOVE LEFT  //
	if (key[KEY_LEFT])
		kl++;

	if (kl==1 || kl>15)
	{
		kl++;
		if (BlockX>0 && !CheckBlock(-1,0))
		{
			BlockX--;
			play_sample(move,255,128,1000,0);
		}
	}
	if (!key[KEY_LEFT]) kl=0;

	// MOVE RIGHT //
	if (key[KEY_RIGHT])
		kr++;

	if (kr==1 || kr>15)
	{
		kr++;
		if (BlockX+1<TABLE_W && !CheckBlock(1,0))
		{
			BlockX++;
			play_sample(move,255,128,1000,0);
		}
	}
	if (!key[KEY_RIGHT])
		kr=0;

	//  MOVE DOWN //
	if (key[KEY_DOWN] && !Wait)
	{
		Timer+=20;
		play_sample(down,255,128,1000,0);
	}

	//  ROTATE    //
	if (key[KEY_SPACE])
		ks++;

	if (ks==1 || ks>15)
	{
		RotateBlock(&CurrentBlock);
		play_sample(rotate,255,128,1000,0);
	}
	if (!key[KEY_SPACE])
		ks=0;

	//  PauseGame     //
	if (key[KEY_ENTER])
		ke++;

	if (ke==1 || ke>15)
		PauseGame = !PauseGame;

	if (!key[KEY_ENTER])
		ke=0;
	
	if (key[KEY_ESC])
		GameExit = 1;
}

void UpdateGame(void)
{
	int a,b,c;
	static int ty;
	int new_line = 0;
	if (Timer >= 30 && GameOver==0 && !PauseGame) {
		Timer = 0;
		Combo = 0;
		// CHECK FOR Lines
		for (a=0; a<TABLE_H; a++) {
			if (TableLine[a]) {
				for (b=a; b>0; b--)      // Y
					for (c=0; c<TABLE_W; c++)// X
						Table[c][b] = Table[c][b-1];

				TableLine[a]=0;
				Wait = 0;
				Combo++;
				Lines++;
				Score+=100;

				// GameSpeed UP  //
				if (Score==Level) {
					GameSpeed++;
					Level+=Level;
				}
				if (GameSpeed==20)
					GameSpeed = 0;

				new_line = 1;
			}
		}

		if (new_line)
			play_sample(nline,255,128,1000,0);

		if (Combo>1)
			Score+=100*(Combo-1);

		// NEXT BLOCK
		if (CheckBlock(0,1)) {
			for (a=0; a<4; a++) {
				for (b=0; b<4; b++) {
					if (CurrentBlock.shape[a][b]){

						// CHECK FOR GAME OVER
						if (Table[BlockX+a][BlockY+b]) {
							Table[BlockX+a][BlockY+b] = 2;
							GameOver=1;
							ty=0;
						}
						else Table[BlockX+a][BlockY+b] = 1;
					}
				}
			}
			if (CheckLine())
				Wait=1;

			BlockY=0;
			BlockX=6;
			CurrentBlock = NextBlock;
			NextBlock = CreateBlock();      
		}
		else
			BlockY++;
	}
	if (GameOver==1) {
		PauseGame = 0;
		ty++;
		
		for (a=0; a<TABLE_W; a++)
			Table[a][TABLE_H-ty]=2;
		
		if (ty==TABLE_H) 
			GameOver=2;
	}
	else if (GameOver==2) {
		PauseGame = 0;

		for (a=0; a<TABLE_W; a++)
			Table[a][TABLE_H-ty]=0;

		ty--;
		if (ty==0)
			GameOver=3;
	}
	Timer+=GameSpeed;
}

void DrawGame(void)
{
	int a,b;
	clear_to_color(buffer,makecol(0,0,0));
	// background
	set_clip(buffer,19,19,TABLE_W*10+20,TABLE_H*10+20);

	for (a=0; a<4; a++)
		for (b=0; b<9; b++)
			blit (background,buffer, 0, 0, a*30+20, b*30+20, 30,30);

	set_clip(buffer,0,0,SCREEN_W,SCREEN_H);

	textout(buffer, font, "Next", 165, 30, makecol(255,255,255));
	rect(buffer,160,40,200,90,makecol(128,128,128));
	rect(buffer,161,41,201,91,makecol(80,80,80));
	rect(buffer,18,18,TABLE_W*10+20,TABLE_H*10+20,makecol(128,128,128));
	rect(buffer,19,19,TABLE_W*10+21,TABLE_H*10+21,makecol(80,80,80));

	textprintf(buffer, font, 160, 100, makecol(255,255,255), "Score: %d", Score);
	textprintf(buffer, font, 160, 110, makecol(255,255,255), "GameSpeed: %d", GameSpeed);
	textprintf(buffer, font, 160, 120, makecol(255,255,255), "Lines: %d", Lines);

	// Draw the blocks
	if (GameOver==0) {
		DrawBlock(CurrentBlock,BlockX*10+20,BlockY*10+20);
		DrawBlock(NextBlock,165,45);
	}
	else if (GameOver==3)
	{
		textout_centre(buffer, font, "Game Over", 80, 140, makecol(255,255,255));
		blit (buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
		while (!keypressed());
	}

	// DRAW Table
	for (a=0; a<TABLE_H; a++) {
		for (b=0; b<TABLE_W; b++) {
			if (Table[b][a] == 1) blit (block_img, buffer, 0, 0, 20+b*10, 20+a*10, 10,10);
			if (Table[b][a] == 2) blit (block_img, buffer, 10, 0, 20+b*10, 20+a*10, 10,10);
		}
	}

	if (PauseGame)
		textout_centre(buffer, font, "PauseGame", 80, 140, makecol(255,255,255));

	textprintf(buffer, font, 10, 10, makecol(255,255,255), "FPS %d", FPS);
	blit (buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	Frame++;
}


void intro(void)
{
	int t = 0;
	int sel  = 0;
	int exit = 0;

	if (GameExit)
		return;

	while (!exit && !key[KEY_ESC])
	{
		clear_to_color(buffer,makecol(0,80,255));
		if (sel==0)
		{
			if (t>20)
				textout_centre(buffer, font, "Press Enter", 320, 240, makecol(255,255,255));
			else if (t>40)
				t=0;
			else
				t++;

			if (key[KEY_ENTER]) {
				sel = 1;
				while(key[KEY_ENTER]);
			}
		}
		else {
			if (key[KEY_UP])
				sel = 1;
			else if (key[KEY_DOWN])
				sel = 2;
	
			if (sel == 1){
				triangle(buffer,280,240,280,250,290,245,0);

				if (key[KEY_RIGHT]) {
					if (GameSpeed<19)
						GameSpeed++;
						while (key[KEY_RIGHT]);
				}
				if (key[KEY_LEFT]) {
					if (GameSpeed>1)
						GameSpeed--;
					while (key[KEY_LEFT]);
				}
			}
			else if (sel == 2) {
				triangle(buffer,280,250,280,260,290,255,0);

				if (GameType == 1 && key[KEY_RIGHT])
					GameType = 2;

				if (GameType == 2 && key[KEY_LEFT])
					GameType = 1;
			}

			textprintf(buffer, font, 300, 240, makecol(255,255,255),"Velocidade %d", GameSpeed);
			textout(buffer, font, "Extra Blocks", 300, 250, makecol(255,255,255));

			if (GameType == 1) textout(buffer, font, "No", 400, 250, makecol(255,255,255));
			if (GameType == 2) textout(buffer, font, "Yes", 400, 250, makecol(255,255,255));

			if (key[KEY_ENTER]) exit = 1;
		}
		blit (buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	}
	BlockX   = 6;
	BlockY   = 0;
	Wait      = 0;
	PauseGame     = 0;
	GameOver = 0;
	Score     = 0;
	Lines     = 0;
	Level     = 10000;

	CurrentBlock = CreateBlock();
	NextBlock = CreateBlock();
}
