#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <time.h>
#include <allegro.h>
#include "data.h"
#include "guy.h"
#include "monster.h"

/**************Defines****************************************/

#define CELL_Y      16
#define CELL_X      16

#define ALIVE       1       //game states
#define DEAD        2
#define EXPLODE     3

#define JUMP        1
#define LEFT        2
#define RIGHT       3       //directions
#define FALL        4
#define UP          5
#define DOWN        6
#define NIN         7

#define OFF         0
#define ON          1


#define MAXWALL     52
#define MAXCELL     74

#define MAX_MONSTERS  100

#define MAX_BULLET  1000


// sounds
#define S_JUMP      0
#define S_HURT      1
#define S_ITEM      2
#define S_EXPLOSION 3

// actual_items
#define G_LIGHT        1
#define G_INVIS        2

// game_items
#define I_GOLD         1
#define I_MUSHROOM     2
#define I_SHOE         3
#define I_REDBALL      4
#define I_ORB          5
#define I_BATTERY      6
#define I_POISON       7
#define I_GREENBALL    8
#define I_BOTTLE       9
#define I_HEART        10
#define I_POTION       11
#define I_BOMB         12
#define I_ICECREAM     13
#define I_APPLE        14


/**************Structures*************************************/

typedef struct monsters
{
    int state;
    int x;
    int y;
    int dx;
    int dy;
    int sx;
    int sy;
    int type;
    int hp;
} monsters;

typedef struct main_player
{
    int x;
    int y;
    int dir;
    int frame;
    int hp;
    int sc;
    int bombs;
} main_player;

typedef struct bombs
{
    int x;
    int y;
    int state;
    int time;
} bombs;

typedef struct bullets
{
    int x;
    int y;
    int dir;
    int state;
} bullets;

/**************GLOBAL VARIABLES*******************************/

RGB_MAP rgb_table;
COLOR_MAP light_table;
COLOR_MAP trans_table;

DATAFILE *game,*guy,*mobs;
BITMAP *double_buffer,*gamemap,*objmap,*mobmap,*s;
BITMAP *spotlight;
PALLETE map_pal;
bool won=false;    

int num_mon,
    item[10]={0,0,0,0,0,0,0,0,0,0},
    move[10]={2,4,4,4,4,4,8,8,8,8},
    fall[8]={4,8,8,8,8,8,12,12},
    mjump[13]={32,24,24,16,16,12,12,8,8,8,4,},
    mv=0,jv=3,jp=0,maxel,cnt=0,cv=1,tim,light=ON,
    vol=80, // sound volume
    cell_edit=0,
    sx=66,sy=151,ssx=0,ssy=0,
    wleft,wright,wup,wdown,
    qr=148,ql=80,qu=96,qd=128;

bombs bomb;
bullets bullet[MAX_BULLET];
monsters monster[MAX_MONSTERS];
main_player player;

/**************FUNCTION PROTOTYPES****************************/

int Random(int u); 
void show_stats(BITMAP *bmp);
void blit_double_buffer_onto_screen();
void draw_light();
void change();
int install_music();
void play_sound(int s);
void init_bomb();
void set_bomb();
void draw_bomb();
void init_monsters();
void draw_monsters();
void check_monsters(int dir, int d, int i);
void move_monsters();
void init_bullet();
void fire_bullet();
void draw_bullet();
void move_bullet();
void init_player();
int cell_value(int x,int y);
int check_move(int o,int l);
void get_screen(int x,int y);
void draw_screen(int k);
void draw_guy(void);
void save(int o);
void edit_screen();
void edit_object();
void edit_monsters();
void set_blacks(int l1,int l2,int l3);
int main(void);

/**************FUNCTIONS**************************************/

int Random(int u) 
{
    return (rand() % u);
}

void show_stats(BITMAP *bmp)
{
    blit((BITMAP*)game[BACKGROUND].dat,bmp,0,0,240,0,80,240);
    text_mode(-1);
    textprintf_centre(bmp,(FONT*)game[FONT_1].dat,280,10,0,"SCORE:%d", player.sc);
    textprintf_centre(bmp,(FONT*)game[FONT_1].dat,280,40,0,"HP:%d", player.hp/100);
    textprintf_centre(bmp,(FONT*)game[FONT_1].dat,280,70,0,"BOMBS:%d", player.bombs);
}

void blit_double_buffer_onto_screen()
{
    show_stats(double_buffer);
    acquire_screen();
    blit(double_buffer, screen, 0, 0, 0, 0, 320, 240);
    release_screen();
}

void draw_light()
{
    int x,y,d=0;

    color_map = &light_table;
    clear(s);

    if (item[G_LIGHT]==1) // if you have a light
    {
        x = player.x - 80 +12;
        y = player.y - 80 +14;
        blit(double_buffer, s, x, y, x, y, 160, 160);
        draw_trans_sprite(s, spotlight, x, y);
    }

    show_stats(s);
    blit(s, screen, 0, 0, 0, 0, 320, 240);
}

void change()
{
    int i,j,p;
    for (i=0; i<640; i++)
    {
        for (j=0; j<480; j++)
        {
            p=getpixel(gamemap,i,j);
            if (p==26 || p==27) 
            {
                putpixel(gamemap,i,j,p+30);
            }
            if (p==56 || p==57) 
            {
                putpixel(gamemap,i,j,p-30);
            }
        }
    }
}

int install_music()
{
   /* install sound drivers */
   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL)!=0) 
   {
       return -1;
   }
   set_volume(130,130);
   return 0;
}

void play_sound(int s)
{
    play_sample((SAMPLE*)game[SAMP001+s].dat, 130, 130, 1000, FALSE);
}

void init_bomb()
{
    bomb.x=0;
    bomb.y=0;
    bomb.state=DEAD;
    bomb.time=0;
}

void set_bomb()
{
    if (player.bombs>0 && bomb.state==DEAD)
    {
        player.bombs--;
        bomb.x=player.x+4;
        bomb.y=player.y+16;
        bomb.state=ALIVE;
        bomb.time=25;
    }
}

void draw_bomb()
{
int x,y,i,j;

    if (bomb.state==ALIVE)
    {
        draw_sprite(double_buffer,(BITMAP*)game[BOMB].dat,bomb.x,bomb.y);
        bomb.time--;

        if (bomb.time==3)
        {
            play_sound(S_EXPLOSION);
            draw_sprite(double_buffer,(BITMAP*)game[EX1].dat,bomb.x,bomb.y);
        }
        if (bomb.time==2)
        {
            draw_sprite(double_buffer,(BITMAP*)game[EX2].dat,bomb.x,bomb.y);
        }
        if (bomb.time==1)
        {
            draw_sprite(double_buffer,(BITMAP*)game[EX3].dat,bomb.x,bomb.y);
        }
        if (bomb.time<=0)
        {
            bomb.state=DEAD;
            x=((bomb.x+ssx+8)>>4)+sx;   // point at center of bomb
            y=((bomb.y+ssy+8)>>4)+sy;
            for (i=x-1; i<x+2; i++)
            for (j=y-1; j<y+2; j++)
            if (getpixel(gamemap,i,j)==11) 
            {
                putpixel(gamemap,i,j,MAXCELL-6);
            }
        }
    }
}

void init_monsters()
{
    int i,x,y,p;
    num_mon=0;
    for (i=0; i<MAX_MONSTERS; i++)
    {
        monster[i].state    = DEAD;
        monster[i].x        =   
        monster[i].y        =   
        monster[i].dx       =   
        monster[i].dy       =   
        monster[i].sx       =   
        monster[i].sy       =   
        monster[i].type     =   
        monster[i].hp       = 0;
    }

    for (x=wleft; x<wright; x++)
    {
        for (y=wup; y<wdown; y++)
        {
            p=getpixel(mobmap,x,y);

            if (p>0 && num_mon<MAX_MONSTERS)
            {
                monster[num_mon].state    = ALIVE;
                monster[num_mon].x        = (x-sx)*16-ssx;
                monster[num_mon].y        = (y-sy)*16-ssy;
                monster[num_mon].dx       = 0;
                monster[num_mon].dy       = 0;
                monster[num_mon].sx       = 30;
                monster[num_mon].sy       = 20;
                monster[num_mon].type     = p;
                monster[num_mon].hp       = 40;

                if (p==1) 
                {
                    monster[num_mon].sx       = 82;
                    monster[num_mon].sy       = 130;
                    monster[num_mon].hp       = 500;
                }
                if (p==13) 
                {
                    monster[num_mon].dx       = 0;
                    monster[num_mon].dy       = 1;
                    monster[num_mon].sx       = 30;
                    monster[num_mon].sy       = 20;
                    monster[num_mon].hp       = 0;
                }
                if (p==14) 
                {
                    monster[num_mon].dx       = 1;
                    monster[num_mon].dy       = 0;
                    monster[num_mon].sx       = 30;
                    monster[num_mon].sy       = 20;
                    monster[num_mon].hp       = 0;
                }

                num_mon++;
            }
        }
    }
}

void draw_monsters()
{
    int i;
    for (i=0; i<num_mon; i++)
    {
        if (monster[i].state==ALIVE)
        {
            if (monster[i].x>-80 && monster[i].x<240 &&
                monster[i].y>-130 && monster[i].y<240)
            {
                draw_sprite(double_buffer,(BITMAP*)mobs[MON001+monster[i].type-1].dat,monster[i].x,monster[i].y);
            }
        }
    }
}

void check_monsters(int dir, int d, int i)
{
    int j,p,x,y,o=0,dx=0,dy=0,l,k;

    if (dir==LEFT)
    {
        x=monster[i].x;
        y=monster[i].y;
        while (d>0)
        {
            x--;
            d--;
            o=0;
            for (j=(monster[i].y); j<(monster[i].y+monster[i].sy); j++)
            {
                p=getpixel(gamemap,((x+ssx)>>4)+sx,((j+ssy)>>4)+sy);
                if (p<=MAXWALL)  
                {
                    o=1;
                }
            }

            if (((x+dx)>(player.x-monster[i].sx)) &&
                (     y>(player.y-monster[i].sy+16)) &&
                ((x+dx)<(player.x+24           )) &&
                (     y<(player.y+32           ))) 
            {
                o=1;
                player.hp-=4;
            }
        
            for (l=0; l<num_mon; l++)
            {
                k=0;
                if (monster[l].state==ALIVE && i!=l)
                {  
                    if (((x+dx)>(monster[l].x-monster[i].sx)) &&
                        (y>(monster[l].y-monster[i].sy)) &&
                        ((x+dx)<(monster[l].x+monster[l].sx)) &&
                        (y<(monster[l].y+monster[l].sy)) ) 
                    {
                        o=1;
                    }
                }
            }

            if (o==0) {dx--;}
        }
    }

    if (dir==RIGHT)
    {
        x=monster[i].x;
        y=monster[i].y;
        while (d>0)
        {
            x++;
            d--;
            o=0;
            for (j=(monster[i].y); j<(monster[i].y+monster[i].sy); j++)
            {
                p=getpixel(gamemap,((x+monster[i].sx+ssx)>>4)+sx,((j+ssy)>>4)+sy);
                if (p<=MAXWALL)  
                {
                    o=1;
                }
            }

            if (((x+dx)>(player.x-monster[i].sx)) &&
                (     y>(player.y-monster[i].sy+16)) &&
                ((x+dx)<(player.x+24           )) &&
                (     y<(player.y+32           ))) 
            {
                o=1;
                player.hp-=4;
            }
       
            for (l=0; l<num_mon; l++)
            {
                k=0;
                if (monster[l].state==ALIVE && i!=l)
                {  
                    if (((x+dx)>(monster[l].x-monster[i].sx)) &&
                        (y>(monster[l].y-monster[i].sy)) &&
                        ((x+dx)<(monster[l].x+monster[l].sx)) &&
                        (y<(monster[l].y+monster[l].sy)) ) 
                    {
                        o=1;
                    }
                }
            }

            if (o==0) {dx++;}

        }
    }

    if (dir==UP)
    {
        x=monster[i].x;
        y=monster[i].y;
        while (d>0)
        {
            y--;
            d--;
            o=0;
            for (j=(monster[i].x); j<(monster[i].x+monster[i].sx); j++)
            {
                p=getpixel(gamemap,((j+ssx)>>4)+sx,((y+ssy)>>4)+sy);
                if (p<=MAXWALL)  
                {
                    o=1;
                }
            }
            if (((x+dx)>(player.x-monster[i].sx)) &&
                 (     y>(player.y-monster[i].sy+16)) &&
                 ((x+dx)<(player.x+24           )) &&
                 (     y<(player.y+32           ))) 
            {
                o=1;
                player.hp-=4;
            }
       

            for (l=0; l<num_mon; l++)
            {
                k=0;
                if (monster[l].state==ALIVE && i!=l)
                {  
                    if ((x>(monster[l].x-monster[i].sx)) &&
                        ((y+dy)>(monster[l].y-monster[i].sy)) &&
                        (x<(monster[l].x+monster[l].sx)) &&
                        ((y+dy)<(monster[l].y+monster[l].sy)) ) 
                    {
                        o=1;
                    }
                }
            }

            if (o==0) {dy--;}
        }
    }

    if (dir==DOWN)
        {
            x=monster[i].x;
            y=monster[i].y;
            while (d>0)
            {
                y++;
                d--;
                o=0;
                for (j=(monster[i].x); j<(monster[i].x+monster[i].sx); j++)
                {
                    p=getpixel(gamemap,((j+ssx)>>4)+sx,((y+monster[i].sy+ssy)>>4)+sy);
                    if (p<=MAXWALL)  
                    {
                        o=1;
                    }
                }

                if (((x+dx)>(player.x-monster[i].sx)) &&
                    (y>(player.y-monster[i].sy+16)) &&
                    ((x+dx)<(player.x+24)) &&
                    (y<(player.y+32))) 
                {
                    o=1;
                    player.hp-=4;
                }
       
                for (l=0; l<num_mon; l++)
                {
                    k=0;
                    if (monster[l].state==ALIVE && i!=l)
                    {  
                        if ((x>(monster[l].x-monster[i].sx)) &&
                        ((y+dy)>(monster[l].y-monster[i].sy)) &&
                        (x<(monster[l].x+monster[l].sx)) &&
                        ((y+dy)<(monster[l].y+monster[l].sy)) ) 
                        {
                            o=1;
                        }
                    }
                }

           if (o==0) {dy++;}
        }
    }

    if (o==1)
    {
        if (monster[i].type==14)
        { 
            monster[i].dx=-monster[i].dx;
        }
        if (monster[i].type==13) 
        {
            monster[i].dy=-monster[i].dy;
        }
    }

    monster[i].x+=dx;
    monster[i].y+=dy;
}

void move_monsters()
{
    int i,cmx,cmy,cpx,cpy;
    for (i=0; i<num_mon; i++)
    {
        if (monster[i].state==ALIVE)
        {
            if (monster[i].type<13)
            {
                cmx=monster[i].x+(monster[i].sx/2);
                cmy=monster[i].y+(monster[i].sy/2);
                cpx=player.x+12;
                cpy=player.y+16;

                if (cmx>cpx) 
                {
                    if (abs(cmx-cpx)<4)
                    {
                        check_monsters(LEFT ,abs(cmx-cpx),i);
                    }
                    else
                    {
                        check_monsters(LEFT ,4,i);
                    }
                }
                if (cmx<cpx) 
                {
                    if (abs(cmx-cpx)<4)
                    {
                        check_monsters(RIGHT ,abs(cmx-cpx),i);
                    }
                    else
                    {
                        check_monsters(RIGHT ,4,i);
                    }
                }
                if (cmy>cpy) 
                {
                    if (abs(cmy-cpy)<4)
                    {
                        check_monsters(UP ,abs(cmy-cpy),i);
                    }
                    else
                    {
                        check_monsters(UP ,4,i);
                    }
                }
                if (cmy<cpy) 
                {
                    if (abs(cmy-cpy)<4)
                    {
                        check_monsters(DOWN ,abs(cmy-cpy),i);
                    }
                    else
                    {
                        check_monsters(DOWN ,4,i);
                    }
                }
            }
            else
            {
                if (monster[i].type==13)
                {
                    if (monster[i].dy==1)
                    {
                        check_monsters(UP ,4,i);
                    }
                    else
                    {
                        check_monsters(DOWN ,4,i);
                    }
                }
                else
                if (monster[i].type==14)
                {
                    if (monster[i].dx==1)
                    {
                        check_monsters(LEFT ,4,i);

                    }
                    else

                    {
                        check_monsters(RIGHT ,4,i);
                    }
                }
            }
        }
    }
}

void init_bullet()
{
    int i;
    for (i=0; i<MAX_BULLET; i++)
    {
        bullet[i].x=0;
        bullet[i].y=0;
        bullet[i].state=DEAD;
        bullet[i].dir=0;
    }
}

void fire_bullet()
{
    int i=0,dn=0;
    for (i=0; i<MAX_BULLET; i++)
    {
        if (!dn)
        {
            if (bullet[i].state==DEAD)
            {
                dn=1;
                if (player.dir==LEFT) 
                {
                    bullet[i].x=player.x+6;
                    bullet[i].y=player.y+10;
                }
                if (player.dir==RIGHT) 
                {
                    bullet[i].x=player.x+2;
                    bullet[i].y=player.y+10;
                }
                if (player.dir==UP) 
                {
                    bullet[i].x=player.x+8;
                    bullet[i].y=player.y+13;
                }
                if (player.dir==DOWN) 
                {
                    bullet[i].x=player.x-1;
                    bullet[i].y=player.y+3;
                }
                bullet[i].state=ALIVE;
                bullet[i].dir=player.dir;
            }
        }
    }
}

void draw_bullet()
{
    int i;

    for (i=0; i<MAX_BULLET; i++)
    {
        if (bullet[i].state==ALIVE)
        {
            if (bullet[i].x>=0 &&  bullet[i].y>=0 &&
                bullet[i].x<240 && bullet[i].y<240)
            {
                draw_sprite(double_buffer,(BITMAP*)game[BULLET].dat,bullet[i].x,bullet[i].y);
            }
        }
        if (bullet[i].state==EXPLODE)
        {
            bullet[i].state=DEAD;
            if (bullet[i].x>=0 && bullet[i].y>=0 &&
                bullet[i].x<240 && bullet[i].y<240)
            {
                draw_sprite(double_buffer,(BITMAP*)game[EX1].dat,bullet[i].x,bullet[i].y);
            }
        }
    }
}

void move_bullet()
{
    int i,j,p,l,k=0;

    for (i=0; i<MAX_BULLET; i++)
    {
        if (bullet[i].state==ALIVE)
        {

            for (j=0; j<16; j++)
            {
                if (bullet[i].dir==LEFT)  
                {
                    bullet[i].x--;
                }
                if (bullet[i].dir==RIGHT) 
                {
                    bullet[i].x++;
                }
                if (bullet[i].dir==UP)    
                {
                    bullet[i].y--;
                }
                if (bullet[i].dir==DOWN)  
                {
                    bullet[i].y++;
                }

                if (bullet[i].x<0 || bullet[i].y<0 ||
                    bullet[i].x>240 || bullet[i].y>240) 
                {
                    bullet[i].state=DEAD;
                    j=16;
                }

                for (l=0; l<num_mon; l++)
                {
                    if (monster[l].state==ALIVE)
                    {
                        if (monster[l].type!=13 && monster[l].type!=14)
                        {  
                            if ((bullet[i].x>(monster[l].x)) &&
                                (bullet[i].y>(monster[l].y)) &&
                                (bullet[i].x<(monster[l].x+monster[l].sx)) &&
                                (bullet[i].y<(monster[l].y+monster[l].sy)))
                            {
                                bullet[i].state=EXPLODE;
                                monster[l].hp-=4;
                                if (monster[l].hp<=0) 
                                {
                                    monster[l].state=DEAD;
                                }
                                l=num_mon;j=16;
                            }
                        }
                    }


                    p=getpixel(gamemap,((bullet[i].x+ssx+8)>>4)+sx,((bullet[i].y+ssy+8)>>4)+sy);
                    if (p<MAXWALL) 
                    {
                        bullet[i].state=EXPLODE;
                        j=16;
                        if (p==28) 
                        {
                            change();
                        }
                    }
                }
            }
        }
    }
}

void init_player()
{
    player.x=120;
    player.y=160;
    player.dir=RIGHT;
    player.frame=12;
    player.hp=20000;
    player.sc=0;
    player.bombs=0;
}

int cell_value(int x,int y)
{
    int p,q,o;
    p=MAXWALL;
    if (getpixel(double_buffer,x,y)>0) 
    {
        q=getpixel(gamemap,((x+ssx)>>4)+sx,((y+ssy)>>4)+sy);
        o=getpixel(objmap,((x+ssx)>>4)+sx,((y+ssy)>>4)+sy);

        if (o>0 && q>MAXWALL) 
        {
            putpixel(objmap,((x+ssx)>>4)+sx,((y+ssy)>>4)+sy,0);
            play_sound(S_ITEM);
            switch (o)
            {
            case I_GOLD     : 
                {
                    player.sc+=50;
                } break;
            case I_MUSHROOM : 
                {
                    won=true;
                } break;
            case I_SHOE     : 
                {
                } break;
            case I_REDBALL  : 
                {
                } break;
            case I_ORB      : 
                {
                    item[G_LIGHT]=1;
                } break;
            case I_BATTERY  : 
                {
                } break;
            case I_POISON   : 
                {
                } break;;
            case I_GREENBALL: 
                {
                    player.hp+=1000;
                } break;
            case I_BOTTLE   : 
                {
                } break;
            case I_HEART    : 
                {
                    player.sc+=100;
                } break;
            case I_POTION   : 
                {
                    item[G_INVIS]=1;
                } break;
            case I_BOMB     : 
                {
                    player.bombs+=5;
                } break;
            case I_ICECREAM : 
                {
                    player.sc+=1000;
                } break;
            case I_APPLE    : 
                {
                    player.sc+=200;
                } break;
            default: break;
            }  // end switch
        }

        return(getpixel(gamemap,((x+ssx)>>4)+sx,((y+ssy)>>4)+sy)); 
    }

    return(MAXWALL);
}

int check_move(int o,int l)
{
    int x1,y1,i,dn=0,tx=0,ty=0,j,t=0;

    y1=player.y+20;
    x1=player.x+4;

    if (o==LEFT) 
    {
        player.frame++;
        if (player.frame<8 || player.frame>11) 
        {
            player.frame=8;
        }
        for (j=1; j<l; j++)
        {
            for (i=y1; i<player.y+32; i++)
            {
                if ((key[KEY_LCONTROL]) && item[G_INVIS]==1 &&
                   (cell_value(player.x-j+4,i)==24 ||
                    cell_value(player.x-j+4,i)==25) ) 
                {
                    t=1;
                }
                else
                {
                    if (cell_value(player.x-j+4,i)<MAXWALL)
                    {
                        player.x=player.x-tx; 
                        return(1);
                    }
                    else
                    {
                        if (cell_value(player.x-j+4,i)==MAXCELL)
                        {
                            player.x=200;
                            sx=wleft-15;
                            if (ssx<0) 
                            {
                                ssx=0;
                                sx--;
                            }
                            return(2);
                        }
                        else 
                        {
                            t=1;
                        }
                    }
                }
            }
            if (t==1) 
            {
                t=0;
                tx++;
            }
        }
        player.x=player.x-tx;
        return(0);
    }

    if (o==RIGHT) 
    {
        player.frame++;
        if (player.frame<12 || player.frame>15) 
        {
            player.frame=12;
        }
        for (j=1; j<l; j++)
        {
            for (i=y1; i<player.y+32; i++)
            {
                if ((key[KEY_LCONTROL]) && item[G_INVIS]==1 &&
                   (cell_value(player.x+j+19,i)==24 ||
                    cell_value(player.x+j+19,i)==25) ) 
                {
                    t=1;
                }
                else
                {
                    if (cell_value(player.x+j+19,i)<MAXWALL)
                    {
                        player.x=player.x+tx; 
                        return(1);
                    }
                    else
                    {
                        if (cell_value(player.x+j+19,i)==MAXCELL)
                        {
                            player.x=20;
                            sx=wright+1;
                            if (ssx>0) 
                            {
                                ssx=0;
                                sx++;
                            }
                            return(2);
                        }
                        else 
                        {
                            t=1;
                        }
                    }
                }
            }
            if (t==1) 
            {
                t=0;
                tx++;
            }
        }
        player.x=player.x+tx;
        return(0);
    }

    if (o==UP) 
    {
        player.frame++;
        if (player.frame<0 || player.frame>3) 
        {
            player.frame=0;
        }
        for (j=1; j<l; j++)
        {
            for (i=x1; i<player.x+19; i++)
            {
                if ((key[KEY_LCONTROL]) &&  item[G_INVIS]==1 &&
                (cell_value(i,player.y-j+20)==24 ||
                   cell_value(i,player.y-j+20)==25) ) 
                {
                    t=1;
                }
                else
                {
                    if (cell_value(i,player.y-j+20)<MAXWALL)
                    {
                        player.y=player.y-ty; 
                        return(1);
                    }
                    else
                    {
                        if (cell_value(i,player.y-j+20)==MAXCELL)
                        {
                            player.y=190;
                            sy=wup-15;
                            if (ssy<0) 
                            {
                                ssy=0;
                                sy--;
                            }
                            return(2);
                        }
                        else 
                        {
                            t=1;
                        }
                    }
                }
            }
            if (t==1) 
            {
                t=0;
                ty++;
            }
        }
        player.y=player.y-ty;
        return(0);
    }

    if (o==DOWN) 
    {
        player.frame++;
        if (player.frame<4 || player.frame>7) 
        {
            player.frame=4;
        }
        for (j=1; j<l; j++)
        {
            for (i=x1; i<player.x+19; i++)
            {
                if ((key[KEY_LCONTROL]) &&  item[G_INVIS]==1 &&
                    cell_value(i,player.y+j+31)>23 &&
                    cell_value(i,player.y+j+31)<26) 
                {
                    t=1;
                }
                else
                {
                    if (cell_value(i,player.y+j+31)<MAXWALL)
                    {
                        player.y=player.y+ty; 
                        return(1);
                    }
                    else
                    {
                        if (cell_value(i,player.y+j+31)==MAXCELL)
                        {
                            player.y=4;
                            sy=wdown+1;
                            if (ssy>0) 
                            {
                                ssy=0;
                                sy++;
                            }
                            return(2);
                        }
                        else 
                        {
                            t=1;
                        }
                    }
                }
            }
            if (t==1) 
            {
                t=0;
                ty++;
            }
        }
        player.y=player.y+ty;
        return(0);
    }

    return 0;
}


void get_screen(int x,int y)
{
    int xx,yy,dn=0;

    xx=x;
    while (!dn)
    {
        xx--;
        if (getpixel(gamemap,xx,y)==0 ||
            getpixel(gamemap,xx,y)==MAXCELL) 
        {
            wleft=xx;
            dn=1;
        }
    }
    dn=0;

    xx=x;
    while (!dn)
    {
        xx++;
        if (getpixel(gamemap,xx,y)==0 ||
            getpixel(gamemap,xx,y)==MAXCELL) 
        {
            wright=xx;
            dn=1;
        }
    }
    dn=0;

    yy=y;
    while (!dn)
    {
        yy--;
        if (getpixel(gamemap,x,yy)==0 ||
            getpixel(gamemap,x,yy)==MAXCELL) 
        {
            wup=yy;
            dn=1;
        }
    }
    dn=0;

    yy=y;
    while (!dn)
    {
        yy++;
        if (getpixel(gamemap,x,yy)==0 ||
            getpixel(gamemap,x,yy)==MAXCELL) 
        {
            wdown=yy;
            dn=1;
        }
    }
    dn=0;
}

void draw_screen(int k)
{

    int cell_id,oc,dx,dy,dn=0,osx=0,osy=0,   // the cell id
        ossx,ossy,p=0,m,
        index_x,index_y,i;         // looping variables

        osx=sx;osy=sy;
        ossx=ssx;ossy=ssy;

    if (player.x>qr && sx<(wright-14)) 
    {
        dx=player.x-qr;
        player.x=qr;
        ssx=ssx+dx;
        if (ssx>16) 
        {
            sx++;
            ssx=ssx-16;
        }
        if (sx>=(wright-14)) 
        {
            sx=wright-14;
            ssx=0;
        }
        if (sx==wleft && ssx!=0) 
        {
            sx++;
            ssx-=16;
        }
    }
    if (player.x<ql && sx>wleft) 
    {
        dx=ql-player.x;
        player.x=ql;
        ssx=ssx-dx;
        if (ssx<-16) 
        {
            sx--;
            ssx=ssx+16;
        }
        if (sx<=wleft) 
        {
            sx=wleft;
            ssx=0;
        }
        if (sx==(wright-14) && ssx!=0) 
        {
            sx--;
            ssx+=16;
        }
    }

    if (player.y>qd && sy<(wdown-14)) 
    {
        dy=player.y-qd;
        player.y=qd;
        ssy=ssy+dy;
        if (ssy>16) 
        {
            sy++;
            ssy=ssy-16;
        }
        if (sy>=(wdown-14)) 
        {
            sy=wdown-14;
            ssy=0;
        }
        if (sy==wup && ssy!=0) 
        {
            sy++;
            ssy-=16;
        }
    }
    if (player.y<qu && sy>wup) 
    {
        dy=qu-player.y;
        player.y=qu;
        ssy=ssy-dy;
        if (ssy<-16) 
        {
            sy--;
            ssy=ssy+16;
        }
        if (sy<=wup) 
        {
            sy=wup;
            ssy=0;
        }
        if (sy==(wdown-14) && ssy!=0) 
        {
            sy--;
            ssy+=16;
        }
    }

    for (index_y=(-1); index_y<CELL_Y; index_y++)
    {
        for (index_x=(-1); index_x<CELL_X; index_x++)
        {
            cell_id = getpixel(gamemap,index_x+sx,index_y+sy);
            oc = getpixel(objmap,index_x+sx,index_y+sy);

            if (cell_id==53 || cell_id==54) 
            {
                p=1;
            }

            if (k==0) 
            {
                if (cell_id>=MAXCELL+11) 
                {
                    cell_id=MAXCELL-2;
                }
            }
            blit((BITMAP*)game[WALL000+cell_id].dat,double_buffer, 0, 0, (index_x << 4)-ssx, (index_y << 4)-ssy, 16, 16);

            if (oc>0)
            {
                draw_sprite(double_buffer,(BITMAP*)game[WOBJECT001+oc-1].dat, (index_x << 4)-ssx, (index_y << 4)-ssy);
            }
            if (k==1) 
            {
                if (cell_id>=MAXWALL)
                {
                    putpixel(double_buffer, (index_x << 4)-ssx+8, (index_y << 4)-ssy+8,73);
                }
                if (cell_id==0)
                {
                    putpixel(double_buffer, (index_x << 4)-ssx+8, (index_y << 4)-ssy+8,0);
                }
            }
        }
    }
    if (k==2)
    {
        for (index_y=(-1); index_y<CELL_Y; index_y++)
        {
            for (index_x=(-1); index_x<CELL_X; index_x++)
            {
                m = getpixel(mobmap,index_x+sx,index_y+sy);

                if (m>0)
                {
                    draw_sprite(double_buffer,(BITMAP*)mobs[MON001+m-1].dat, (index_x << 4)-ssx, (index_y << 4)-ssy);
                }
            }
        }
    }

    if (bomb.state==ALIVE)
    {
        bomb.x+=16*(osx-sx)+(ossx-ssx);
        bomb.y+=16*(osy-sy)+(ossy-ssy);
    }

    for (i=0; i<MAX_BULLET; i++)
    {
        if (bullet[i].state==ALIVE)
        {
            bullet[i].x+=16*(osx-sx)+(ossx-ssx);
            bullet[i].y+=16*(osy-sy)+(ossy-ssy);
        }
    }

    for (i=0; i<MAX_MONSTERS; i++)
    {
        if (monster[i].state==ALIVE)
        {
            monster[i].x+=16*(osx-sx)+(ossx-ssx);
            monster[i].y+=16*(osy-sy)+(ossy-ssy);
        }
    }

    if (p==1) 
    {
        light=OFF;
    } 
    else 
    {
        light=ON;
    }
}

void draw_guy(void)
{
    if ((key[KEY_LCONTROL]) && item[G_INVIS]==1)
    {
        color_map = &trans_table;
        draw_trans_sprite(double_buffer, (BITMAP*)guy[GUY01+player.frame].dat, player.x, player.y);
    }
    else
    {
        draw_sprite(double_buffer,(BITMAP*)guy[GUY01+player.frame].dat, player.x, player.y);
    }
}

void save(int o)
{
    int p;
    if (o==0) p=save_pcx("map.map", gamemap, map_pal);
    if (o==1) p=save_pcx("obj.map", objmap, map_pal);
    if (o==2) p=save_pcx("mob.map", mobmap, map_pal);
}

void edit_screen()
{
    int done=0,x,y,e,p;
    gamemap = load_pcx("map.map",map_pal);
    show_mouse(screen);
    p=cell_edit;
    draw_screen(1);
    blit_double_buffer_onto_screen();
    while (!done)
    {
        blit((BITMAP*)game[WALL000+p].dat,screen, 0, 0, 0,0,16,16);
        if (p==0) 
        {
            putpixel(screen, 8,8,0);
        }
        if (key[KEY_Q]) 
        {
            p--;
            rest(150);
            if (p<0) 
            {
                p=0;
            }
        }
        if (key[KEY_W])  
        {
            p++;
            rest(150);
            if (p>MAXCELL) 
            {
                p=MAXCELL;
            }
        }
        if (key[KEY_1]) 
        {
            p=0;
        }
        if (key[KEY_2]) 
        {
            p=MAXWALL;
        }
        if (key[KEY_3]) 
        {
            p=MAXCELL-2;
        }
        if (key[KEY_4]) 
        {
            p=MAXCELL;
        }
        if (key[KEY_Z]) 
        {
            p=MAXCELL+13;
        }
        if (key[KEY_L]) 
        {
            p=30;
        }

        if (key[KEY_LEFT])  
        {
            sx--;
            draw_screen(1);
            blit_double_buffer_onto_screen();
            rest(50);
        }
        if (key[KEY_RIGHT])  
        {   
            sx++;
            draw_screen(1);
            blit_double_buffer_onto_screen();
            rest(50);
        }
        if (key[KEY_UP])  
        {
            sy--;
            draw_screen(1);
            blit_double_buffer_onto_screen();
            rest(50);
        }
        if (key[KEY_DOWN])  
        {
            sy++;
            draw_screen(1);
            blit_double_buffer_onto_screen();
            rest(50);
        }

        if ((mouse_b & 1) || (mouse_b & 2))
        {
            x=mouse_x+ssx;
            y=mouse_y+ssy;
            if (key[KEY_SPACE]) 
            {
                if (mouse_b & 2) 
                {
                    e=MAXCELL-6;
                }
            }
            else 
            {
                if (mouse_b & 1) 
                {
                    e=p;
                }
                if (mouse_b & 2) 
                {
                    e=MAXCELL-2;
                }
            }
            
            show_mouse(NULL);
            putpixel(gamemap,(x>>4)+sx,(y>>4)+sy,e);
            draw_screen(1);
            blit((BITMAP*)game[WALL000+p].dat,double_buffer, 0, 0, 0,0,16,16);
            if (p==0) 
            {
                putpixel(double_buffer, 8,8,73);
            }
            blit_double_buffer_onto_screen();
            show_mouse(screen);
        }
        if (key[KEY_ESC])  
        {
            done=1;
        }
    }
    while (key[KEY_ESC])  {}
    save(0);
    show_mouse(NULL);
    cell_edit=p;
}

void edit_object()
{
    int done=0,x,y,e,p;
    objmap = load_pcx("obj.map",map_pal);
    show_mouse(screen);
    p=1;
    draw_screen(1);
    blit_double_buffer_onto_screen();
    while (!done)
    {
        blit((BITMAP*)game[WOBJECT001+p-1].dat,screen, 0, 0, 0,0,16,16);

        if (key[KEY_Q]) 
        {
            p--;
            rest(150);
            if (p<1) 
            {
                p=1;
            }
        }
        if (key[KEY_W])  
        {
            p++;rest(150);
            if (p>14) 
            {
                p=14;
            }
        }

        if (key[KEY_LEFT])  
        {
            sx--;
            draw_screen(1);
            blit_double_buffer_onto_screen();
            rest(50);
        }
        if (key[KEY_RIGHT])  
        {
            sx++;
            draw_screen(1);
            blit_double_buffer_onto_screen();
            rest(50);
        }
        if (key[KEY_UP])  
        {
            sy--;
            draw_screen(1);
            blit_double_buffer_onto_screen();
            rest(50);
        }
        if (key[KEY_DOWN])  
        {
            sy++;
            draw_screen(1);
            blit_double_buffer_onto_screen();
            rest(50);
        }

        if ( (mouse_b & 1) || (mouse_b & 2) )
        {
            x=mouse_x+ssx;y=mouse_y+ssy;
            if (mouse_b & 1) 
            {
                e=p;
            }
            if (mouse_b & 2) 
            {
                e=0;
            }
            show_mouse(NULL);
            putpixel(objmap,(x>>4)+sx,(y>>4)+sy,e);
            draw_screen(1);
            blit((BITMAP*)game[WOBJECT001+p-1].dat,double_buffer, 0, 0, 0,0,16,16);
            blit_double_buffer_onto_screen();
            show_mouse(screen);
        }
        if (key[KEY_ESC])  
        {
            done=1;
        }
    }
    while (key[KEY_ESC])  {}
    save(1);
    show_mouse(NULL);
}

void edit_monsters()
{
    int done=0,x,y,e,p;
    mobmap = load_pcx("mob.map",map_pal);
    show_mouse(screen);
    p=1;
    draw_screen(2);
    draw_sprite(double_buffer,(BITMAP*)mobs[MON001+p-1].dat,0,0);
    blit_double_buffer_onto_screen();
    while (!done)
    {
        if (key[KEY_Q]) 
        {
            p--;
            if (p<1) 
            {
                p=1;
            }
            draw_screen(2);
            draw_sprite(double_buffer,(BITMAP*)mobs[MON001+p-1].dat,0,0);
            blit(double_buffer, screen, 0, 0, 0, 0,320,240);
            rest(150);
        }
        if (key[KEY_W]) 
        {
            p++;
            if (p>MONEND) 
            {
                p=MONEND;
            }
            draw_screen(2);
            draw_sprite(double_buffer,(BITMAP*)mobs[MON001+p-1].dat,0,0);
            blit(double_buffer, screen, 0, 0, 0, 0,320,240);
            rest(150);
        }

        if (key[KEY_LEFT])  
        {
            sx--;
            draw_screen(2);
            draw_sprite(double_buffer,(BITMAP*)mobs[MON001+p-1].dat,0,0);
            blit_double_buffer_onto_screen();
            rest(50);
        }
        if (key[KEY_RIGHT])  
        {
            sx++;
            draw_screen(2);
            draw_sprite(double_buffer,(BITMAP*)mobs[MON001+p-1].dat,0,0);
            blit_double_buffer_onto_screen();
            rest(50);
        }
        if (key[KEY_UP])  
        {
            sy--;
            draw_screen(2);
            draw_sprite(double_buffer,(BITMAP*)mobs[MON001+p-1].dat,0,0);
            blit_double_buffer_onto_screen();
            rest(50);
        }
        if (key[KEY_DOWN])  
        {
            sy++;
            draw_screen(2);
            draw_sprite(double_buffer,(BITMAP*)mobs[MON001+p-1].dat,0,0);
            blit_double_buffer_onto_screen();
            rest(50);
        }

        if ( (mouse_b & 1) || (mouse_b & 2) )
        {
            x=mouse_x+ssx;y=mouse_y+ssy;
            if (mouse_b & 1) 
            {
                e=p;
            }
            if (mouse_b & 2) 
            {
                e=0;
            }
            show_mouse(NULL);
            putpixel(mobmap,(x>>4)+sx,(y>>4)+sy,e);
            draw_screen(2);
            draw_sprite(double_buffer,(BITMAP*)mobs[MON001+p-1].dat,0,0);
            blit_double_buffer_onto_screen();
            show_mouse(screen);
        }
        if (key[KEY_ESC])  
        {
            done=1;
        }
    }
    while (key[KEY_ESC])  {}
    save(2);
    show_mouse(NULL);
}

void set_blacks(int l1,int l2,int l3)
{
    static RGB black = { 0, 0, 0 };

    vsync();

    set_color(0, &black);
}

int main(void)
{
    int done=0,game_play=0,kl=NIN,i,cnt=0,
    dirl=0,dirr=0,diru=0,dird=0;

    allegro_init();
    install_keyboard(); 
    install_timer();
    install_mouse();
    if (install_music()<0) return -1;

    game=load_datafile("data.dat");
    guy=load_datafile("guy.dat");
    mobs=load_datafile("monster.dat");

    gamemap = load_pcx("map.map",map_pal);
    objmap = load_pcx("obj.map",map_pal);
    mobmap = load_pcx("mob.map",map_pal);

    //printf("Generating RGB Table (3.25 lines to go)\n");
    create_rgb_table(&rgb_table,(RGB*)game[PALLETE_01].dat,NULL);
    rgb_map = &rgb_table;

    /* build a color lookup table for lighting effects */
    //printf("\nGenerating Lighting Table (3.25 lines to go)\n");
    create_light_table(&light_table, (RGB*)game[PALLETE_01].dat, 0, 0, 0,NULL);

    /* build a color lookup table for translucent drawing */
    printf("\nGenerating Transparency Table (3.25 lines to go)\n");
    create_trans_table(&trans_table, (RGB*)game[PALLETE_01].dat, 128, 128, 128,NULL);

    set_gfx_mode(GFX_AUTODETECT, 320,240, 0, 0);

    rectfill(screen,0,0,320,320,240);
    s = create_bitmap(320, 240);

    spotlight = create_bitmap(160, 160);
    clear(spotlight);
    for(i=0; i<256; i++)
    {
        circlefill(spotlight, 80, 80, 80-i/4, i);
    }

    /* select the lighting table */
    color_map = &light_table;

    double_buffer = create_bitmap(SCREEN_W, SCREEN_H);
    clear(double_buffer);

    srand((int)time(NULL));
    set_pallete((RGB*)game[PALLETE_01].dat);
    set_blacks(16,54,63);
    get_screen(sx+8,sy+8);
    init_player();
    init_bomb();
    init_bullet();
    init_monsters();

    while (!game_play)
    {
        while (!done)
        {
            if (kl==LEFT || kl==RIGHT) 
            {
                get_screen(sx+8,sy+8);
                kl=NIN;
                light=OFF;
                if (sy<wup) 
                {
                    player.y=player.y-16*(wup-sy)-ssy;
                    sy=wup;
                    ssy=0;
                }
                if (sy>(wdown-14)) 
                {
                    player.y=player.y+16*(sy-(wdown-14))+ssy;
                    sy=wdown-14;
                    ssy=0;
                }
                init_bomb();
                init_bullet();
                init_monsters();
            }
            if (kl==UP || kl==DOWN) 
            {
                get_screen(sx+8,sy+8);
                kl=NIN;
                light=OFF;
                if (sx<wleft) 
                {
                    player.x=player.x-16*(wleft-sx)-ssx;
                    sx=wleft;
                    ssx=0;
                }
                if (sx>(wright-14)) 
                {
                    player.x=player.x+16*(sx-(wright-14))+ssx;
                    sx=wright-14;
                    ssx=0;
                }
                init_bomb();
                init_bullet();
                init_monsters();
            }

            move_bullet();
            move_monsters();

            draw_screen(0);
            draw_guy();
            draw_bomb();
            draw_bullet();
            draw_monsters();

            if (light==ON)
            {
                blit_double_buffer_onto_screen();
            }
            else
            {
                draw_light();
            }
            rest(60);

            dirl=0;
            dirr=0;
            diru=0;
            dird=0;
            cnt++;
            if (cnt==1) 
            {
                cnt=0;
                if (key[KEY_ALT]) 
                {
                    fire_bullet();
                }
            }
            if (key[KEY_LEFT]) 
            {
                dirl=1;
            }
            if (key[KEY_RIGHT]) 
            {
                dirr=1;
            }
            if (key[KEY_UP]) 
            {
                diru=1;
            }
            if (key[KEY_DOWN]) 
            {
                dird=1;
            }
        
    
            if (dirl==0 && dirr==0 && diru==0 && dird==0) 
            {
                mv=0;
            }
    
    
            if (dirl==1)
            {
                if (player.dir==RIGHT) 
                {
                    mv=0;
                }
                mv++;
                if (mv==10) 
                {
                    mv=9;
                }
                player.dir=LEFT;
                if (check_move(LEFT,move[mv])==2) 
                {
                    kl=LEFT;
                }
            }
            if (dirr==1)
            {
                if (player.dir==LEFT) 
                {
                    mv=0;
                }
                mv++;
                if (mv==10) 
                {
                    mv=9;
                }
                player.dir=RIGHT;
                if (check_move(RIGHT,move[mv])==2) 
                {
                    kl=RIGHT;
                }
            }
            if (diru==1)
            {
                if (player.dir==DOWN) 
                {
                    mv=0;
                }
                mv++;
                if (mv==10) 
                {   
                    mv=9;
                }

                player.dir=UP;
                if (check_move(UP,move[mv])==2) 
                {
                    kl=UP;
                }
            }
            if (dird==1)
            {
                if (player.dir==UP) 
                {
                    mv=0;
                }
                mv++;
                if (mv==10) 
                {
                    mv=9;
                }
                player.dir=DOWN;
                if (check_move(DOWN,move[mv])==2) 
                {
                    kl=DOWN;
                }
            }
    
            if (key[KEY_SPACE])  {set_bomb();}
    
            if (key[KEY_LCONTROL] && key[KEY_RCONTROL])
            {
                if (key[KEY_E])  
                {
                    edit_screen();
                    kl=player.dir;
                }
                if (key[KEY_O])  
                {
                    edit_object();
                    kl=player.dir;
                }
                if (key[KEY_A])  
                {
                    edit_monsters();
                    kl=player.dir;
                }
            }
  
            if (player.hp<=0 || key[KEY_ESC] || won)  
            {
                done=1;
                game_play=1;
            }
        }
        done=0;
    }

    unload_datafile(game);
    unload_datafile(guy);
    unload_datafile(mobs);

    destroy_bitmap(double_buffer);
    destroy_bitmap(gamemap);
    destroy_bitmap(objmap);
    destroy_bitmap(mobmap);
    destroy_bitmap(spotlight);
    destroy_bitmap(s);

    return 0;
}
END_OF_MAIN();

