#include "allegro.h"
#include <stdio.h>

/* bias types : used to determine what type of pattern is made */
#define   EVEN  0
#define CLOUDS  1
#define  GRASS  2
#define   NONE  3

/* DHNL : declare bitmaps used here */
BITMAP *little_one;
BITMAP *buffer; /* the bitmap to put the squares on */
BITMAP *pattern2;



/* prototypes for all functions called from main : */
int random_number(int lower, int upper);
void set_up(void);
void multiflood(BITMAP *bmp);
void blades(BITMAP* grass_bmp);
void set_some_colours(void);
void set_some_grass_colours(void);
void set_dialogue_colours(void);
void make_a_pattern(BITMAP *bmp, int light, int dark);
void set_bias(int type);



int main(int argc, char* argv[])
{

  int bias;
  
  set_up();   /* initialise allegro, install the keyboard, seed rand(),
                set the colour depth (8), and finally set the GFX mode */

  if(!little_one || !buffer || !pattern2) {
      allegro_exit();
      printf(" Trouble in Main: couldn't create a bitmap.");
      exit(1);
  }

  set_palette(default_palette);

  set_some_colours();


  clear_keybuf();
  set_bias(NONE);
  make_a_pattern(little_one, 42, 44);
  blit(little_one, screen, 0, 0, 160, 200, little_one->w, little_one->h);
  textout(screen, font,
  " Welcome to a little demo of a pettern maker I wrote with Allegro and C.",
      10, 100, 15);
  textout(screen, font, " hit a key to see some patterns.", 150, 350, 15);
  readkey();


  bias = 3;
  while(!key[KEY_ESC])
  {
      ++bias;
      if (bias == 4) bias = 0;
      set_bias(bias);
      make_a_pattern(buffer, 0, 1);
      multiflood(buffer);
      textout(buffer, font,
        " hit a key for another or ESC to get to next bit. ", 10, 470, 15);
      blit(buffer,screen, 0, 0, 0, 0, 640, 480);
      readkey();
  }


  
  clear(screen);
  textout(screen, font,
  " That's all for now. (Couldn't get flowers to work). Thanks.   c u",
  20, 100, 15);
  readkey();

  allegro_exit();

  return 0;
}
END_OF_MAIN();


/* definitions of functions called from main (except make_a_pattern() ) */

int random_number(int lower, int upper) 
{
    int rand_numb = lower + rand() %(upper - lower + 1);
    return rand_numb;
}

void set_up(void)
{
     allegro_init();

     install_keyboard();

     install_mouse();
     install_timer();
  
     srand(time(NULL));
  
     set_color_depth(8);

     if(set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) != 0) {
          allegro_exit();
          printf("Error: couldn't set the gfx mode.");
          exit(1);
     }
     
     /* DHNL : put the bitmap creation over here */
     little_one = create_bitmap(240, 96);
     buffer = create_bitmap(640,480); /* the bitmap to put the squares on */
     pattern2 = create_bitmap(640,480);
}

void multiflood(BITMAP *bmp)
{
   int x, y;

   int colors1[4] = {  101, 103, 105, 107  };
   int colors2[3] = {  102, 104, 106  };

   for(y = 0; y < bmp->h; ++y)
   {
        for(x = 0; x < bmp->w; ++x)
        {
            if(_getpixel(bmp, x, y) == 0)
                floodfill(bmp, x, y, colors1[random_number(0, 3)]);
            else if(_getpixel(bmp, x, y) == 1)
                floodfill(bmp, x, y, colors2[random_number(0, 2)]);
        }
   }
}

void set_some_grass_colours(void)
{
    RGB lightest_col = { 10, 48, 4 };

    RGB  darkest_col = { 1, 36, 2 };
    
    int colors_to_set; /* DHNL : declared here, so it can be used later */

    int first = 100;  /* for lightest colour */
    int last = 108;
    

    /*  eg if first is 16 and last is 56 there is 41 colours between and
       including these two */

    RGB color;
    int count;

    int dr = lightest_col.r - darkest_col.r;  /* eg 40 */
    int dg = lightest_col.g - darkest_col.g;  /*    0  */
    int db = lightest_col.b - darkest_col.b;  /*    40 */

    set_color( first, &lightest_col); /* DHNL : moved this and next two lines over here, so the gcc compiler won't complain about parse errors and undeclared vars */
    set_color( last, &darkest_col);

    colors_to_set = last - first + 1;
    
    for(count = first; count <= last; ++count)   /* 16 to 56 */
    {
        color.r = lightest_col.r /* 50 */ -
            ( ((float) count - (float) first)/ (float) colors_to_set) * dr;
        color.g = lightest_col.g -
            ( ((float) count - (float) first)/ (float) colors_to_set) * dg;
        color.b = lightest_col.b -
            ( ((float) count - (float) first)/ (float) colors_to_set) * db;

        set_color(count, &color);
    }
}



void set_some_colours(void)
{
    RGB lightest_col = { 0, 0, 58 };

    RGB  darkest_col = { 0, 0, 10 };

    int first = 100;  /* for lightest colour */
    int last = 108;

    int colors_to_set; /* DHNL : see function above */
    

    /*  eg if first is 16 and last is 56 there is 41 colours between and
       including these two */

    RGB color;
    int count;

    int dr = lightest_col.r - darkest_col.r;  /* eg 40 */
    int dg = lightest_col.g - darkest_col.g;  /*    0  */
    int db = lightest_col.b - darkest_col.b;  /*    40 */

    set_color( first, &lightest_col); /* DHNL : see function above */
    set_color( last, &darkest_col);

    colors_to_set = last - first + 1;
    
    for(count = first; count <= last; ++count)   /* 16 to 56 */
    {
        color.r = lightest_col.r /* 50 */ -
            ( ((float) count - (float) first)/ (float) colors_to_set) * dr;
        color.g = lightest_col.g -
            ( ((float) count - (float) first)/ (float) colors_to_set) * dg;
        color.b = lightest_col.b -
            ( ((float) count - (float) first)/ (float) colors_to_set) * db;

        set_color(count, &color);
    }
}


/* blades : makes a grassy coloured pattern look more grass-like */
void blades(BITMAP* grass_bmp)
{

    int x, y;
    int colour;
    int columnsize;
    int y_lastpixelofcolumn;
    int replacementcolour;
    int r, r2;
    int y_lastpixelofblade;
    int minblade,maxblade;
    int temp;


    for(x = 0; x < grass_bmp->w; ++x) { /* for each column in double buffer */
       y = 0;
       while(!(y > grass_bmp->h - 1)) {
          /* if there's any pixels left to fiddle with
          in this (screen high) column. FIRST: get colour and number of
          that colour.y = 0 on first run but must indicate the first pixel
          of next column in subsequent runs */
          colour = getpixel(grass_bmp, x, y);
          columnsize = 1;
          ++y; /* y of 2nd pixel in column */
          while(getpixel(grass_bmp, x, y) == colour) {
             ++y;
             ++columnsize;
          }
          temp = colour;
          /* columnsizecount now holds the number of pixels
          in the column that are the same colour.
          y is the y coord of the last pixel of this column */
          /* SECOND: now have a column of pixels the same colour.
          Need to know where it started */
          y = y - columnsize;
          /* y then is now first pixel of this column.The last pixel
          of this column is at y = y + (columnsize - 1).*/
          y_lastpixelofcolumn = y + (columnsize - 1);
          /* now turn this column into blades */
          minblade = random_number(1,2);
          maxblade = random_number(3,4);
          while(!((y + (maxblade - 1)) > y_lastpixelofcolumn)) {
               /* if this condition is true, then we can put maxblade
               pixels in from y downwards without going past y_lastpixel
               ofcolumn */
               r2 = random_number(0,2);
               if (colour == 100)
                 colour = colour + random_number(0,3);

               else if (colour == 108)
                 colour = colour - random_number(0,3);

               else if (colour == 101 || colour == 107)
               {
                   if(r2 == 0) {
                       replacementcolour = (colour == 101) ? 100 : 108;
                   }
                   else
                   {
                       r2 = random_number(0,2);
                       replacementcolour = (colour == 101) ?
                             101 + r2 : 108 - r2;
                   }
               }
               else
               {
                    replacementcolour = (r2 == 0) ?
                       colour + random_number(1,2) :
                       colour - random_number(1,2);
               }
               r = random_number(minblade,maxblade); /* number of pixels to change */
               y_lastpixelofblade = y + (r - 1);
               while(y <= y_lastpixelofblade) {
                 putpixel(grass_bmp, x, y, replacementcolour);
                 ++y;
               }
               /* y is now first pixel of next blade */
          }
          /* there might be a few pixels left in this column as
          the loop above stopped when y + MAX_BLADE - 1 was greater
          than y_lastpixelofcolumn. So there's between MAX_BLADE - 1
          and 0 pixels left to do */
          r2 = random_number(0,1);
          replacementcolour = colour; /* quick solution */
          while(y <= y_lastpixelofcolumn) {
               putpixel(grass_bmp, x, y, replacementcolour);
               ++y;
          }
          if(!(y == y_lastpixelofcolumn + 1)) {
            allegro_exit();
            printf("Error: something odd happened doing colour replacing.");
            exit(1);
          }
          /* so y = y_lastpixelofcolumn + 1, which is the first pixel
          of next column to find the colour and length of etc.. */
       }
       /* end of while (!(y == 479)) */
   }
   /* end of for */
}

/* End of functions called from main */


/* to do with making the patterns : */


#define MAX_TILES_ACROSS 1000     /* tiles are 16*16 so you can't fill a
                                    a bitmap bigger than 16000 across */

/* function prototypes for all that are only from here on */
void first_line(void);
int choose_tile(int tiles[]);
int rtile(int tilenumber);
void blit_line(BITMAP *bmp, int tiles[], int y);

void get_choice(int acode, int dcode);
void another_line(int new_row[], int row_above[]);

void message(char message[]);
void codeforbelowerror(int tileabove, int second);

int get_acr_code(int tiletoleft);
int get_down_code(int tileabove, int second);

int across[11][40] =
{
/* 0  */
{1,4,5,206,207,8,9,11,212,214,16,18,219,220,21,22,223,224,225,27,28,32,233},
/* 1  */
{1,4,5,206,207,8,     212,214,16,       220,21,       224,225,27,28,32,233},
/* 2  */
{1,4,5,    207,8,9,11,    214,16,18,        21,22,223,        27,28,32,233},
/* 3  */
{2,10,15,26,30},
/* 4  */
{3,213,217,229,231},
/* 5  */
{1,5,207,214,21,27},
/* 6  */
{201,204,208,    216,    221,    228},
/* 7  */
{201,204,208,209,216,218,221,222,228},
/* 8  */
{1,5,207,206,214,220,21,225,27},
/* 9  */
{201,221},
/* 10  */
{201,204,205,7,208,14,216,221,227,228,232,33}
};

int down[30][20] =
{
/* for under 1 */
/* 0 */
{1,3,5,206,209,210,211,214,215,19,220,222,23,225,229,230,231},
/* 1 */
{1,3,5,    209,210,211,    215,19,220,    23,225,229,230    },
/* 2 */
{207,218,21,226,27,213},
/* 3 */
{1,3,  206,    210,211,214,215,19,220,222,23,    229,    231},
/* for under 2 */
/* 4 */
{1,3,5,206,    210,    214,215,   220,       225,229,230,231},
/* 5 */
{1,3,5,        210,        215,   220,       225,229,230,   },
/* 6 */
{213,226,21,27,207},
/* 7 */
{1,3,  206,    210,    214,215,   220,           229,    231},
/* for under 3 */
/* 8 */
{2,208,24,232},
/* 9 */
{2,208,24,216,232},
/* for under 5 */
/* 10 */
{4,212,217,28,233},
/* for under 6 */
/* 11 */
{1,5,220,225},
/* 12 */
{1,5,220,225,206,214},
/* for under 8 */
/* 13 */
{1,3,210,211,215,19,220,23,229},
/* 14 */
{1,3    ,211,215,19    ,23,  },
/* for under 10 */
/* 15 */
{1,3,210,215,220,229},
/* 16 */
{1,3    ,215        },
/* for under 11 */
/* 17 */
{212,217,28,233},
/* for under 12 */
/* 18 */
{207,21,27},
/* 19 */
{1,206,214,220},
/* for under 13 */
/* 20 */
{1,3,5,206,210,214,215,220,225,229,230,231},
/* 21 */
{1,3,5,    210,    215,220,225,229,230,   },
/* 22 */
{1,3,  206,210,214,215,220,   229,    231},
/* for under 20 */
/* 23 */
{1,220},
/* 24 */
{1},
/* for under 27 */
/* 25 */
{212,217,28,233}
};

int line1[MAX_TILES_ACROSS];
int evenline[MAX_TILES_ACROSS];
int oddline[MAX_TILES_ACROSS];
int choice[40];

int number_of_tiles_across; /* this set at the start and is used by
                               many functions */
int color1 ;
int color2 ;

void make_a_pattern(BITMAP *bmp, int light, int dark)
{
   int y;
   int lines;       /* the number of lines of tiles to do */

   if( bmp->w % 16 != 0 || bmp->h % 16 != 0)
            message("Bitmap dimensions not good for doing a pattern with 16*16 tiles on");
   else {
       number_of_tiles_across = bmp->w / 16;
       lines = bmp->h / 16;
       //allegro_exit();
       //printf("%d", lines);
       //exit(1);
   }
   color1 = light;
   color2 = dark;

   first_line();
   blit_line(bmp, line1, 0);
   
   another_line(evenline, line1);
   blit_line(bmp, evenline, 1);

   for(y = 2; y < lines; ++y)
   {
            another_line(oddline, evenline);
            blit_line(bmp, oddline, y);
            
            if(y < lines) ++y;
            another_line(evenline, oddline);
            blit_line(bmp, evenline, y);
   }
}



void first_line(void)
{
  int i, across_code;

  line1[0] = random_number(1,33);
  if(random_number(0,1) == 1) line1[0] += 200;
  
  i = 1;
  while(i < number_of_tiles_across)
  {
    across_code = get_acr_code( line1[i-1] );
    
    line1[i] = choose_tile( across[across_code/10] );
    
    if(across_code % 10 == 1) line1[i] = rtile(line1[i]);
    ++i;
  }
}



static int priority[67];

int choose_tile(int tiles[])
{
   int i, tilenumber, limits[40];
   int r;

   for(i = 0; tiles[i] != 0; i++)
   {
        tilenumber = tiles[i];
        if(tilenumber > 200)
             tilenumber = (tilenumber - 200) + 33;

        limits[i] = ((i == 0) ? priority[tilenumber]
                       : priority[tilenumber] + limits[i-1]);
   }

   r = random_number(0, limits[i-1]);

   while(i < 40) {
       limits[i] = 0;
       ++i;
   }

   for(i = 0;; ++i)
       if(r <= limits[i]) {
              return tiles[i];
       }
       
   message("\n\n OFF THE RAILS in choose_tile().\n\n No tile was chosen.");
}




int rtile  (int tilenumber)
{
   return (tilenumber > 200) ? (tilenumber - 200) : (tilenumber + 200);
}



/* chooses tiles for new_row */
void another_line(int new_row[], int row_above[])
{

 int dcode, acode, i = 1;
 int guide;

 /* new_row[0] done seperately */
 
 if(row_above[0] > 200) {
   dcode = get_down_code(rtile(row_above[0]), rtile(row_above[1]) );
 }
 else {
   dcode = get_down_code(row_above[0], row_above[1]);
 }
 new_row[0] = choose_tile(down[dcode]);
 if(row_above[0] > 200) {
     new_row[0] = rtile(new_row[0]);
 }

 /* now for all but the last */
 for(i = 1; i < (number_of_tiles_across - 1); ++i) {

   /* e.g if number_.. is 40 ,last cell filled will be 38 */

   if(row_above[i] > 200) {
     dcode = get_down_code( rtile(row_above[i]), rtile(row_above[i+1]));
     dcode = (dcode * 10) + 1;
   }
   else {
     dcode = get_down_code(row_above[i], row_above[i+1]);
     dcode = dcode * 10;
   }

   acode = get_acr_code(new_row[i-1]);

   get_choice(acode, dcode);

   new_row[i] = choose_tile( choice );
 }

 /* must still get last tile ( new_row[ number_of_tiles_across -1 ] ) */
 
 acode = get_acr_code(row_above[number_of_tiles_across - 1]); /* eg 39 */
 guide = choose_tile( across[acode/10]);
 if(acode % 10 == 1) {
    guide = rtile(guide);
 }
 acode = get_acr_code(new_row[number_of_tiles_across - 2]);
 if(row_above[number_of_tiles_across - 1] > 200) {
     dcode = get_down_code(rtile  (row_above[number_of_tiles_across - 1]), rtile(guide));
     dcode = (dcode * 10) + 1;
 }
 else {
     dcode = get_down_code(row_above[number_of_tiles_across - 1], guide);
     dcode = dcode * 10;
 }
 get_choice(acode, dcode);
 new_row[number_of_tiles_across - 1] = choose_tile( choice );

 new_row[number_of_tiles_across] = 0;

} /* end of function. (  another_line()  ) */

void get_choice(int acode, int dcode)
{
   int Atiles[40], Dtiles[20];
   int a,b,c;
   int exhibit;

   /* get the right across tiles */
   for(a = 0; a < 40 && across[acode/10][a] != 0; ++a)
   {
     Atiles[a] = across[acode/10][a];
     if(acode % 10 == 1) {
          Atiles[a] = rtile  (Atiles[a]);
     }
   }
   if(a == 0) {
       allegro_exit();
       printf("\nproblem: in get_choice():");
       printf("\n\nno tiles in across[ %d ][].", acode/10);
       exit(1);
   }

   while(a < 40) {
      Atiles[a] = 0;
      ++a;
   }
   /* get the right down tiles */
   for(b = 0; b < 20 && down[dcode/10][b] != 0; ++b)
   {
      Dtiles[b] = down[dcode/10][b];
      if(dcode % 10 == 1) {
          Dtiles[b] = rtile(Dtiles[b]);
      }
   }
   if(b == 0) {
       allegro_exit();
       printf("\nproblem: in get_choice():");
       printf("\n\nno tiles in down[ %d ][].", dcode/10);
       exit(1);
   }

   while(b < 20) {
      Dtiles[b] = 0;
      ++b;
   }
   c = 0;
   for(a = 0; a < 40 && (exhibit = Atiles[a]) != 0; ++a) {
      /* if it's in Dtiles[] put in choicce[] */
      for(b = 0; b < 20 && Dtiles[b] != 0; ++b) {

         if(exhibit == Dtiles[b]) {
             choice[c] = exhibit;
             ++c;

         }
      }
   }

   if(c == 0) {
       allegro_exit();
       printf("\nproblem: in get_choice():");
       printf("\n\nno tiles in choice[].");
       printf("\n\nacode is: %d", acode);
       printf("\n\ndcode is: %d", dcode);
       exit(1);
   }
   while(c < 40) {
       choice[c] = 0;
       ++c;
   }
}

void blit_line(BITMAP *bmp, int tiles[], int y)
{
   int i, row, first_col, second_col;

   for(i = 0; i < number_of_tiles_across; ++i)
   {
      row = 0;
      if (tiles[i] == 1  ||  tiles[i] == 201)
      {
          first_col = (tiles[i] == 1) ? color1 : color2;
          for(row = 0; row < 16; ++row)
          {
               hline(bmp, i * 16, y * 16 + row, i * 16 + 15, first_col);
          }
      }
      else if (tiles[i] == 2  ||  tiles[i] == 202)
      {
          first_col = (tiles[i] == 2) ? color2 : color1;
         second_col = (tiles[i] == 2) ? color1 : color2;
         row = 0;
            
         while (row <= 2)
         {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 8, first_col);
             hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);
         }
         hline(bmp, i * 16, y * 16 + row, i * 16 + 7, first_col);
         hline(bmp, i * 16 + 8, y * 16 + row++, i * 16 + 15, second_col);

         hline(bmp, i * 16, y * 16 + row, i * 16 + 7, first_col);
         hline(bmp, i * 16 + 8, y * 16 + row++, i * 16 + 15, second_col);

         hline(bmp, i * 16, y * 16 + row, i * 16 + 6, first_col);
         hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);

         hline(bmp, i * 16, y * 16 + row, i * 16 + 5, first_col);
         hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);

         hline(bmp, i * 16, y * 16 + row, i * 16 + 4, first_col);
         hline(bmp, i * 16 + 5, y * 16 + row++, i * 16 + 15, second_col);

         hline(bmp, i * 16, y * 16 + row, i * 16 + 2, first_col);
         hline(bmp, i * 16 + 3, y * 16 + row++, i * 16 + 15, second_col);

         while( row <= 15)
         {
             hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, second_col);
         }
      }


      else if (tiles[i] == 3  ||  tiles[i] == 203)
      {
          first_col = (tiles[i] == 3) ? color2 : color1;
         second_col = (tiles[i] == 3) ? color1 : color2;

         while (row <= 6)
             hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, second_col);
         hline(bmp, i * 16, y * 16 + row, i * 16 + 2, first_col);
         hline(bmp, i * 16 + 3, y * 16 + row++, i * 16 + 15, second_col);

         hline(bmp, i * 16, y * 16 + row, i * 16 + 4, first_col);
         hline(bmp, i * 16 + 5, y * 16 + row++, i * 16 + 15, second_col);

         hline(bmp, i * 16, y * 16 + row, i * 16 + 5, first_col);
         hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);

         hline(bmp, i * 16, y * 16 + row, i * 16 + 6, first_col);
         hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);

         hline(bmp, i * 16, y * 16 + row, i * 16 + 7, first_col);
         hline(bmp, i * 16 + 8, y * 16 + row++, i * 16 + 15, second_col);

         hline(bmp, i * 16, y * 16 + row, i * 16 + 7, first_col);
         hline(bmp, i * 16 + 8, y * 16 + row++, i * 16 + 15, second_col);

         while( row <= 15)
         {
            hline(bmp, i * 16, y * 16 + row, i * 16 + 8, first_col);
            hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);
         }
      }

      else if (tiles[i] == 4  ||  tiles[i] == 204)
      {
          first_col = (tiles[i] == 4) ? color1 : color2;
          second_col = (tiles[i] == 4) ? color2 : color1;

          while( row <= 2)
          {
            hline(bmp, i * 16, y * 16 + row, i * 16 + 6, first_col);
            hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);
          }
          hline(bmp, i * 16, y * 16 + row, i * 16 + 7, first_col);
          hline(bmp, i * 16 + 8, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 7, first_col);
          hline(bmp, i * 16 + 8, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 8, first_col);
          hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 9, first_col);
          hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 10, first_col);
          hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 12, first_col);
          hline(bmp, i * 16 + 13, y * 16 + row++, i * 16 + 15, second_col);
          while (row <= 15)
             hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);
      }

      else if (tiles[i] == 5  ||  tiles[i] == 205)
      {
          first_col = (tiles[i] == 5) ? color1 : color2;
          second_col = (tiles[i] == 5) ? color2 : color1;

          while (row <= 6)
             hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 12, first_col);
          hline(bmp, i * 16 + 13, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 10, first_col);
          hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 9, first_col);
          hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 8, first_col);
          hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 7, first_col);
          hline(bmp, i * 16 + 8, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 7, first_col);
          hline(bmp, i * 16 + 8, y * 16 + row++, i * 16 + 15, second_col);
          while( row <= 15)
          {
            hline(bmp, i * 16, y * 16 + row, i * 16 + 6, first_col);
            hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);
          }

      }

      else if (tiles[i] == 6  ||  tiles[i] == 206)
      {
          first_col = (tiles[i] == 6) ? color2 : color1;
          second_col = (tiles[i] == 6) ? color1 : color2;

          while (row <= 8)
             hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 10, first_col);
          hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 6, first_col);
          hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 4, first_col);
          hline(bmp, i * 16 + 5, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 3, first_col);
          hline(bmp, i * 16 + 4, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 1, first_col);
          hline(bmp, i * 16 + 2, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 0, first_col);
          hline(bmp, i * 16 + 1, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 15, second_col);

      }

      else if (tiles[i] == 7  ||  tiles[i] == 207)
      {
          first_col = (tiles[i] == 7) ? color2 : color1;
          second_col = (tiles[i] == 7) ? color1 : color2;

          hline(bmp, i * 16, y * 16 + row, i * 16 + 14, first_col);
          hline(bmp, i * 16 + 15, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 13, first_col);
          hline(bmp, i * 16 + 14, y * 16 + row++, i * 16 + 15, second_col);
          while (row <= 3)
          {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 12, first_col);
             hline(bmp, i * 16 + 13, y * 16 + row++, i * 16 + 15, second_col);
          }
          hline(bmp, i * 16, y * 16 + row, i * 16 + 11, first_col);
          hline(bmp, i * 16 + 12, y * 16 + row++, i * 16 + 15, second_col);

          while (row <= 6)
          {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 10, first_col);
             hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15, second_col);
          }
          while (row <= 10)
          {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 9, first_col);
             hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15, second_col);
          }
          while (row <= 15)
          {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 8, first_col);
             hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);
          }

      }

      else if (tiles[i] == 8  ||  tiles[i] == 208)
      {
          first_col = (tiles[i] == 8) ? color1 : color2;
          second_col = (tiles[i] == 8) ? color2 : color1;

          while (row <= 4)
          {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 8, first_col);
             hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);
          }

          while (row <= 8)
          {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 9, first_col);
             hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15, second_col);
          }
          while(row <= 10) {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 10, first_col);
             hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15, second_col);
          }
          hline(bmp, i * 16, y * 16 + row, i * 16 + 11, first_col);
          hline(bmp, i * 16 + 12, y * 16 + row++, i * 16 + 15, second_col);
          while (row <= 13)
          {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 12, first_col);
             hline(bmp, i * 16 + 13, y * 16 + row++, i * 16 + 15, second_col);
          }
          hline(bmp, i * 16, y * 16 + row, i * 16 + 13, first_col);
          hline(bmp, i * 16 + 14, y * 16 + row++, i * 16 + 15, second_col);
          
          hline(bmp, i * 16, y * 16 + row, i * 16 + 14, first_col);
          hline(bmp, i * 16 + 15, y * 16 + row++, i * 16 + 15, second_col);

      }

      else if ( tiles[i] == 9  ||  tiles[i] == 209)
      {
          first_col = (tiles[i] == 9) ? color1 : color2;
          second_col = (tiles[i] == 9) ? color2 : color1;

          hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 0, first_col);
          hline(bmp, i * 16 + 1, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 1, first_col);
          hline(bmp, i * 16 + 2, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 3, first_col);
          hline(bmp, i * 16 + 4, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 4, first_col);
          hline(bmp, i * 16 + 5, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 6, first_col);
          hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 10, first_col);
          hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15, second_col);

          while (row <= 15)
             hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);

      }

      else if (tiles[i] == 10  ||  tiles[i] == 210)
      {
          first_col = (tiles[i] == 10) ? color2 : color1;
          second_col = (tiles[i] == 10) ? color1 : color2;

          while (row <= 8)
             hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 4, second_col);
          hline(bmp, i * 16 + 5, y * 16 + row++, i * 16 + 15, first_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 8, second_col);
          hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, first_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 10, second_col);
          hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15, first_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 11, second_col);
          hline(bmp, i * 16 + 12, y * 16 + row++, i * 16 + 15, first_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 13, second_col);
          hline(bmp, i * 16 + 14, y * 16 + row++, i * 16 + 15, first_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 14, second_col);
          hline(bmp, i * 16 + 15, y * 16 + row++, i * 16 + 15, first_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 15, second_col);
      }

      else if ( tiles[i] == 11  ||  tiles[i] == 211)
      {
          first_col = (tiles[i] == 11) ? color1 : color2;
          second_col = (tiles[i] == 11) ? color2 : color1;

          hline(bmp, i * 16, y * 16 + row, i * 16, first_col);
          hline(bmp, i * 16 + 1, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 1, first_col);
          hline(bmp, i * 16 + 2, y * 16 + row++, i * 16 + 15, second_col);
          while (row <= 3)
          {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 2, first_col);
             hline(bmp, i * 16 + 3, y * 16 + row++, i * 16 + 15, second_col);
          }
          hline(bmp, i * 16, y * 16 + row, i * 16 + 3, first_col);
          hline(bmp, i * 16 + 4, y * 16 + row++, i * 16 + 15, second_col);

          while (row <= 6)
          {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 4, first_col);
             hline(bmp, i * 16 + 5, y * 16 + row++, i * 16 + 15, second_col);
          }
          while (row <= 10)
          {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 5, first_col);
             hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);
          }
          while (row <= 15)
          {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 6, first_col);
             hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);
          }

      }

      else if (tiles[i] == 12  ||  tiles[i] == 212)
      {
          first_col = (tiles[i] == 12) ? color2 : color1;
          second_col = (tiles[i] == 12) ? color1 : color2;

          while (row <= 4)
          {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 6, first_col);
             hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);
          }
          while (row <= 8)
          {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 5, first_col);
             hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);
          }
          while(row <= 10) {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 4, first_col);
             hline(bmp, i * 16 + 5, y * 16 + row++, i * 16 + 15, second_col);
          }
          hline(bmp, i * 16, y * 16 + row, i * 16 + 3, first_col);
          hline(bmp, i * 16 + 4, y * 16 + row++, i * 16 + 15, second_col);
          while (row <= 13)
          {
             hline(bmp, i * 16, y * 16 + row, i * 16 + 2, first_col);
             hline(bmp, i * 16 + 3, y * 16 + row++, i * 16 + 15, second_col);
          }
          hline(bmp, i * 16, y * 16 + row, i * 16 + 1, first_col);
          hline(bmp, i * 16 + 2, y * 16 + row++, i * 16 + 15, second_col);
          
          hline(bmp, i * 16, y * 16 + row, i * 16, first_col);
          hline(bmp, i * 16 + 1, y * 16 + row++, i * 16 + 15, second_col);
      }
      else if ( tiles[i] == 13 || tiles[i] == 213)
      {
          first_col = (tiles[i] == 13) ? color2 : color1;
          second_col = (tiles[i] == 13) ? color1 : color2;
          /* row 0 */
          hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);
          /* 1 */
          hline(bmp, i * 16, y * 16 + row, i * 16 + 14, first_col);
          hline(bmp, i * 16 + 15, y * 16 + row++, i * 16 + 15, second_col);
          /* 2 */
          hline(bmp, i * 16, y * 16 + row, i * 16 + 13, first_col);
          hline(bmp, i * 16 + 14, y * 16 + row++, i * 16 + 15, second_col);
          /* 3 */
          hline(bmp, i * 16, y * 16 + row, i * 16 + 11, first_col);
          hline(bmp, i * 16 + 12, y * 16 + row++, i * 16 + 15, second_col);
          /* 4 */
          hline(bmp, i * 16, y * 16 + row, i * 16 + 10, first_col);
          hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15, second_col);
          /* 5 */
          hline(bmp, i * 16, y * 16 + row, i * 16 + 8, first_col);
          hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);
          /* 6 */
          hline(bmp, i * 16, y * 16 + row, i * 16 + 4, first_col);
          hline(bmp, i * 16 + 5, y * 16 + row++, i * 16 + 15, second_col);

          while (row <= 15)
             hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, second_col);


      }

      else if ( tiles[i] == 14 || tiles[i] == 214)
      {
          first_col = (tiles[i] == 14) ? color2 : color1;
          second_col = (tiles[i] == 14) ? color1 : color2;

          while (row <= 8)
             hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 13, first_col);
          hline(bmp, i * 16 + 14, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 11, first_col);
          hline(bmp, i * 16 + 12, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 10, first_col);
          hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 9, first_col);
          hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 9, first_col);
          hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 8, first_col);
          hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 8, first_col);
          hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);
      }

      else if ( tiles[i] == 15  ||  tiles[i] == 215)
      {
          first_col = (tiles[i] == 15) ? color1 : color2;
          second_col = (tiles[i] == 15) ? color2 : color1;

          while (row <= 8)
             hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 1, first_col);
          hline(bmp, i * 16 + 2, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 3, first_col);
          hline(bmp, i * 16 + 4, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 4, first_col);
          hline(bmp, i * 16 + 5, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 5, first_col);
          hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 5, first_col);
          hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 6, first_col);
          hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 6, first_col);
          hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);
      }

      else if ( tiles[i] == 16  ||  tiles[i] == 216)
      {
          first_col = (tiles[i] == 16) ? color1 : color2;
          second_col = (tiles[i] == 16) ? color2 : color1;

          hline(bmp, i * 16, y * 16 + row, i * 16 + 8, first_col);
          hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 8, first_col);
          hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 9, first_col);
          hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 9, first_col);
          hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 10, first_col);
          hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 11, first_col);
          hline(bmp, i * 16 + 12, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 13, first_col);
          hline(bmp, i * 16 + 14, y * 16 + row++, i * 16 + 15, second_col);

          while (row <= 15)
             hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);

      }

      else if ( tiles[i] == 17  ||  tiles[i] == 217)
      {
          first_col = (tiles[i] == 17) ? color2 : color1;
          second_col = (tiles[i] == 17) ? color1 : color2;


          hline(bmp, i * 16, y * 16 + row, i * 16 + 6, first_col);
          hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 6, first_col);
          hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 5, first_col);
          hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 5, first_col);
          hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 4, first_col);
          hline(bmp, i * 16 + 5, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 3, first_col);
          hline(bmp, i * 16 + 4, y * 16 + row++, i * 16 + 15, second_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 1, first_col);
          hline(bmp, i * 16 + 2, y * 16 + row++, i * 16 + 15, second_col);

          while (row <= 15)
             hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, second_col);
      }

      else if ( tiles[i] == 18  ||  tiles[i] == 218)
      {
          first_col = (tiles[i] == 18) ? color1 : color2;
          second_col = (tiles[i] == 18) ? color2 : color1;

          _putpixel(bmp, i * 16, y * 16, first_col);
          hline(bmp, i * 16 + 1, y * 16, i * 16 + 14, second_col);
          _putpixel(bmp, i * 16 + 15, y * 16, first_col);
          ++row;
          hline(bmp, i * 16, y * 16 + row, i * 16 + 1, first_col);
          hline(bmp, i * 16 + 2, y * 16 + row, i * 16 + 13, second_col);
          hline(bmp, i * 16 + 14, y * 16 + row++, i * 16 + 15, first_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 4, first_col);
          hline(bmp, i * 16 + 5, y * 16 + row, i * 16 + 10, second_col);
          hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15, first_col);

          while (row <= 15)
             hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);
      }


      
      else if ( tiles[i] == 19  ||  tiles[i] == 219)
      {
             first_col = (tiles[i] == 19) ? color1 : color2;
            second_col = (tiles[i] == 19) ? color2 : color1;

            hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);

            _putpixel(bmp, i * 16, y * 16 + row, second_col);
            hline(bmp, i * 16 + 1, y * 16 + row++, i * 16 + 15, first_col);

            while(row <= 4) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 1, second_col);
                hline(bmp, i * 16 + 2, y * 16 + row++, i * 16 + 15, first_col);
            }
            while(row <= 10) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 2, second_col);
                hline(bmp, i * 16 + 3, y * 16 + row++, i * 16 + 15, first_col);
            }
            while(row <= 13) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 1, second_col);
                hline(bmp, i * 16 + 2, y * 16 + row++, i * 16 + 15, first_col);
            }

            _putpixel(bmp, i * 16, y * 16 + row, second_col);
            hline(bmp, i * 16 + 1, y * 16 + row++, i * 16 + 15, first_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 15, first_col);
      }

      else if ( tiles[i] == 20  ||  tiles[i] == 220)
      {
          first_col = (tiles[i] == 20) ? color2 : color1;
          second_col = (tiles[i] == 20) ? color1 : color2;

          while (row <= 12)
             hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 4, first_col);
          hline(bmp, i * 16 + 5, y * 16 + row, i * 16 + 10, second_col);
          hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15, first_col);

          hline(bmp, i * 16, y * 16 + row, i * 16 + 1, first_col);
          hline(bmp, i * 16 + 2, y * 16 + row, i * 16 + 13, second_col);
          hline(bmp, i * 16 + 14, y * 16 + row++, i * 16 + 15, first_col);

          _putpixel(bmp, i * 16, y * 16 + row, first_col);
          hline(bmp, i * 16 + 1, y * 16 + row, i * 16 + 14, second_col);
          _putpixel(bmp, i * 16 + 15, y * 16 + row, first_col);
      }

      else if( tiles[i] == 21 || tiles[i] == 221)
      {
             first_col = (tiles[i] == 21) ? color1 : color2;
            second_col = (tiles[i] == 21) ? color2 : color1;

            hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 14, first_col);
            _putpixel(bmp, i * 16 + 15, y * 16 + row++, second_col);

            while(row <= 4) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 13, first_col);
                hline(bmp, i * 16 + 14, y * 16 + row++, i * 16 + 15, second_col);
            }
            while(row <= 10) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 12, first_col);
                hline(bmp, i * 16 + 13, y * 16 + row++, i * 16 + 15, second_col);
            }
            while(row <= 13) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 13, first_col);
                hline(bmp, i * 16 + 14, y * 16 + row++, i * 16 + 15, second_col);
            }

            hline(bmp, i * 16, y * 16 + row, i * 16 + 14, first_col);
            _putpixel(bmp, i * 16 + 15, y * 16 + row++, second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 15, first_col);
      }


      else if ( tiles[i] == 22  ||  tiles[i] == 222)
      {
             first_col = (tiles[i] == 22) ? color1 : color2;
            second_col = (tiles[i] == 22) ? color2 : color1;

            hline(bmp, i * 16,     y * 16 + row,       i * 16     ,     first_col);
            hline(bmp, i * 16 + 1, y * 16 + row++, i * 16 + 15,    second_col);

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 1,      first_col);
            hline(bmp, i * 16 + 2, y * 16 + row++, i * 16 + 15,    second_col);

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 2 ,     first_col);
            hline(bmp, i * 16 + 3, y * 16 + row++, i * 16 + 15,    second_col);

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 4 ,     first_col);
            hline(bmp, i * 16 + 5, y * 16 + row++, i * 16 + 15,    second_col);

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 5 ,     first_col);
            hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15,    second_col);

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 6 ,     first_col);
            hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15,    second_col);

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 8 ,     first_col);
            hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15,    second_col);
            
            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 9 ,     first_col);
            hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15,    second_col);

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 12 ,     first_col);
            hline(bmp, i * 16 + 13, y * 16 + row++, i * 16 + 15,    second_col);
            
            while(row <= 15)
                hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);
      }

      else if ( tiles[i] == 23  ||  tiles[i] == 223)
      {
             first_col = (tiles[i] == 23) ? color2 : color1;
            second_col = (tiles[i] == 23) ? color1 : color2;

            hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, second_col);

            _putpixel(bmp, i * 16, y * 16 + row, first_col);
            hline(bmp, i * 16 + 1, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 1, first_col);
            hline(bmp, i * 16 + 2, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 2, first_col);
            hline(bmp, i * 16 + 3, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 2, first_col);
            hline(bmp, i * 16 + 3, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 3, first_col);
            hline(bmp, i * 16 + 4, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 4, first_col);
            hline(bmp, i * 16 + 5, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 5, first_col);
            hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 5, first_col);
            hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 6, first_col);
            hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);

            while(row <= 12) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 7, first_col);
                hline(bmp, i * 16 + 8, y * 16 + row++, i * 16 + 15, second_col);
            }
            while(row <= 15) {
                hline(bmp, i * 16 , y * 16 + row, i * 16 + 8, first_col);
                hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);
            }
      }

      else if ( tiles[i] == 24  ||  tiles[i] == 224)
      {
             first_col = (tiles[i] == 24) ? color2 : color1;
            second_col = (tiles[i] == 24) ? color1 : color2;

            while(row <= 2) {
                hline(bmp, i * 16 , y * 16 + row, i * 16 + 8, first_col);
                hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);
            }

            while(row <= 5) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 7, first_col);
                hline(bmp, i * 16 + 8, y * 16 + row++, i * 16 + 15, second_col);
            }

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 6, first_col);
            hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 5, first_col);
            hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 5, first_col);
            hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 4, first_col);
            hline(bmp, i * 16 + 5, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 3, first_col);
            hline(bmp, i * 16 + 4, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 2, first_col);
            hline(bmp, i * 16 + 3, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 2, first_col);
            hline(bmp, i * 16 + 3, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 1, first_col);
            hline(bmp, i * 16 + 2, y * 16 + row++, i * 16 + 15, second_col);

            _putpixel(bmp, i * 16, y * 16 + row, first_col);
            hline(bmp, i * 16 + 1, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, second_col);
      }

      else if ( tiles[i] == 25 || tiles[i] == 225)
      {
             first_col = (tiles[i] == 25) ? color2 : color1;
            second_col = (tiles[i] == 25) ? color1 : color2;

            while(row <= 6)
                hline(bmp, i * 16 , y * 16 + row++, i * 16 + 15, first_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 12, first_col);
            hline(bmp, i * 16 + 13, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 9, first_col);
            hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 8, first_col);
            hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 6, first_col);
            hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 5 , first_col);
            hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 4, first_col);
            hline(bmp, i * 16 + 5, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 2, first_col);
            hline(bmp, i * 16 + 3, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 1, first_col);
            hline(bmp, i * 16 + 2, y * 16 + row++, i * 16 + 15, second_col);

            _putpixel(bmp, i * 16, y * 16 + row, first_col);
            hline(bmp, i * 16 + 1, y * 16 + row++, i * 16 + 15, second_col);
      }



      else if ( tiles[i] == 26  ||  tiles[i] == 226)
      {
             first_col = (tiles[i] == 26) ? color2 : color1;
            second_col = (tiles[i] == 26) ? color1 : color2;

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 14    ,     first_col);
            hline(bmp, i * 16 + 15, y * 16 + row++, i * 16 + 15,    second_col);

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 13,      first_col);
            hline(bmp, i * 16 + 14, y * 16 + row++, i * 16 + 15,    second_col);

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 12 ,     first_col);
            hline(bmp, i * 16 + 13, y * 16 + row++, i * 16 + 15,    second_col);

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 10 ,     first_col);
            hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15,    second_col);

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 9 ,     first_col);
            hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15,    second_col);

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 8 ,     first_col);
            hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15,    second_col);

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 6 ,     first_col);
            hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15,    second_col);
            
            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 5 ,     first_col);
            hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15,    second_col);

            hline(bmp, i * 16,     y * 16 + row,       i * 16 + 2 ,     first_col);
            hline(bmp, i * 16 + 3, y * 16 + row++, i * 16 + 15,    second_col);
            
            while(row <= 15)
                hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, second_col);
      }

      else if ( tiles[i] == 27 || tiles[i] == 227)
      {
             first_col = (tiles[i] == 27) ? color1 : color2;
            second_col = (tiles[i] == 27) ? color2 : color1;

            hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 14, first_col);
            _putpixel(bmp, i * 16 + 15, y * 16 + row++, second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 13,  first_col);
            hline(bmp, i * 16 + 14, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 12,  first_col);
            hline(bmp, i * 16 + 13, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 12,  first_col);
            hline(bmp, i * 16 + 13, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 11,  first_col);
            hline(bmp, i * 16 + 12, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 10,  first_col);
            hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 9,  first_col);
            hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 9,  first_col);
            hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 8,  first_col);
            hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15,  second_col);

            while(row <= 12) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 7,  first_col);
                hline(bmp, i * 16 + 8, y * 16 + row++, i * 16 + 15,  second_col);
            }
            while(row <= 15) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 6,  first_col);
                hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15,  second_col);
            }
      }

      else if ( tiles[i] == 28 || tiles[i] == 228)
      {
             first_col = (tiles[i] == 28) ? color1 : color2;
            second_col = (tiles[i] == 28) ? color2 : color1;

            while(row <= 2) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 6,  first_col);
                hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15,  second_col);
            }

            while(row <= 5) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 7,  first_col);
                hline(bmp, i * 16 + 8, y * 16 + row++, i * 16 + 15,  second_col);
            }

            hline(bmp, i * 16, y * 16 + row, i * 16 + 8,  first_col);
            hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 9,  first_col);
            hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 9,  first_col);
            hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 10,  first_col);
            hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 11,  first_col);
            hline(bmp, i * 16 + 12, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 12,  first_col);
            hline(bmp, i * 16 + 13, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 12,  first_col);
            hline(bmp, i * 16 + 13, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 13,  first_col);
            hline(bmp, i * 16 + 14, y * 16 + row++, i * 16 + 15,  second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 14, first_col);
            _putpixel(bmp, i * 16 + 15, y * 16 + row++, second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 15, first_col);
      }


      else if ( tiles[i] == 29  ||  tiles[i] == 229)
      {
             first_col = (tiles[i] == 29) ? color1 : color2;
            second_col = (tiles[i] == 29) ? color2 : color1;

            while(row <= 6)
                hline(bmp, i * 16 , y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 2, first_col);
            hline(bmp, i * 16 + 3, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 5, first_col);
            hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 6, first_col);
            hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 8, first_col);
            hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 9 , first_col);
            hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 10, first_col);
            hline(bmp, i * 16 + 11, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 12, first_col);
            hline(bmp, i * 16 + 13, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16 , y * 16 + row, i * 16 + 13, first_col);
            hline(bmp, i * 16 + 14, y * 16 + row++, i * 16 + 15, second_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 14, first_col);
            _putpixel(bmp, i * 16 + 15, y * 16 + row, second_col);

      }


      else if ( tiles[i] == 30  ||  tiles[i] == 230)
      {
             first_col = (tiles[i] == 30) ? color2 : color1;
            second_col = (tiles[i] == 30) ? color1 : color2;

            while(row <= 6)
                hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 9, first_col);
            hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15, second_col);
            hline(bmp, i * 16, y * 16 + row, i * 16 + 5, first_col);
            hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, second_col);

            while(row <= 15)
                hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, second_col);
      }
      else if ( tiles[i] == 31  ||  tiles[i] == 231)
      {
             first_col = (tiles[i] == 31) ? color2 : color1;
            second_col = (tiles[i] == 31) ? color1 : color2;

            while(row <= 6)
                hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, first_col);

            hline(bmp, i * 16, y * 16 + row, i * 16 + 5, second_col);
            hline(bmp, i * 16 + 6, y * 16 + row++, i * 16 + 15, first_col);
            hline(bmp, i * 16, y * 16 + row, i * 16 + 9, second_col);
            hline(bmp, i * 16 + 10, y * 16 + row++, i * 16 + 15, first_col);

            while(row <= 15)
                hline(bmp, i * 16, y * 16 + row++, i * 16 + 15, second_col);
      }

      else if ( tiles[i] == 32  ||  tiles[i] == 232)
      {
             first_col = (tiles[i] == 32) ? color1 : color2;
            second_col = (tiles[i] == 32) ? color2 : color1;

            while(row <= 5) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 8, first_col);
                hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);
            }
            while(row <= 9) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 7, first_col);
                hline(bmp, i * 16 + 8, y * 16 + row++, i * 16 + 15, second_col);
            }
            while(row <= 15) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 6, first_col);
                hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);
            }
      }

      else if ( tiles[i] == 33  ||  tiles[i] == 233)
      {
             first_col = (tiles[i] == 33) ? color2 : color1;
            second_col = (tiles[i] == 33) ? color1 : color2;

            while(row <= 5) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 6, first_col);
                hline(bmp, i * 16 + 7, y * 16 + row++, i * 16 + 15, second_col);
            }
            while(row <= 9) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 7, first_col);
                hline(bmp, i * 16 + 8, y * 16 + row++, i * 16 + 15, second_col);
            }
            while(row <= 15) {
                hline(bmp, i * 16, y * 16 + row, i * 16 + 8, first_col);
                hline(bmp, i * 16 + 9, y * 16 + row++, i * 16 + 15, second_col);
            }
      }
      else
          message(" CAME OFF THE RAILS: in blit_line. \n\n Tile number no good.");
   }/* end of for */

} /* end of blit_line */




/* all following code is for choosing a tile */
void set_bias(int type)
{
    int i;

    if(type == NONE)
           for(i = 1; i <= 67; ++i)
                priority[i] = 10;
    else if( type == EVEN ) {
           priority[0] = 0;
           priority[1] = 9000;
           priority[34] = 50;
           for(i =  2; i <= 5;  ++i)
                  priority[i] = priority[i+33] = 200;
           for(i =  6; i <= 13; ++i)
                  priority[i] = priority[i+33] = 100;
           for(i = 14; i <= 17; ++i)
                  priority[i] = priority[i+33] = 200;
           for(i = 18; i <= 21; ++i)
                  priority[i] = priority[i+33] = 100;
           for(i = 22; i <= 29; ++i)
                  priority[i] = priority[i+33] = 500;
           for(i = 30; i <= 33; ++i)
                  priority[i] = priority[i+33] = 100;
     }
     else if(type == CLOUDS)
     {
          priority[1] = random_number(200,2000);
         priority[34] = random_number(500,8000);

          priority[2] = 1;
          priority[3] = 1;
          priority[4] = 1;
          priority[5] = 1;

         priority[35] = 10;
         priority[36] = 10;
         priority[37] = 10;
         priority[38] = 10;

          priority[6] = 50;
          priority[7] =  1;
          priority[8] =  1;
          priority[9] = 10;
         priority[10] = 10;
         priority[11] =  1;
         priority[12] =  1;
         priority[13] = 50;

         priority[39] = 50;
         priority[40] =  1;
         priority[41] =  1;
         priority[42] = 10;
         priority[43] = 10;
         priority[44] =  1;
         priority[45] =  1;
         priority[46] = 50;
         
         priority[14] = 5;
         priority[15] = 5;
         priority[16] = 5;
         priority[17] = 5;
         
         priority[47] = 1;
         priority[48] = 1;
         priority[49] = 1;
         priority[50] = 1;
         
         priority[18] =  1;
         priority[19] =  1;
         priority[20] =  10;
         priority[21] =  1;
         
         priority[51] =  10;
         priority[52] =  100;
         priority[53] =   1;
         priority[54] =  10;

         priority[22] =  5;
         priority[23] =   1;
         priority[24] =   1;
         priority[25] =  50;
         priority[26] =  50;
         priority[27] =   1;
         priority[28] =   1;
         priority[29] =  0;
         
         priority[55] =  5;
         priority[56] =   1;
         priority[57] =   1;
         priority[58] =  50;
         priority[59] =  50;
         priority[60] =   1;
         priority[61] =   1;
         priority[62] =  5;

         priority[30] = 10;
         priority[31] = 10;
         priority[32] =   1;
         priority[33] =   1;

         priority[63] = 10;
         priority[64] = 10;
         priority[65] =   1;
         priority[66] =   1;
    }
    else if(type == GRASS)
     {
          priority[1] = 6000;
         priority[34] = 6000;

          priority[2] = 50;
          priority[3] = 50;
          priority[4] = 50;
          priority[5] = 50;

         priority[35] = 40;
         priority[36] = 40;
         priority[37] = 40;
         priority[38] = 40;

          priority[6] = 50;
          priority[7] = 50;
          priority[8] =  1;
          priority[9] = 50;
         priority[10] = 50;
         priority[11] =  1;
         priority[12] =  1;
         priority[13] = 50;

         priority[39] = 50;
         priority[40] =  1;
         priority[41] =  1;
         priority[42] = 50;
         priority[43] = 50;
         priority[44] =  1;
         priority[45] =  1;
         priority[46] = 50;
         
         priority[14] = 20;
         priority[15] = 20;
         priority[16] = 20;
         priority[17] = 20;
         
         priority[47] = 20;
         priority[48] = 20;
         priority[49] = 20;
         priority[50] = 20;

         priority[18] =  10;
         priority[19] =  10;
         priority[20] =  10;
         priority[21] =  10;
         
         priority[51] =  10;
         priority[52] =  10;
         priority[53] =   10;
         priority[54] =  10;
         
         priority[22] =  1;
         priority[23] =   40;
         priority[24] =   40;
         priority[25] =  40;
         priority[26] =  40;
         priority[27] =   40;
         priority[28] =  40;
         priority[29] =   1;
         
         priority[55] =  1;
         priority[56] =   40;
         priority[57] =   40;
         priority[58] =  40;
         priority[59] =  40;
         priority[60] =   40;
         priority[61] =   40;
         priority[62] =  1;

         priority[30] = 40;
         priority[31] = 40;
         priority[32] =  40;
         priority[33] =  40;

         priority[63] = 40;
         priority[64] = 40;
         priority[65] =   40;
         priority[66] =   40;
    }
}



/* this function returns the right index to use for
the arrays in across[][] */
int get_acr_code(int tiletoleft)
{
     switch(tiletoleft) {
        case 1: case 19:                                      return 0;
        case 2: case 17: case 12: case 24:                    return 10;
        case 3: case 215: case 211: case 23:                  return 20;
        case 4: case 6: case 22: case 14: case 31:            return 30;
        case 5: case 216: case 225: case 230: case 209:       return 40;
        case 7: case 227:                                     return 50;
        case 8: case 28:                                      return 60;
        case 10: case 20: case 29:                            return 70;
        case 13: case 18: case 26:                            return 80;
        case 21:                                              return 90;
        case 32: case 233:                                    return 100;
        /* now for ones that indicate inverting */
        case 201: case 219:                                   return 1;
        case 202: case 217: case 212: case 224:               return 11;
        case 203: case 15: case 11: case 223:                 return 21;
        case 204: case 206: case 222: case 214: case 231:     return 31;
        case 205: case 16: case 25: case 30: case 9:          return 41;
        case 207: case 27:                                    return 51;
        case 208: case 228:                                   return 61;
        case 210: case 220: case 229:                         return 71;
        case 213: case 218: case 226:                         return 81;
        case 221:                                             return 91;
        case 232: case 33:                                    return 101;
        default:
           allegro_exit();
           printf("\n\nTROUBLE: in (getacrosscode):");
           printf("tilebefore is not catered for. (%d).", tiletoleft);
           exit(1);
     }
}



int get_down_code(int tileabove, int second)
{
  switch(tileabove) {
     case 1: case 18:
         switch(second) {
            case 1: case 4: case 8: case 9: case 16:
            case 18: case 21: case 22: case 28:
                 return 0;
            case 5: case 11: case 27: case 32:
                 return 1;
            case 206: case 212: case 219: case 220: case 224: case 225:
                 return 2;
            case 207: case 214: case 223: case 233:
                 return 3;
            default:
                codeforbelowerror(tileabove, second);
         }
     case 2: case 17:
         switch(second) {
            case 1: case 4: case 8: case 16: case 21: case 28:
                 return 4;
            case 5: case 27: case 32:
                 return 5;
            case 206: case 212: case 220: case 224: case 225:
                 return 6;
            case 207: case 214: case 233:
                 return 7;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 3: case 23:
         switch(second) {
            case 207: case 214: case 223: case 233:
                 return 8;
            case 1: case 4: case 5: case 8: case 9: case 11:
            case 16: case 18: case 21: case 22: case 27:
            case 28: case 32:
                 return 9;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 4: case 22:
         switch(second) {
            case 15:
                 return 1;
            case 2: case 10: case 26: case 30:
                 return 0;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 5:
         switch(second) {
            case 213: case 3: case 217: case 229: case 231:
                 return 10;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 6:
         switch(second) {
            case 15:
                 return 11;
            case 2: case 10: case 26: case 30:
                 return 12;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 7:
          switch(second) {
            case 207: case 214:
                 return 8;
            case 1:case 5: case 21: case 27:
                 return 9;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 8: case 28:
         switch(second) {
            case 201: case 204: case 216:
                 return 13;
            case 208: case 228: case 221:
                 return 14;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 9: case 16:
          switch(second) {
            case 203:
                 return 3;
            case 13: case 17: case 29: case 31:
                 return 0;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 10: case 29:
         switch(second) {
            case 201: case 204: case 209: case 216: case 218: case 222:
                 return 15;
            case 208: case 221: case 228:
                 return 16;

            default:
                 codeforbelowerror(tileabove, second);
         }
     case 11: case 15:
         switch(second) {
            case 205: case 211: case 227: case 232:
                 return 17;
            case 201: case 204: case 7: case 208: case 209: case 14:
            case 216: case 218: case 221: case 222: case 23:
            case 228: case 33:
                 return 10;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 12: case 24:
         switch(second) {
            case 1: case 4: case 8: case 16:
            case 21: case 28:
                 return 12;
            case 5: case 27: case 32:
                 return 11;
            case 206: case 212: case 220: case 224: case 225:
                 return 18;
            case 207: case 214: case 223: case 233:
                 return 19;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 13: case 26:
         switch(second) {
            case 1: case 21:
                 return 20;
            case 5: case 27:
                 return 21;
            case 207: case 214:
                 return 22;
            case 206: case 220: case 225:
                 return 6;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 14:
         switch(second) {
            case 2: case 10: case 15: case 26: case 30:
                 return 9;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 19:
         switch(second) {
            case 1: case 4: case 8: case 9: case 16:
            case 18: case 21: case 22: case 28:
                 return 12;
            case 5: case 11: case 27: case 32:
                 return 11;
            case 206: case 212: case 219: case 220: case 224: case 225:
                 return 18;
            case 207: case 214: case 223: case 233:
                 return 19;
            default:
                  codeforbelowerror(tileabove, second);
         }
     case 20:
         switch(second) {
            case 201: case 204: case 209: case 216: case 218: case 222:
                 return 23;
            case 208: case 221: case 228:
                 return 24;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 21:
         switch(second) {
            case 201:
                 return 13;
            case 221:
                 return 14;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 25:
         switch(second) {
            case 13: case 17: case 29: case 31:
                 return 12;
            case 203:
                 return 19;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 27:
          switch(second) {
            case 205: case 227:
                 return 25;
            case 201:case 221: case 7: case 14:
                 return 10;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 30:
          switch(second) {
            case 203:
                 return 7;
            case 13: case 17: case 29: case 31:
                 return 4;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 31:
         switch(second) {
            case 2: case 10: case 26: case 30:
                 return 20;
            case 15:
                 return 21;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 32:
         switch(second) {
            case 201: case 204: case 208: case 216: case 221: case 228:
            case 7: case 14: case 33:
                 return 10;
            case 205: case 227: case 232:
                 return 17;
            default:
                 codeforbelowerror(tileabove, second);
         }
     case 33:
         switch(second) {
            case 1: case 4: case 8: case 16: case 21: case 28:
            case 5: case 27: case 32:
                 return 9;
            case 207: case 214: case 233:
                 return 8;
            default:
                 codeforbelowerror(tileabove, second);
         }
     default:
       allegro_exit();
       printf("\n\ntrouble in get_down_code:");
       printf("\n\ntileabove wasn't valid. It was %d.", tileabove);
       exit(1);
  }
  /* end of switch(tileabove) */
}


void codeforbelowerror(int tileabove, int second)
{
    allegro_exit();
    printf("\n\n IN codeforbelow: tileabove was %d.", tileabove);
      printf("\n                     second was %d.", second);
    printf("\n second wasn't in the list.");
    exit(1);
}



void message(char m[])
{
   set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
   allegro_exit();
   printf("%s", message);
   exit(1);
}

