#include <allegro.h>
#include "quixo.h"
#include "draw.h"
#include "board.h"

int init_graphics() {
    int i;
    /* load the main datafile */
    main_datafile = load_datafile(MAIN_DATA_FILENAME);
    if (!main_datafile) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Error loading %s!\n", MAIN_DATA_FILENAME);
      return 0;
    }
    background_bmp = (BITMAP *)(main_datafile[MAIN_DATA_BACKGROUND].dat);
    game_over_bmp = (BITMAP *)(main_datafile[MAIN_DATA_GAME_OVER].dat);
    
    /* load the buttons datafile */
    buttons_datafile = load_datafile(BUTTONS_DATA_FILENAME);
    if (!buttons_datafile) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Error loading %s!\n", BUTTONS_DATA_FILENAME);
      return 0;
    }
    button_back_bmp = (BITMAP *)(buttons_datafile[BUTTONS_DATA_BACK].dat);

    /* load the blocks datafile */
    blocks_datafile = load_datafile(BLOCKS_DATA_FILENAME);
    if (!blocks_datafile) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Error loading %s!\n", BLOCKS_DATA_FILENAME);
      return 0;
    }
    
    for (i = BLOCK_BLANK; i <= BLOCK_O; i++)
    	blocks[i] = (BITMAP *)(blocks_datafile[i].dat);
    for (i = BLOCK_BLANK; i <= BLOCK_O; i++)
    	blocks_ch[i] = (BITMAP *)(blocks_datafile[i+3].dat);
   
    return 1;
}

int draw_screen() {
    BITMAP *scratch;
    scratch = create_bitmap(SCREEN_W, SCREEN_H);
    
    int i,j;
    
    if(back==0)
        button_back_bmp = (BITMAP *)(buttons_datafile[BUTTONS_DATA_BACK].dat);
    else
        button_back_bmp = (BITMAP *)(buttons_datafile[BUTTONS_DATA_BACK_CH].dat);
   
    blit(background_bmp, scratch, 0, 0, 0, 0, scratch->w, scratch->h);
    
    /* draw blocks */
    for (j = 0; j < 5; j++)
    {
    	for (i = 0; i < 5; i++)
    	{
    	    BITMAP *block = 0;
    	    
    	    if (board[i][j] == 0)
    	    {
    	        if (j*5+i==selected)
                   block = blocks_ch[BLOCK_BLANK];
                else
                   block = blocks[BLOCK_BLANK];
            }
    	    if (board[i][j] == 1)
    	    {
    	        if (j*5+i==selected)
                   block = blocks_ch[BLOCK_X];
                else
                   block = blocks[BLOCK_X];
            }
            if (board[i][j] == 2)
            {
    	        if (j*5+i==selected)
                   block = blocks_ch[BLOCK_O];
                else
                   block = blocks[BLOCK_O];
            }
            if (block) 
            {
        		draw_sprite(scratch, block, BOARD_X + BLOCK_SIZE*i,
        				                          BOARD_Y + BLOCK_SIZE*j);
            }			  
    	}
    } 

    /* this draws the back button on screen */
    draw_sprite(scratch, button_back_bmp, BUTTON_BACK_X, BUTTON_BACK_Y);
    
    /* this draws the block which tells whos turn is now */
    draw_sprite(scratch, blocks[who], CP_BLOCK_X, CP_BLOCK_Y);
    
    /* this draws the game_over message */
    if(game_over)
    {
        draw_sprite(scratch, game_over_bmp, GAME_OVER_X, GAME_OVER_Y);
        draw_sprite(scratch, blocks[3-who], GO_BLOCK_X, GO_BLOCK_Y);
    }
    /* Blit scratch on the screen. */
    scare_mouse();
    blit(scratch, screen, 0, 0, 0, 0, scratch->w, scratch->h);
    unscare_mouse();
    show_mouse(screen);
    destroy_bitmap(scratch);
}
