#include <allegro.h>
#include "quixo.h"
#include "ai.h"
#include "board.h"

int estimate_state(int b[5][5])
{
    int i, j, estimation;
    int player_max = 0;
    int adversary_max = 0;
    int temp_p, temp_a;
    
    /* checking vertically */
    for(i = 0; i < 5; i++)
    {
        temp_p = 0;
        temp_a = 0;
        for(j = 0; j < 5; j++) 
        {
            if(b[i][j] == COMPUTER_PLAYER) temp_p++;
            if(b[i][j] == 3-COMPUTER_PLAYER) temp_a++;
        }
        if(temp_p > player_max) player_max = temp_p;
        if(temp_a > adversary_max) adversary_max = temp_a;
    }
    /* checking horizontally */
    for(i = 0; i < 5; i++)
    {
        temp_p = 0;
        temp_a = 0;
        for(j = 0; j < 5; j++) 
        {
            if(b[j][i] == COMPUTER_PLAYER) temp_p++;
            if(b[j][i] == 3-COMPUTER_PLAYER) temp_a++;
        }
        if(temp_p > player_max) player_max = temp_p;
        if(temp_a > adversary_max) adversary_max = temp_a;
    }
    
    /* checking diagonally */
    temp_p = 0;
    temp_a = 0;
    for(i = 0; i < 5; i++) 
    {
        if(b[i][i] == COMPUTER_PLAYER) temp_p++;
        if(b[i][i] == 3-COMPUTER_PLAYER) temp_a++;
    }
    if(temp_p > player_max) player_max = temp_p;
    if(temp_a > adversary_max) adversary_max = temp_a;
    
    temp_p = 0;
    temp_a = 0;
    for(i = 0; i < 5; i++) 
    {
        if(b[4-i][i] == COMPUTER_PLAYER) temp_p++;
        if(b[4-i][i] == 3-COMPUTER_PLAYER) temp_a++;
    }
    if(temp_p > player_max) player_max = temp_p;
    if(temp_a > adversary_max) adversary_max = temp_a;
    /* end of diagonals check */
    
    estimation = player_max - adversary_max;
    if(player_max == 3) estimation += 1;
    if(player_max == 4) estimation += 2;
    if(player_max == 5) estimation += 90;
    if(adversary_max == 3) estimation -= 1;
    if(adversary_max == 4) estimation -= 2;
    if(adversary_max == 5) estimation -= 90;
    
    return estimation;
}

int is_terminal_node(int b[5][5]){
    if (estimate_state(b)>80 || estimate_state(b)<-80) return 1;
    else return 0;
}

int alpha_beta(int depth, int alpha, int beta, int s[5][5], int player)
{
    int state[5][5];
    int temp_state[5][5];
    int a, b, i, j, x, y, pos, sspos, spos, val;

    for(i=0; i<5; i++)
    	for (j=0; j<5; j++)
            state[i][j] = s[i][j];

    if (depth==0 || is_terminal_node(state)){
       if (player == COMPUTER_PLAYER)
            return estimate_state(state); 
   	   else
        	return -estimate_state(state);
    }
    
    for(i=0; i<5; i++)
    	for (j=0; j<5; j++)
    	    if((i==0 || i==4 || j==0 || j==4) && (state[i][j]==0 || state[i][j]==player))
    	    {
                for(a=0; a<5; a++)
                	for (b=0; b<5; b++)
                	    if(validate_move(b*5+a, j*5+i, player, state))
                	    {
                           pos = j*5+i;
                           for(x=0; x<5; x++)
                            	for (y=0; y<5; y++)
                                    temp_state[x][y] = state[x][y];
                           move(b*5+a, &pos, state, player);
                           val = -alpha_beta(depth-1, -beta, -alpha, state, 3-player);
                           for(x=0; x<5; x++)
                            	for (y=0; y<5; y++)
                                    state[x][y] = temp_state[x][y];
                            if (val>alpha)
                            {
                                alpha = val;
                                if(depth==DEPTH) {
                                    temp_spos = j*5+i;
                                    temp_pos = b*5+a;
                                }
                            }
                            if (alpha >= beta) return beta;
                        }
            }
    return alpha;
}
