#include <allegro.h>
#include "board.h"
#include "quixo.h"

void clear_board() 
{
     int i,j;
     for(i=0;i<5;i++)
         for(j=0;j<5;j++)
             board[i][j]=0;
     who = WHO_STARTS;
     game_over = 0;
     block_board = 0;
}

/* function which selects the block after clicking it,
   it also checks if the block is selectable or not   */
int select_block(int pos) {
    int x, y;
    /* here we are reading coordinates of block from pos variable*/
    x=pos%5;
    y=(pos-x)/5;
    
    /* checking if any other block is selected now ...*/
    if(selected < 0) 
    {
        /*... if not: checking if block we are trying to select
         is located near the band */
        if(  (board[x][y] == who || board[x][y] == 0 ) && 
             (x==0 || y==0 || x==4 || y==4)               ) 
        {
           /* making the block selected */
           selected=y*5+x;
        }
    } 
    /* if other block is selected now, we can only unselect it*/
    else 
    {
         if(y*5+x==selected) 
         {
             selected = -1;
         }
    }
}

int validate_move(int pos, int spos, int player, int b[5][5]) 
{
    int x, y, xs, ys;
   
    if(spos < 0 || spos == pos)
        return 0;
    else
    {
        x=pos%5;
        y=(pos-x)/5;
        xs=spos%5;
        ys=(spos-xs)/5;
        if(b[xs][ys] == player || b[xs][ys] == 0) {
            if(xs==0 || xs==4) {
                if((x==xs && (y==0 || y==4)) || (x==4-xs && y==ys))
                    return 1;
            }
            if(ys==0 || ys==4) {
                if((y==ys && (x==0 || x==4)) || (y==4-ys && x==xs))
                    return 1;
            }        
        }
    }
    return 0;
}

int move(int pos, int *spos, int b[5][5], int player) 
{
    int x, y, xs, ys;
    int i;
    x=pos%5;
    y=(pos-x)/5;
    xs=*spos%5;
    ys=(*spos-xs)/5;
    b[xs][ys] = 0;
    /*  TODO: wprowadzic tylko obsluge dwoch playerow
        i wczesniej w selectcie mozliwosc zaznaczania playera who */
    if(y==ys) 
    {
        if(x-xs>0) 
        {
            /* the loop which move blocksf to the band verticaly*/
            for(i=xs; i<4; i++)
                b[i][y] = b[i+1][y];
            b[4][y]=player;
        }
        if(x-xs<0) 
        {
            /* the loop which move blocks to the band horizontaly*/
            for(i=xs; i>0; i--)
                b[i][y] = b[i-1][y];
            b[0][y]=player;
        }
    }
    if(x==xs) 
    {
        if(y-ys>0) 
        {
            for(i=ys; i<4; i++)
                b[x][i] = b[x][i+1];
            b[x][4]=player;
        }
        if(y-ys<0) 
        {
            for(i=ys; i>0; i--)
                b[x][i] = b[x][i-1];
            b[x][0]=player;
        }
    }
    *spos = -1;
}

int check_gameover() 
{
    int i, j, over = 1, val;

    /* we need to check if there is 'gameover situation' on each row, column and
    diagonal so we need 3 loops*/
    
    /* checking vertically */
    for(i = 0; i < 5; i++)
    {
        over = 1;
        val = board[i][0];
        for(j = 0; j < 5; j++)
            if(board[i][j] != val || board[i][j]==0)
            {
                over = 0;
                break;
            }
        if(over) break;
    }
    if(!over) 
    {
        /* checking horizontally */
        for(i = 0; i < 5; i++) 
        {
            over = 1;
            val = board[0][i];
            for(j = 0; j < 5; j++)
                if(board[j][i] != val || board[j][i]==0)
                {
                    over = 0;
                    break;
                }
            if(over) break;
        }
    }
    
    /* checking diagonally */
    if(!over) 
    {
        over = 1;
        val = board[0][0];
        for(i=0; i<5; i++)
            if(board[i][i] != val || board[i][i]==0)
            {
                over = 0;
                break;
            }
    }
    
    if(!over) 
    {
        over = 1;
        val = board[4][0];
        for(i=0; i<5; i++)
            if(board[4-i][i] != val || board[4-i][i]==0)
            {
                over = 0;
                break;
            }
    }
    /* end of diagonals check */
    
    
    if(over) 
        return 1;
    return 0;
}
