#include <allegro.h>
#include "dialogs.h"
#include "quixo.h"
#include "draw.h"

char game_rules_string[] =
    "The rules of Quixo are very simple. The game board is a 5x5 grid of cubes."
    "Depending on the orientation, each cube may be showing either blank, an X,"
    "or an O. In turn, each player may remove either a blank cube or one 8"
    "their own cubes from the periphery of the board. If a blank cube was"
    "selected, the cube is turned so that it becomes the player's piece (either"
    "an X or an O). The player may then insert the piece somewhere along the"
    "periphery of the board such that the other cubes slide into the blank space"
    "once occupied by the cube that was removed. The resulting board is a"
    "complete 5x5 grid. The cube may not be placed directly back to the spot"
    "where it was removed. You will always have 2 possible ways to insert the"
    "new cube if it was removed from a corner, otherwise you will have 3"
    "possible ways to insert the cube.\n\n"
    "The game is over when a player gets 5 in a row, either horizontally,"
    "vertically, or diagonally.";

DIALOG rules_dialog[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h) (fg)(bg) (key) (flags)     (d1) (d2)    (dp)                   (dp2) (dp3) */
     { d_clear_proc,       0,   0,    0,    0,   1,  0,    0,      0,       0,   0,    NULL,                   NULL, NULL  },
     { d_button_proc,    470, 420,  160,   50,   1,  0,  'b', D_EXIT,       0,   0,    "&Back",                NULL, NULL  },
     { d_textbox_proc,   120, 100,  400,  200,   1,  0,    0,      0,       0,   0,    game_rules_string,      NULL, NULL  },
     {             0,      0,   0,    0,    0,   0,  0,    0,      0,       0,   0,          0,                   0,    0  }
};

#define RULES_BACK               1
#define RULES_TEXT               RULES_BACK+1

int do_rules_dialog() {
    int	ret;

    static short int init_colors = 1;
   
    /* set up colors */
    if(init_colors)
    {
        gui_fg_color = makecol(0, 0, 0);
        gui_bg_color = makecol(255, 255, 255);
        set_dialog_color(rules_dialog, gui_fg_color, gui_bg_color);
        rules_dialog[0].bg = makecol(95, 50, 25);
        rules_dialog[0].fg = makecol(0, 0, 0);
        rules_dialog[RULES_TEXT].bg = makecol(95, 50, 25);
        rules_dialog[RULES_TEXT].fg = makecol(255, 255, 255);
    
    init_colors = 0;
    }
    /* do the dialog */
    ret = do_dialog(rules_dialog, -1);
    
    /* quit button */
    if (ret == RULES_BACK)
    {
            return do_main_dialog();
    }
    return do_main_dialog();
}


DIALOG main_dialog[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h) (fg)(bg) (key) (flags)     (d1) (d2)    (dp)                   (dp2) (dp3) */
   /* the quit and info buttons use our customized dialog procedure, using dp3 as callback */
   { d_clear_proc,       0,   0,    0,    0,   1,  0,    0,      0,       0,   0,    NULL,                   NULL, NULL  },
   { d_bitmap_proc,      0,-200,  293,  100,   1,  0,    0,      0,       0,   0,    NULL,                   NULL, NULL  },
   { d_button_proc,     70, -50,  160,   50,   1,  0,  'o', D_EXIT,       0,   0,    "&One player",          NULL, NULL  },
   { d_button_proc,     70,  10,  160,   50,   1,  0,  't', D_EXIT,       0,   0,    "&Two players",         NULL, NULL  },
   { d_button_proc,     70,  70,  160,   50,   1,  0,  'r', D_EXIT | D_DISABLED,0,   0,    "&Resume game",         NULL, NULL  },
   { d_button_proc,     70, 130,  160,   50,   1,  0,  'u', D_EXIT,       0,   0,    "Game r&ules",               NULL, NULL  },
   { d_button_proc,     70, 190,  160,   50,   1,  0,  'x', D_EXIT,       0,   0,    "E&xit",                NULL, NULL  },
   {             0,      0,   0,    0,    0,   0,  0,    0,      0,       0,   0,          0,                   0,    0  }
};

#define MAIN_LOGO                1
#define MAIN_ONE_PLAYER          2
#define MAIN_TWO_PLAYERS         MAIN_ONE_PLAYER+1
#define MAIN_RESUME              MAIN_ONE_PLAYER+2
#define MAIN_RULES               MAIN_ONE_PLAYER+3
#define MAIN_EXIT                MAIN_ONE_PLAYER+4

int do_main_dialog() {
    int ret;
    
    static short int init_colors = 1;
   
    /* set up colors */
    if(init_colors)
    {
        gui_fg_color = makecol(0, 0, 0);
        gui_bg_color = makecol(255, 255, 255);
	    set_dialog_color(main_dialog, gui_fg_color, gui_bg_color);
    
    	main_dialog[0].bg = makecol(95, 50, 25);
     	main_dialog[0].fg = makecol(0, 0, 0);
	
	init_colors = 0;
    }
    /* loading logo */
    main_dialog[MAIN_LOGO].dp = main_datafile[MAIN_DATA_LOGO].dat;
    
    /* centre the dialog on screen */
    centre_dialog(main_dialog);
    
    /* do the dialog */
    clear_kbd(KEY_ESC); 
    ret = do_dialog(main_dialog, -1);
    clear_kbd(KEY_ESC); 
    
    /* if user exited by escape, determine what to do. */
    if (ret < 0)
    {
    	if (one_player_mode < 0)
    	    ret = MAIN_EXIT;
    	else
    	    ret = MAIN_RESUME;
    }
    /* first time? enable resume game button */
	if (first)
	{
	    main_dialog[MAIN_RESUME].flags ^= D_DISABLED;
	    first = 0;   /* we just started our first game */
	}
	
    /* check out if the resume game button was clicked */
    if (ret == MAIN_RESUME)
    {
    	return ret;
    }
    
    /* exit button */
    if (ret == MAIN_EXIT)
    {
        /* TODO: tutaj jeszcze uruchamia funkcje niszczace obiekty*/
    	exit_program = 1;
    	return ret;
    }
    
    /* one player button */
    if (ret == MAIN_ONE_PLAYER)
    {                
        clear_board();                        
        one_player_mode = 1;
    	return ret;
    }
    
    /* two players button */
    if (ret == MAIN_TWO_PLAYERS)
    {
        clear_board();                
        one_player_mode = 0;
    	return ret;
    }
    
    if (ret == MAIN_RULES)
    {
    	return do_rules_dialog();
    }
    return ret;
}
