#include <allegro.h>

#include "error.h"

#define BPS 30
volatile int timer;

void timer_handler(void)
{
	timer++;
}
END_OF_FUNCTION(timer_handler);

void timer_init(void) 
{
	if(install_timer ())
		error("Error installing timer");
	
	LOCK_VARIABLE(timer);
    LOCK_FUNCTION(timer_handler);
}

void timer_start(void)
{
	install_int_ex (&timer_handler, BPS_TO_TIMER(BPS));
}

void timer_stop(void)
{
	remove_int (&timer_handler);
}
