#include <allegro.h>

#include "globals.h"
#include "tokdef.h"
#include "data.h"

void Player::Draw(BITMAP *bmp)
{
	line(bmp, nx, ny, nx + dx*6, ny + dy*6, makecol(255, 0, 0));
	rotate_sprite(bmp, (BITMAP *)data[CANPIPE].dat, 256, 94, dir);
	draw_sprite(bmp, (BITMAP *)data[CANBODY].dat, 288, 68);
}

void Player::Move()
{
	int mx, my;
	bool click=false;
	get_mouse_mickeys(&mx, &my);
	
	if (mx || my)
	{
		dx += (float)mx/20;
		dy += (float)my/20;
		
		pow = sqrt((dx * dx) + (dy * dy));

		if (pow > 8)
		{
			dx = (dx / pow) * 8;
			dy = (dy / pow) * 8;
			pow = 8;
		}

		if (pow < 1)
		{
			dx = (dx / pow);
			dy = (dy / pow);
			pow = 1;
		}
		
		dir = fatan2(ftofix(dy), ftofix(dx))&0xFFFFFF;

		if ((dir > itofix(16))&&(dir < itofix(64)))
		{
			dir = itofix(16);
			dx = fixtof(fcos(dir))*pow;
			dy = fixtof(fsin(dir))*pow;
		}

		if ((dir < itofix(112))&&(dir >= itofix(64)))
		{
			dir = itofix(112);
			dx = fixtof(fcos(dir))*pow;
			dy = fixtof(fsin(dir))*pow;
		}
		
		nx = fixtof(fcos(dir))*63+320;
		ny = fixtof(fsin(dir))*63+100;
	}

	if (!(mouse_b & 1))
		mb = false;

	if (mouse_b & 1)
	{
		if (!mb)
			click = true;
		mb = true;
	}
	
	if (click)
	{
		for (int i=0; i<32; i++)
			Tokens->AddParticle (nx, ny, dir+itofix((rand()&31))-itofix(16), ((float)(rand()&1023)/3000+.1)*pow, 0.1, 230, 50, 20, 16, 1, true);
		Tokens->AddShell (nx, ny, dx, dy);
		play_sample((SAMPLE *)data[SHOT].dat, 128, 128, 936-(rand()&127), 0);
	}
}