#include <allegro.h>

#include "globals.h"
#include "tokdef.h"
#include "data.h"

void Particle::Set(float ix, float iy, fixed d, float v, float grav, int ir, int ig, int ib, int time, int size, bool iadd)
{
	x=ix; y=iy;
	dx=fixtof(fcos(d))*v; dy=fixtof(fsin(d))*v;
	r=ir; g=ig; b=ib;
	age=sage=time;
	effect = true;
	gr = grav;
	s = size;

	add = iadd;
}
void Particle::Draw(BITMAP *bmp)
{
	if (add)
	{
		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		circlefill(bmp, x, y, s, makecol(r*age/sage, g*age/sage, b*age/sage));
		solid_mode();
	}
	else
	{
		set_trans_blender(255, 255, 255, age*128/sage);
		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		circlefill(bmp, x, y, s, makecol(r, g, b));
		solid_mode();
		set_add_blender(255, 255, 255, 255);
	}
}

void Particle::Move()
{
	x += dx; y += dy;
	dy += gr;
	age--;
	if (age <= 0)
	{
		parent->Remove(this);
		return;
	}
}


void Shell::Set(float ix, float iy, float idx, float idy)
{
	x=ix; y=iy;
	dx=idx; dy=idy;
	smoke = rand()&3;
	shot = true;
}


void Shell::Move()
{
	x += dx; y += dy;
	dy += 0.5;

	if ((smoke++&3)==1)
		Tokens->AddParticle (x, y-2, 0, 0, -.3, 128, 128, 128, 16, 2, false);

	if ((x < 0)||(x >= 640))
	{
		parent->Remove(this);
		shotcount++;
		return;
	}

	if (World->height[(int)x] < y)
	{
		World->Dent(x);
		World->Col(x, 10, rand()&15, rand()&15, rand()&15, 64);
		shotcount++;
		destroyme = true;
	}

	if (destroyme)
	{
		for (int i=0; i<128; i++)
			Tokens->AddParticle (x, y, itofix((rand()&255)), (float)(rand()&1023)/256+.5, .05, 255, 20, 4, 8, 1, true);
		parent->Remove(this);
		play_sample((SAMPLE *)data[BANG].dat, 256, 128, 1000, 0);
		return;
	}
}

void Shell::Draw(BITMAP *bmp)
{
	draw_sprite(bmp, (BITMAP *)data[SHELL].dat, x-4, y-4);
}


void Blood::Set(float ix, float iy, fixed d, float v)
{
	x=ix; y=iy;
	dx=fixtof(fcos(d))*v; dy=fixtof(fsin(d))*v;
	smoke = rand()&7;
}


void Blood::Move()
{
	x += dx; y += dy;
	dy += 0.5;

	if ((smoke++&7)==1)
		Tokens->AddParticle (x, y, 0, 0, .5, 255, 0, 0, 16, 1, false);

	if ((x < 0)||(x >= 640))
	{
		parent->Remove(this);
		return;
	}

	if (World->height[(int)x] < y)
	{
		World->Col(x, 4, 180+(rand()&63), 0, 0, 32);
		parent->Remove(this);
		return;
	}
}

void Blood::Draw(BITMAP *bmp)
{
	circlefill(bmp, x, y, 1, makecol(200, 0, 0));
}