#include <allegro.h>
#include <string.h>
#include <stdio.h>

#include "globals.h"
#include "hiscore.h"
#include "data.h"

HISCORE hiscore[10] = {
	1000, "Kraftwerk",
	900, "Marilyn Manson",
	800, "NiN",
	700, "KoRn",
	600, "Rammstein",
	500, "Covenant",	
	400, "Depeche Mode",
	242, "Front",
	200, "Project Pitchfork",
	100, "Apoptygma Berzerk",
};

int lastplace=-1;

void hiscore_load()
{
	FILE *hs = fopen("score.hi", "rb");
	if (hs == NULL)
		return;

	int score;
	char name[20];
	
	for (int i=0; i<10; i++)
	{
		fread(&score, sizeof(int), 1, hs);
		fread(name, 20, 1, hs);
		hiscore[i].score = score;
		strcpy(hiscore[i].name, name);
	}

	fclose(hs);
}


void hiscore_save()
{
	FILE *hs = fopen("score.hi", "wb");

	for (int i=0; i<10; i++)
	{
		fwrite(&hiscore[i].score, sizeof(int), 1, hs);
		fwrite(hiscore[i].name, 20, 1, hs);
	}

	fclose(hs);
}


void textbox(int x, int y, int col, char *label, char *text)
{
	int i = 0, c;
	text[0] = 0;

	clear_keybuf();

	for (int x2=-1; x2<=1; x2++)
		for (int y2=-1; y2<=1; y2++)
			textout_right(screen, font, label, x+x2, y+y2, makecol(0,0,0));

	textout_right(screen, font, label, x, y, col);

	text_mode(0);
	textout(screen, font, "                   ", x, y, makecol(0,0,0));

	while (1)
	{
		c = readkey();
		play_sample((SAMPLE *)data[BIP].dat, 256, 128, 1000, 0);
		if ((c >> 8) == KEY_BACKSPACE)
		{
			if (i>0)
			{
				text[--i] = '\0';
				textout(screen, font, "                   ", x, y, makecol(0,0,0));
			}
		} else
		{
		if (((c >> 8) == KEY_ENTER)||(i==19))
			break;
		text[i++]=c&0xFF;
		text[i] = '\0';
		}
		textout(screen, font, text, x, y, makecol(255,255,255));
	}

	text_mode(-1);
}


void hiscore_add(int score)
{
	int place, i;
	char name[20];

	lastplace = -1;

	if (score <= hiscore[9].score)
		return;
	
	textbox(320, 100, makecol(255, 255, 0), "Please enter your name:", name);

	for (i=9; i>=0; i--)
		if (score > hiscore[i].score)
			place = i;

	for (i=9; i>place; i--)
	{
		hiscore[i].score = hiscore[i-1].score;
		strcpy(hiscore[i].name, hiscore[i-1].name);
	}
	
	lastplace=place;
	hiscore[place].score = score;
	strcpy(hiscore[place].name, name);
}

void hiscore_print(BITMAP *bmp, int x, int y, int c)
{
	int i;
	for (int x2=-1; x2<=1; x2++)
		for (int y2=-1; y2<=1; y2++)
			for (i=0; i<10; i++)
			{
				textprintf(bmp, font, x+x2, y+(i*10)+y2, makecol(0,0,0), "%2d %s", i+1, hiscore[i].name);
				textprintf_right(bmp, font, x+224+x2, y+(i*10)+y2, makecol(0,0,0), "%d", hiscore[i].score);
			}

	for (i=0; i<10; i++)
	{
		if (i == lastplace)
		{
			textprintf(bmp, font, x, y+(i*10), makecol(255,255,255), "%2d %s", i+1, hiscore[i].name);
			textprintf_right(bmp, font, x+224, y+(i*10), makecol(255,255,255), "%d", hiscore[i].score);
		}
		else
		{
			textprintf(bmp, font, x, y+(i*10), c, "%2d %s", i+1, hiscore[i].name);
			textprintf_right(bmp, font, x+224, y+(i*10), c, "%d", hiscore[i].score);
		}
	}
}