#include <allegro.h>

#include "world.h"
#include "token.h"
#include "data.h"
#include "error.h"
#include "hiscore.h"
#include "timer.h"

BITMAP *sky;
BITMAP *buf;


class TokenList *Tokens;
class World *World;

bool gameover;
int bodycount;
int shotcount;
int score;
int timenext;

void gradient(BITMAP *bmp, int r1, int g1, int b1, int r2, int g2, int b2)
{
	int r, g, b, j;
	for (int x=0; x<bmp->w; x++)
		for (int y=0; y<bmp->h; y++)
		{
			j = y + rand()%5-2;
			r = (r1 * (bmp->h-j) / bmp->h) + (j * r2 / bmp->h);
			g = (g1 * (bmp->h-j) / bmp->h) + (j * g2 / bmp->h);
			b = (b1 * (bmp->h-j) / bmp->h) + (j * b2 / bmp->h);
			putpixel (bmp, x, y, makecol(r, g, b));
		}
}

void grayscale(BITMAP *bmp)
{
	for (int x=0; x < bmp->w; x++)
		for (int y=0; y < bmp->h; y++)
		{
			int c = getpixel(bmp, x, y);
			int r = getr(c), g = getg(c), b = getb(c);
			c = 0.15*r + 0.25*g + 0.05*b;
			putpixel (bmp, x, y, makecol(c, c, c));
		}
}


void game_init()
{
	sky = create_bitmap(640, 480);
	buf = create_bitmap(640, 480);

	if ((sky == NULL)||(buf == NULL))
		error("Not enough memory");

	gradient(sky, 30, 80, 200, 30, 200, 240);
	draw_trans_sprite(sky, (BITMAP *)data[SUN].dat, 0, 0);

	Tokens = new(class TokenList);
	World = new(class World);
}

inline void gfx_loop()
{
	blit (sky, buf, 0, 0, 0, 0, 640, 480);
	Tokens->Draw(buf);
	World->Draw(buf);
	Tokens->DrawEffects(buf);
			
	textprintf(buf, font, 1, 1, makecol(220, 180, 50), "Bodycount: %d  Shots: %d  Ratio: %d%%  Score: %d", bodycount, shotcount, bodycount*100/(shotcount==0?1:shotcount), score);
	blit(buf, screen, 0, 0, 0, 0, 640, 480);
}

inline void logic_loop()
{
	int types = (bodycount / 20)+1;
	timenext--;
	if (timenext <= 0)
	{
		Tokens->AddBadguy((rand()%(types>3?3:types))+1);
		timenext = (1800/(bodycount+30))+(rand()&15);
	}

	if (key[KEY_ESC])
		gameover = true;

	Tokens->Move();
	score = bodycount*bodycount*100/(shotcount==0?1:shotcount);
}

void gameloop()
{
	int frame=0;

	World->Create();
	Tokens->Clear();
	Tokens->AddPlayer();

	gameover = false;
	bodycount=0;
	shotcount=0;
	timenext=30;
	score = 0;
	timer = 0;
	
	timer_start();
	while (!gameover)
	{
		logic_loop();
		frame++;

		if (frame >= timer)
			gfx_loop();
		while (frame > timer) { }
	}
	timer_stop();
	gfx_loop();
	
	grayscale(buf);

	hiscore_add(score);

	blit(buf, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

	Tokens->Clear();
}

void game_shutdown()
{
	destroy_bitmap(sky);
	delete Tokens;
	delete World;
}