#include <allegro.h>

#include "world.h"
#include "data.h"

inline int gheight(int x)
{
	if (x < 320)
		return (320*(320-x)/320)+120;

	return (320*(x-320)/320)+120;
}

World::World()
{
	fg = create_bitmap(640, 480);
}

World::~World()
{
	destroy_bitmap(fg);
}

void World::Clear()
{
	for (int i=0; i<640; i++)
		height[i] = 120;

	clear_to_color(fg, makecol(255, 0, 255));
}

void World::Create()
{
	int x, y, h;
	int he[640];
	Clear();
	
	h = gheight(320);
	for (x=320; x>=0; x--)
	{
		he[x]=h;
		h += (rand()%6 - 2) * (((gheight(x)-h)<0)?(-1):(1));
		if (h < 0)
			h = 0;
		if (h >= 640)
			h = 639;

	}

	h = gheight(320);
	for (x=320; x<640; x++)
	{
		he[x]=h;
		h += (rand()%6 - 2) * (((gheight(x)-h)<0)?(-1):(1));
		if (h < 0)
			h = 0;
		if (h >= 640)
			h = 639;

	}
	
	for (x=1; x<639; x++)
		height[x]=(he[x]+he[x+1]+he[x-1])/3;

	height[0] = he[0];
	height[639] = he[639];

	for (x=0; x<640; x++)
		for (y=0; y<480; y++)
			if (y >= height[x])
			{
				BITMAP *g = (BITMAP *)data[GROUND].dat;
				BITMAP *gr = (BITMAP *)data[GRASS].dat;
				int c = getpixel(g, x%g->w, y%g->h);
				if (y < height[x]+16)
					c = getpixel(gr, x%gr->w, y-height[x]);
				putpixel(fg, x, y, c);
				drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
				putpixel(fg, x, y, getpixel((BITMAP *)data[SUN].dat, x, y));
				solid_mode();
			}

}

void World::Draw(BITMAP *bmp)
{
	masked_blit (fg, bmp, 0, 0, 0, 0, 640, 480);
}

void World::Col(int x, int w, int r, int g, int b, int a)
{
	set_trans_blender(255, 255, 255, a);
	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);

	for (int i=((x-w<0)?(0):(x-w)); i<((x+w>640)?(640):(x+w)); i++)
		vline(fg, i, height[i], height[i]+(rand()&15), makecol(r, g, b));

	solid_mode();
	set_add_blender(255, 255, 255, 255);
}

void World::Dent(int x)
{
	if ((x < 270)||(x > 370))
	{
		vline(fg, x, height[x], height[x]+7, makecol(255, 0, 255));
		height[x]+=8;	
		for (int i = 1; i<8; i++)
		{
			if (x-i >= 0)
			{
				vline(fg, x-i, height[x-i], height[x-i]+7-i, makecol(255, 0, 255));
				height[x-i]+=8-i;
			}
			
			if (x+i < 640)
			{
				vline(fg, x+i, height[x+i], height[x+i]+7-i, makecol(255, 0, 255));
				height[x+i]+=8-i;
			}
		}
	}
}