#include <allegro.h>
#include <math.h>

#include "token.h"
#include "tokdef.h"

TokenList::TokenList(): top(NULL), amt(0), mem(0) { }	// Constructor

TokenList::~TokenList()					// Destructor
{
	Clear();
}

void TokenList::AddPlayer()
{
	Token *a = top;
	top = new(Player);

	top->parent = this;
	top->next = a;
	if (a!=NULL)
		a->prev = top;
	amt++;
}


void TokenList::AddParticle(float x, float y, fixed d, float v, float grav, int r, int g, int b, int time, int size, bool add)
{
	Token *a = top;
	Particle *p = new(Particle);
	
	p->Set(x, y, d, v, grav, r, g, b, time, size, add);

	top = p;
	top->parent = this;
	top->next = a;
	if (a!=NULL)
		a->prev = top;

	amt++;
}


void TokenList::AddShell(float x, float y, float dx, float dy)
{
	Token *a = top;
	Shell *p = new(Shell);
	
	p->Set(x, y, dx, dy);

	top = p;
	top->parent = this;
	top->next = a;
	if (a!=NULL)
		a->prev = top;

	amt++;
}

void TokenList::AddBlood(float x, float y, fixed d, float v)
{
	Token *a = top;
	Blood *p = new(Blood);
	
	p->Set(x, y, d, v);

	top = p;
	top->parent = this;
	top->next = a;
	if (a!=NULL)
		a->prev = top;

	amt++;
}

void TokenList::AddBadguy(int type)
{
	Token *a = top;
	Badguy *p = new(Badguy);
	
	p->Set(type);

	top = p;
	top->parent = this;
	top->next = a;
	if (a!=NULL)
		a->prev = top;

	amt++;
}

void TokenList::Remove(Token *a)		// Delete a node in the linked list
{
	Token *next = a->next;
	Token *prev = a->prev;

	if (next!=NULL)
		next->prev = prev;

	if (prev!=NULL)
		prev->next = next;
	else
		top = next;

	delete a;
	amt--;
}

void TokenList::Clear()					// Clear the linked list
{
	Token *a=top;
	Token *b;
	while (a != NULL)
	{
		b = a->next;
		delete a;
		a = b;
	}
	top = NULL;
	amt = 0;
}

void TokenList::Draw(BITMAP *bmp)		// Draw all the objects in the list
{
	Token *a=top;
	Token *b;
	while (a != NULL)
	{
		b = a->next;
		if (!a->effect)
		a->Draw(bmp);
		a = b;
	}
}

void TokenList::DrawEffects(BITMAP *bmp)
{
	Token *a=top;
	Token *b;
	while (a != NULL)
	{
		b = a->next;
		if (a->effect)
			a->Draw(bmp);
		a = b;
	}
}

void TokenList::Move()					// Move all the objects in the list
{
	Token *a=top;
	Token *b;
	while (a != NULL)
	{
		b = a->next;
		a->Move();
		a = b;
	}
}

int TokenList::GetAmt()
{
	return amt;
}


int TokenList::GetMem()
{
	return mem;
}