#include <allegro.h>
#include <time.h>

#include "game.h"
#include "world.h"
#include "token.h"
#include "data.h"
#include "error.h"
#include "hiscore.h"
#include "timer.h"


void draw_title()
{
	for (int x=-1; x<=1; x++)
		for (int y=-1; y<=1; y++)
		{
			textout_centre(screen, font, "---------------------------------------", 320+x, 56+y, makecol(0,0,0));
			textout_centre(screen, font, "M U T A N T   R A B I E S   B E A S T S", 320+x, 64+y, makecol(0,0,0));
			textout_centre(screen, font, "---------------------------------------", 320+x, 72+y, makecol(0,0,0));
			textout_centre(screen, font, "T O P   T E N   K I L L E R S", 320+x, 112+y, makecol(0,0,0));
			textout_centre(screen, font, "Aim and shoot with the mouse.", 320+x, 300+y, makecol(0,0,0));
			textout_centre(screen, font, "Don't let the animals get near your cannon!", 320+x, 310+y, makecol(0,0,0));
			textout_centre(screen, font, "Start game with [SPACE], quit by pressing [ESC]", 320+x, 340+y, makecol(0,0,0));
		}
	
	textout_centre(screen, font, "---------------------------------------", 320, 56, makecol(255,64,0));	
	textout_centre(screen, font, "M U T A N T   R A B I E S   B E A S T S", 320, 64, makecol(255,64,0));
	textout_centre(screen, font, "---------------------------------------", 320, 72, makecol(255,64,0));	
	textout_centre(screen, font, "T O P   T E N   K I L L E R S", 320, 112, makecol(255,220,0));
	textout_centre(screen, font, "Aim and shoot with the mouse.", 320, 300, makecol(128,128,128));
	textout_centre(screen, font, "Don't let the animals get near your cannon!", 320, 310, makecol(128,128,128));
	textout_centre(screen, font, "Start game with [SPACE], quit by pressing [ESC]", 320, 340, makecol(0,255,63));

	hiscore_print(screen, 208, 128, makecol(64, 128, 255));
}

int main(void)
{
	srand((unsigned)time(NULL));

	allegro_init();
	set_window_title("Mutant Rabies Beasts");
	install_keyboard();
	install_mouse();
	timer_init();
	
	install_sound(DIGI_AUTODETECT , MIDI_AUTODETECT, NULL);

	set_color_depth(16);
	if(set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0))
	{
		set_color_depth(15);
		if(set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0))
		{
			set_color_depth(24);
			if(set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0))
			{
				set_color_depth(32);
				if(set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0))
					error("Unable to set graphics mode");
			}
		}
	}
			
	set_add_blender(255, 255, 255, 255);

	textout_centre(screen, font, "Please wait...", 320, 240, makecol(255,255,255));
	
	if (data_init())
		error("Error loading datafile");
	
	BITMAP *bmp = create_bitmap(640, 480);
	if (bmp == NULL)
		error("Not enough memory");

	clear(bmp);

	game_init();
	hiscore_load();
	text_mode(-1);

	for (int x = 0; x < 640; x++)
		for (int y = 0; y < 480; y++)
		{
			BITMAP *gr = (BITMAP *)data[GROUND].dat;
			int c = getpixel(gr, x%gr->w, y%gr->h);
			int r = getr(c); int g = getg(c); int b = getb(c);
			c = 0.15*r + 0.25*g + 0.05*b;
			putpixel (bmp, x, y, makecol(c, c, c));
		}

	blit(bmp, screen, 0, 0, 0, 0, 640, 480);
	destroy_bitmap(bmp);

	while (1)
	{
		int c = 0;
		clear_keybuf();

		draw_title();
		
		while ((c != KEY_ESC)&&(c != KEY_SPACE)) { c = readkey() >> 8; }
		if (c == KEY_ESC)
			break;

		play_midi((MIDI *)data[MUSIC].dat, TRUE);
		gameloop();
		stop_midi();

		while (key[KEY_ESC]) { }
	}
	
	hiscore_save();
	data_shutdown();
	game_shutdown();
	set_gfx_mode(GFX_TEXT, 640, 480, 0, 0);
	remove_sound();

	allegro_message (
		"Did you enjoy this game?\n"
		"Are you looking for more games of the same GREAT QUALITY?\n\n"
		"Look no further, because this is not the only game by the same author,\n"
		"Per Larsson has also made a cool puzzle game in FULL 3D!\n"
		"The game is called Qubrikon and is available at: home.swipnet.se/c-x/qubrikon.html\n"
		"Feauters:\n"
		"    Gourad shaded polygons, rendered in 256 MIND-BOGGLING colors!\n"
		"    Tricky puzzles that are (almost) GUARANTEED to up your IQ by at least 70!\n"
		"    Smooth mouse and keyboard control!\n"
		"    Extreme pre-synthesized soundeffects that will BLOW YOU AWAY!\n"
		"    BREATH-TAKING midi music, ripped from misc. SNES CRPGs!\n\n"
		"Qubrikon was selected GAME OF THE YEAR '99 by Larsson Gamerating\n"
		"Don't be a LOOSER! Download Qubrikon now!\n\n"
		"        NOW!\n");

	return 0;
}
END_OF_MAIN();