#include <stdlib.h>
#include <string.h>
#include "allegro.h"
#include "bloco.h"

/* Aloca memria para nb blocos e retorna o ponteiro ou NULL se deu erro*/
BLOCOS *bls_cria(int nb, char desc[MAXDESC])
{
	BLOCOS *b;
	if(nb<1) {
		return NULL;
	}
	b = malloc(sizeof(BLOCOS));
	if(!b) {
		return NULL;
	}
	b->b = malloc(sizeof(BLOCO)*nb);
	if(!b->b) {
		free(b);
		return NULL;
	}
	memset(b->b, 0, sizeof(BLOCO)*nb);
	strcpy(b->desc, desc);
	b->n = nb;
	return b;
}

/* Libera memria usada nos blocos */
void bls_destroi(BLOCOS *b)
{
	if(!b)
		return;
	free(b->b);
	free(b);
	b = NULL;
}

/* Cria blocos iguais aos do Tetris e retorna o ponteiro, ou NULL se erro*/
BLOCOS *bls_gera_padrao_tetris(void)
{
	BLOCOS *b;
	BLOCO *bl;
	/* 7 blocos no Tetris */
	b = bls_cria(7, "Peas padro do Tetris");
	if(!b)
		return NULL;

	bl = &b->b[0];
	bl->b[1][0] = bl->b[2][0] = bl->b[0][1] = bl->b[1][1] = 1;
	bl->x = 2;
	bl->y = 3;

	bl = &b->b[1];
	bl->b[0][0] = bl->b[1][0] = bl->b[1][1] = bl->b[2][1] = 1;
	bl->x = 2;
	bl->y = 3;

	bl = &b->b[2];
	bl->b[0][0] = bl->b[0][1] = bl->b[1][0] = bl->b[1][1] = 1;
	bl->x = 2;
	bl->y = 2;

	bl = &b->b[3];
	bl->b[1][0] = bl->b[0][1] = bl->b[1][1] = bl->b[2][1] = 1;
	bl->x = 2;
	bl->y = 3;

	bl = &b->b[4];
	bl->b[2][0] = bl->b[0][1] = bl->b[1][1] = bl->b[2][1] = 1;
	bl->x = 2;
	bl->y = 3;

	bl = &b->b[5];
	bl->b[0][0] = bl->b[0][1] = bl->b[1][1] = bl->b[2][1] = 1;
	bl->x = 2;
	bl->y = 3;

	bl = &b->b[6];
	bl->b[0][0] = bl->b[1][0] = bl->b[2][0] = bl->b[3][0] = 1;
	bl->x = 1;
	bl->y = 4;

	return b;
}

/* Salva o conjunto de blocos no arquivo e retorna 0 se ok ou 1 se erro*/
int bls_salva(BLOCOS *b, char *arquivo)
{
	PACKFILE *f;
	f = pack_fopen(arquivo, F_WRITE_PACKED);
	if(!f)
		return 1;
	pack_iputl(AL_ID('B', 'l', 'o', 'c'), f);
	pack_fwrite(b, sizeof(BLOCOS), f);
	pack_fwrite(b->b, sizeof(BLOCO)*b->n, f);
	pack_fclose(f);
	return 0;
}

/* Abre um conjunto de blocos do arquivo e retorna o ponteiro ou NULL se erro */
BLOCOS *bls_abre(char *arquivo)
{
	BLOCOS *b, tmp;
	PACKFILE *f;
	f = pack_fopen(arquivo, F_READ_PACKED);
	if(!f) {
		return NULL;
	}
	if(pack_igetl(f) != AL_ID('B', 'l', 'o', 'c')) {
		pack_fclose(f);
		return NULL;
	}
	pack_fread(&tmp, sizeof(BLOCOS), f);
	b = bls_cria(tmp.n, tmp.desc);
	if(!b) {
		pack_fclose(f);
		return NULL;
	}
	pack_fread(b->b, sizeof(BLOCO)*b->n, f);
	pack_fclose(f);
	return b;
}

/* Retorna um ponteiro para o bloco nb do conjunto de blocos */
BLOCO *bls_pega_bloco(BLOCOS *b, int nb)
{
	return &b->b[nb];
}

/* Copia um novo bloco escolhido aleatoriamente para bl que esteja em b e retorna
	o n do bloco gerado para ser usado em alguma estatstica */
int bls_gera_prox_bloco(BLOCOS *b, BLOCO *bl)
{
	int nb, i;
	nb = rand() % b->n;
	memcpy(bl, bls_pega_bloco(b, nb), sizeof(BLOCO));
	/* roda o novo bloco para que no esteja sempre na mesma posio */ 
	for(i=0; i<rand() % 4; i++)
		bl_roda(bl, ESQUERDA);
	return nb;
}

/* Roda o bloco na direo desejada */
void bl_roda(BLOCO *b, int dir)
{
	BLOCO tmp;
	int i, j=0;
	memset(&tmp, 0, sizeof(BLOCO));
	if(dir == ESQUERDA) {
		for(i=0; i<b->y; i++)
			for(j=0; j<b->x; j++)
				tmp.b[b->x-j-1][i] = b->b[i][j];
	}
	else {
		for(i=0; i<b->y; i++)
			for(j=0; j<b->x; j++)
				tmp.b[j][b->y-i-1] = b->b[i][j];
	}
	tmp.x = i;
	tmp.y = j;
	memcpy(b, &tmp, sizeof(BLOCO));
}