/*		TETRIS verso 1.1

		O clssico jogo Tetris, onde voc deve formar uma linha completa com as peas
	que vo caindo do teto para que ela desaparea.
		O principal do jogo  que ele possui uma matrix 20x10 que contm as peas j
	colocadas, uma varivel que guarda o bloco atual e sua posio no mapa e uma
	outra que guarda o prximo bloco. Tem tambm um timer que  incrementado numa
	frequncia constante e que junto com vel ajusta a velocidade do jogo.

	*** Verso 1.0 ***
		- Verso inicial, finalizada em ??/05/2001

	*** Verso 1.1 ***
		- Cdigo atualizado para usar o Allegro 4.0.0
		- Cdigo de le_entrada() removido e usando o novo readkey() agora
		- inicia_tudo() no mostra mais nada agora, a no ser que d erro, e agora muda a taxa de
		  repetio do teclado e seta o formato U_ASCII para exibir caracteres com acentos nas novas
		  verses do Allegro
		- Pequena alterao nas opes, agora s vai nas opes disponveis para alterao
		- Inserida uma funo para tirar snap shots do jogo com a tecla F12
		- Verso 1.1 finalizada em 27/03/2002, 01:32
*/

/* Includes */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include "allegro.h"
#include "bloco.h"
#include "audio.h"
#include "graficos.h"

/* Variveis globais e constantes */

#define FPS				20						/* frames por segundo */

unsigned char mapa[20][10];				/* matriz 20x10 contendo os blocos j postos */
int nivel_ini;									/* nvel inicial do jogo */
int bloco_ini;									/* altura inicial dos blocos */
BLOCO bl, prox_bl;							/* bloco atual e prximo bloco */
int bl_x, bl_y;								/* posio do bloco no mapa */
int pontos, linhas;							/* n de pontos e n de linhas feitas */
int nivel;										/* nvel atual */

volatile int tempo;							/* armazena quanto tempo foi jogado */
volatile int timer;							/* timer do jogo */
int vel;											/* velocidade das peas */

#define TEC_T1			4						/* espera para a primeira repetio (em frames) */
#define TEC_T2			1						/* demais repeties (em frames) */

DATAFILE *audio;								/* arquivo com o udio do jogo */
unsigned char som, musica;					/* indica se a msica e o som esto ativados */
#define DESL			0						/* audio desligado */
#define LIGA			1						/* audio ligado */
#define SEM				2						/* no achou placa de som */
int vol_s, vol_m;								/* volume do som e da msica */
int musica_modo;								/* modo como a msica de fundo  executada */
#define M_REPETE		0						/* repete a msica atual */
#define M_NORMAL		1						/* executa todas as msicas na ordem */
#define M_RANDOM		2						/* modo aleatrio */
int musica_atual;								/* msica sendo tocada */
int t_espera;									/* contagem da espera entre uma msica e outra */
#define T_ESPERA		20						/* tempo de espera entre uma msica e outra */
unsigned char primeira_vez;				/* indica se  a primeira vez que a funo de msica  chamada */

DATAFILE *graficos;							/* arquivo com os grficos do jogo */
PALETTE *pal;									/* paleta de cores do jogo */
RGB_MAP rgb_table;							/* tabela de cores para aumentar a velocidade */
COLOR_MAP trans_table;						/* usado para pintar o quadrado com diferentes cores */
int cores[10] = {								/* cores das peas colocadas em cada nvel */
	52, 36, 19, 142, 116, 2, 183, 112, 102, 86
};

typedef struct {								/* estrutura para armazenar os recordes */
	int pontos, linhas, nivel;
	char nome[16];
} RECORDE;

/* Prottipos das funes */

void timer_inc(void);
void deleta_linha(void);
void muda_nivel(void);
int pode_por(void);
void poe_bloco(void);
void inicia_mapa();

void desenha_mapa(BITMAP *buf, int x, int y);
void desenha_borda(BITMAP *bmp, int x1, int y1, int x2, int y2, int c);
void desenha_prox(BITMAP *bmp, int x, int y);
void desenha_fundo(void);

void jogar(void);
void parar(void);

void verificar_recordes(void);
void mostrar_recordes(void);
void cria_arquivo_recordes(void);
void le_nome_recordes(char nome[16]);

void opcoes(void);

void verifica_musica(void);
int prox_musica(void);
void toca_musica(int n);
void toca_som(int n);

void menu(void);

void creditos(void);

void screen_shot(void);

void inicia_tudo(void);
void fecha_tudo(void);

/* Funes */

/* incrementa o timer do jogo */
void timer_inc(void)
{
	timer++;
	tempo++;
} END_OF_FUNCTION(timer_inc);

/* verifica se pode deletar uma linha do mapa */
void deleta_linha(void)
{
	int soma, i, j, t, dels=0;
	/* varre todas as linhas de cima para baixo */
	for(i=0; i<20; i++) {
		for(j=0, soma=0; j<10; j++) {
			if(mapa[i][j])
				soma++;
		}
		/* apaga esta linha */
		if(soma==10) {
			for(t=i; t>0; t--) {
				for(j=0; j<10; j++) {
					mapa[t][j] = mapa[t-1][j];
				}
			}
			for(j=0; j<10; j++)
				mapa[0][j] = 0;
			/* incrementa n de linhas apagadas */
			dels++;
		}
	}
	/* atualiza n de linhas apagadas */
	linhas += dels;
	/* computa os pontos para o n de linhas apagadas */
	if(dels) {
		pontos += (100 * dels) + ((dels - 1) * 25) + nivel * 25;
		toca_som(S_LINHA);
	}
	/* muda nvel a cada 10 linhas */
	if(nivel < (linhas/10))
		muda_nivel();
}

/* incrementa o nvel e aumenta a velocidade */
void muda_nivel(void)
{
	nivel = linhas/10;
	if(nivel<nivel_ini)
		nivel = nivel_ini;
	vel = 25 - nivel*2;
	if(vel < 2)
		vel = 2;
}

/* verifica se pode por o bloco no local atual, retornando 1 se pode, 0 se no */
int pode_por(void)
{
	int i, j;
	for(i=0; i<bl.y; i++) {
		for(j=0; j<bl.x; j++) {
			if(bl.b[i][j]) {
				if( (bl_x+j>9) || (bl_y+i>19) || (mapa[bl_y+i][bl_x+j]!=0) ||
					 (bl_x<0) || (bl_y<0) )
					return 0;
			}
		}
	}
	return 1;
}

/* coloca o bloco no mapa, gera outro e verifica se deu game over */
void poe_bloco(void)
{
	int i, j;
	for(i=0; i<bl.y; i++) {
		for(j=0; j<bl.x; j++) {
			if(bl.b[i][j])
				mapa[bl_y+i][bl_x+j] = 1;
		}
	}
	toca_som(S_POE);
	deleta_linha();
}

/* inicializa o mapa */
void inicia_mapa()
{
	int i, j;
	for(i=0; i<20; i++) {
		for(j=0; j<10; j++) {
			mapa[i][j] = 0;
		}
	}
	for(i=19; i>19-bloco_ini; i--) {
		for(j=0; j<10; j++) {
			if(rand() % 2)
				mapa[i][j] = 1;
		}
	}
}

/* desenha o mapa na posio x, y no bitmap especificado */
void desenha_mapa(BITMAP *buf, int x, int y)
{
	BITMAP *quad;
	int i, j, cor;
	quad = (BITMAP *)graficos[QUADRADO].dat;
	cor = cores[nivel % 10];
	/* desenha o mapa */
	for(i=0; i<20; i++) {
		for(j=0; j<10; j++) {
			if(mapa[i][j])
				draw_lit_sprite(buf, quad, x+j*10, y+i*10, cor);
			else
				rectfill(buf, x+j*10, y+i*10, x+j*10+9, y+i*10+9, 0);
		}
	}
	/* desenha o bloco na posio dele */
	for(i=0; i<bl.y; i++) {
		for(j=0; j<bl.x; j++) {
			if(bl.b[i][j])
				draw_sprite(buf, quad, x+(bl_x+j)*10, y+(bl_y+i)*10);
		}
	}
}

/* desenha o contorno das reas das peas e dos textos */
void desenha_borda(BITMAP *bmp, int x1, int y1, int x2, int y2, int c)
{
	int i;
	BITMAP *borda1, *borda2, *canto;
	borda1 = (BITMAP *)graficos[BORDA1].dat;
	borda2 = (BITMAP *)graficos[BORDA2].dat;
	canto = (BITMAP *)graficos[CANTO].dat;
	if(c>=0)
		rectfill(bmp, x1, y1, x2, y2, c);
	for(i=y1; i<y2; i++) {
		draw_sprite(bmp, borda1, x1-borda1->w, i);
		draw_sprite_h_flip(bmp, borda1, x2, i);
	}
	for(i=x1; i<x2; i++) {
		draw_sprite(bmp, borda2, i, y1-borda2->h);
		draw_sprite_v_flip(bmp, borda2, i, y2);
	}
	draw_sprite(bmp, canto, x1-canto->w, y1-canto->h);
	draw_sprite_vh_flip(bmp, canto, x2, y2);
	draw_sprite_v_flip(bmp, canto, x1-canto->w, y2);
	draw_sprite_h_flip(bmp, canto, x2, y1-canto->h);
}

/* desenha o prximo bloco a entrar no jogo */
void desenha_prox(BITMAP *bmp, int x, int y)
{
	BITMAP *quad;
	int i, j;
	quad = (BITMAP *)graficos[QUADRADO].dat;
	rectfill(bmp, x, y, x+MAXX*10, y+MAXY*10, 0);
	x = ((x+x+(MAXX*10))/2)-prox_bl.x*5;
	y = ((y+y+(MAXY*10))/2)-prox_bl.y*5;
	for(i=0; i<prox_bl.y; i++) {
		for(j=0; j<prox_bl.x; j++) {
			if(prox_bl.b[i][j])
				draw_sprite(bmp, quad, x+j*10, y+i*10);
		}
	}
}

/* desenha o fundo de tela */
void desenha_fundo(void)
{
	BITMAP *tex;
	int i, j;
	tex = (BITMAP *)graficos[TEXTURA].dat;
	for(i=0; i<SCREEN_H; i+=tex->h) {
		for(j=0; j<SCREEN_W; j+=tex->w) {
			blit(tex, screen, 0, 0, j, i, tex->w, tex->h);
		}
	}
}

/* funo que comea o jogo realmente */
void jogar(void)
{
	BITMAP *buf;
	int ch=0, game_over=0, i;
	BLOCOS *blocos;
	char str[40];
	blocos = bls_gera_padrao_tetris();
	if(!blocos) {
		allegro_exit();
		printf("ERRO!!!!\n");
		exit(1);
	}
	buf = create_bitmap(100, 200);
	desenha_fundo();
	desenha_borda(screen, 109, 29, 211, 231, 0);
	pontos = 0;
	linhas = 0;
	bls_gera_prox_bloco(blocos, &bl);
	bls_gera_prox_bloco(blocos, &prox_bl);
	bl_y=0;
	bl_x=5-(bl.x/2);
	muda_nivel();
	inicia_mapa();
	desenha_mapa(screen, 110, 30);
	desenha_borda(screen, 10, 29, 90, 121, 0);
	text_mode(-1);
	textout_centre(screen, font, "Nvel", 50, 35, 13);
	textout_centre(screen, font, "Pontos", 50, 65, 13);
	textout_centre(screen, font, "Linhas", 50, 95, 13);
	desenha_borda(screen, 249, 29, 311, 91, 0);
	textout_centre(screen, font, "Prximo", 280, 35, 13);
	desenha_prox(screen, 260, 45);
	fade_in(*pal, 4);
	clear_keybuf();
	timer=0;
	tempo=0;
	t_espera=0;
	do	{
		verifica_musica();
		for(i=0; i<timer && ch!=KEY_ESC; i++) {
			if(keypressed())
				ch = readkey() >> 8;
			else
				ch = 0;
			switch(ch) {
				case KEY_LEFT :
					bl_x--;
					if(!pode_por())
						bl_x++;
					break;
				case KEY_RIGHT :
					bl_x++;
					if(!pode_por())
						bl_x--;
					break;
				case KEY_Q :
					bl_roda(&bl, ESQUERDA);
					if(!pode_por())
						bl_roda(&bl, DIREITA);
					else
						toca_som(S_RODA);
					break;
				case KEY_W :
					bl_roda(&bl, DIREITA);
					if(!pode_por())
						bl_roda(&bl, ESQUERDA);
					else
						toca_som(S_RODA);
					break;
				case KEY_DOWN :
					bl_y++;
					if(!pode_por()) {
						bl_y--;
						poe_bloco();
						memcpy(&bl, &prox_bl, sizeof(BLOCO));
						bls_gera_prox_bloco(blocos, &prox_bl);
						bl_y=0;
						bl_x=5-(bl.x/2);
						desenha_prox(screen, 260, 45);
						if(!pode_por())
							game_over=1;
					}
					timer=0;
					break;
				case KEY_PAUSE :
					rectfill(screen, 110, 30, 210, 230, 0);
					text_mode(-1);
					textout_centre(screen, font, "Parado", 160, 100, 23);
					parar();
					break;
				case KEY_F12 :
					screen_shot();
					break;
			}
		}
		if(timer>vel) {
			bl_y++;
			if(!pode_por()) {
				bl_y--;
				poe_bloco();
				memcpy(&bl, &prox_bl, sizeof(BLOCO));
				bls_gera_prox_bloco(blocos, &prox_bl);
				bl_y=0;
				bl_x=5-(bl.x/2);
				desenha_prox(screen, 260, 45);
				if(!pode_por())
					game_over=1;
			}
			timer=0;
		}
		desenha_mapa(buf, 0, 0);
		text_mode(0);
		acquire_screen();
		sprintf(str, "%02d", nivel);
		textout_centre(screen, font, str, 50, 45, 23);
		sprintf(str, "%06d", pontos);
		textout_centre(screen, font, str, 50, 75, 23);
		sprintf(str, "%04d", linhas);
		textout_centre(screen, font, str, 50, 105, 23);
		blit(buf, screen, 0, 0, 110, 30, 100, 200);
		release_screen();
		if(game_over) {
			text_mode(0);
			textout_centre(screen, font, "GAME-OVER", 160, 110, 23);
			if(midi_pos>=0)
				stop_midi();
			toca_som(S_FIM);
			rest(1000);
			clear_keybuf();
			readkey();
		}
	} while (ch!=KEY_ESC && !game_over);
	if(midi_pos>=0)
		stop_midi();
}

/* para o jogo */
void parar(void)
{
	int t1, t2;
	t1 = timer;
	t2 = tempo;
	if(midi_pos>=0) {
		midi_pause();
	}
	clear_keybuf();
	readkey();
	if(midi_pos>=0)
		midi_resume();
	timer = t1;
	tempo = t2;
}

/* verifica se foi um recorde */
void verificar_recordes(void)
{
	PACKFILE *f;
	RECORDE recordes[5];
	int i, j;
	f = pack_fopen("Recordes.rec", F_READ_PACKED);
	if(!f)
		return;
	if(pack_igetl(f) != AL_ID('R','E','C',' ')) {
		pack_fclose(f);
		return;
	}
	pack_fread(recordes, sizeof(RECORDE)*5, f);
	pack_fclose(f);
	for(i=0; i<5; i++) {
		if(pontos>recordes[i].pontos ||
			(pontos==recordes[i].pontos && nivel>recordes[i].nivel) ||
			(pontos==recordes[i].pontos && nivel==recordes[i].nivel && linhas<recordes[i].linhas) ) {
			for(j=3; j>=i; j--) {
				recordes[j+1].pontos = recordes[j].pontos;
				recordes[j+1].nivel = recordes[j].nivel;
				recordes[j+1].linhas = recordes[j].linhas;
				strcpy(recordes[j+1].nome, recordes[j].nome);
			}
			recordes[i].pontos = pontos;
			recordes[i].nivel = nivel;
			recordes[i].linhas = linhas;
			strcpy(recordes[i].nome, "");
			le_nome_recordes(recordes[i].nome);
			break;
		}
	}
	f = pack_fopen("Recordes.rec", F_WRITE_PACKED);
	if(!f)
		return;
	pack_iputl(AL_ID('R','E','C',' '), f);
	pack_fwrite(recordes, sizeof(RECORDE)*5, f);
	pack_fclose(f);
}

/* mostra os recordes */
void mostrar_recordes(void)
{
	PACKFILE *f;
	RECORDE recordes[5];
	int i;
	BITMAP *tit;
	tit = (BITMAP *)graficos[T_RECORDES].dat;
	f = pack_fopen("Recordes.rec", F_READ_PACKED);
	if(!f)
		return;
	if(pack_igetl(f) != AL_ID('R','E','C',' ')) {
		pack_fclose(f);
		return;
	}
	pack_fread(recordes, sizeof(RECORDE)*5, f);
	pack_fclose(f);

	toca_musica(RECORDES);
	acquire_screen();
	desenha_fundo();
	draw_sprite(screen, tit, 160-(tit->w/2), 20);
	desenha_borda(screen, 10, 85, 310, 225, 15);
	text_mode(-1);
	textout_centre(screen, font, "Nome", 80, 90, 53);
	textout_centre(screen, font, "Pontos", 172, 90, 53);
	textout_centre(screen, font, "Nvel", 224, 90, 53);
	textout_centre(screen, font, "Linhas", 276, 90, 53);
	for(i=0; i<5; i++) {
		textprintf_centre(screen, font,  80, 120+i*20, 0, "%s", recordes[i].nome);
		textprintf_centre(screen, font, 172, 120+i*20, 0, "%06d", recordes[i].pontos);
		textprintf_centre(screen, font, 224, 120+i*20, 0, "%02d", recordes[i].nivel);
		textprintf_centre(screen, font, 276, 120+i*20, 0, "%04d", recordes[i].linhas);
	}
	release_screen();
	fade_in(*pal, 4);
	clear_keybuf();
	if( (readkey()>>8) == KEY_F12 )
		screen_shot();
	if(midi_pos>=0)
		stop_midi();
}

/* cria um arquivo de recordes se ele no existir */
void cria_arquivo_recordes(void)
{
	PACKFILE *f;
	RECORDE recordes[5];
	int i;
	f = pack_fopen("Recordes.rec", F_WRITE_PACKED);
	if(!f)
		return;
	pack_iputl(AL_ID('R','E','C',' '), f);
	for(i=0; i<5; i++) {
		recordes[i].pontos = 0;
		recordes[i].nivel = 0;
		recordes[i].linhas = 0;
		strcpy(recordes[i].nome, "");
	}
	pack_fwrite(recordes, sizeof(RECORDE)*5, f);
	pack_fclose(f);
}

/* l um nome que entrar nos recordes */
void le_nome_recordes(char nome[16])
{
	int pos, ch;
	BITMAP *tit;
	tit = (BITMAP *)graficos[T_PARABENS].dat;
	toca_musica(NOVO_RECORDE);
	acquire_screen();
	desenha_fundo();
	draw_sprite(screen, tit, 160-(tit->w/2), 20);
	desenha_borda(screen, 20, 105, 300, 225, 15);
	text_mode(-1);
	pos = strlen(nome);
	textout_centre(screen, font, "Voc conseguiu um recorde,", 160, 120, 0);
	textout_centre(screen, font, "digite seu nome", 160, 130, 0);
	release_screen();
	fade_in(*pal, 4);
	clear_keybuf();
	do {
		acquire_screen();
		rectfill(screen, 30, 200, 290, 208, 15);
		textout_centre(screen, font, nome, 160, 200, 55);
		textout(screen, font, "_", 160+(pos*4), 200, 55);
		release_screen();
		ch = readkey() & 0xFF;
		if(isprint(ch)) {
			if(pos<15) {
				nome[pos] = ch;
				pos++;
				nome[pos] = 0;
			}
		}
		else if(ch==8) {
			if(pos) {
				pos--;
				nome[pos] = 0;
			}
		}
		release_screen();
	} while(ch!=13);
	if(midi_pos>=0)
		stop_midi();
	fade_out(4);
}

/* menu de opes */
void opcoes(void)
{
	unsigned char som_ant, mus_ant;
	int m_ant, nivel_ini_ant, bloco_ini_ant;
	int ch, cursor=0;
	char m_mus[3][20] = {
		"Repetio", "Normal (na ordem)", "Aleatrio"
	};
	int fade=1;
	BITMAP *tit;
	tit = (BITMAP *)graficos[T_OPCOES].dat;
	som_ant = som;
	mus_ant = musica;
	m_ant = musica_modo;
	nivel_ini_ant = nivel_ini;
	bloco_ini_ant = bloco_ini;
	toca_musica(OPCOES);
	acquire_screen();
	desenha_fundo();
	draw_sprite(screen, tit, 160-(tit->w/2), 20);
	desenha_borda(screen, 20, 105, 300, 225, 15);
	release_screen();
	text_mode(15);
	do	{
		acquire_screen();
		if(cursor==0)
			textprintf_centre(screen, font, 160, 110, 55, "Nvel inicial %18c%02d", ' ', nivel_ini);
		else
			textprintf_centre(screen, font, 160, 110,  0, "Nvel inicial %18c%02d", ' ', nivel_ini);
		if(cursor==1)
			textprintf_centre(screen, font, 160, 130, 55, "Altura inicial %17c%02d", ' ', bloco_ini);
		else
			textprintf_centre(screen, font, 160, 130,  0, "Altura inicial %17c%02d", ' ', bloco_ini);
		if(som==SEM)
			textout_centre(screen, font, "Som inexistente", 160, 170, 8);
		else if(cursor==2)
			textprintf_centre(screen, font, 160, 150, 55, "Som           %20s", (som!=0) ? "Ligado" : "Desligado");
		else
			textprintf_centre(screen, font, 160, 150,  0, "Som           %20s", (som!=0) ? "Ligado" : "Desligado");
		if(musica==SEM)
			textout_centre(screen, font, "Msica inexistente", 160, 190, 8);
		else if(cursor==3)
			textprintf_centre(screen, font, 160, 170, 55, "Msica        %20s", (musica!=0) ? "Ligado" : "Desligado");
		else
			textprintf_centre(screen, font, 160, 170,  0, "Msica        %20s", (musica!=0) ? "Ligado" : "Desligado");
		if(cursor==4)
			textprintf_centre(screen, font, 160, 190, 55, "Modo de msica%20s", m_mus[musica_modo]);
		else
			textprintf_centre(screen, font, 160, 190,  0, "Modo de msica%20s", m_mus[musica_modo]);
		if(musica_modo!=M_REPETE)
			textprintf_centre(screen, font, 160, 210,  8, "Msica de fundo%19s", get_datafile_property(&audio[musica_atual], DAT_ID('N','A','M','E')));
		else if(cursor==5)
			textprintf_centre(screen, font, 160, 210, 55, "Msica de fundo%19s", get_datafile_property(&audio[musica_atual], DAT_ID('N','A','M','E')));
		else
			textprintf_centre(screen, font, 160, 210,  0, "Msica de fundo%19s", get_datafile_property(&audio[musica_atual], DAT_ID('N','A','M','E')));
		release_screen();
		if(fade) {
			fade_in(*pal, 4);
			fade=0;
			clear_keybuf();
		}
		do	{
			ch = readkey()>>8;
			switch(ch) {
				case KEY_UP :
					cursor--;
					if(cursor<0) {
						if(musica_modo == M_REPETE)
							cursor = 5;
						else
							cursor = 4;
					}
					toca_som(S_RODA);
					break;
				case KEY_DOWN :
					cursor++;
					if(cursor>4) {
						if(musica_modo == M_REPETE && cursor == 5)
							;
						else
							cursor = 0;
					}
					toca_som(S_RODA);
					break;
				case KEY_LEFT :
					if(cursor==0) {
						nivel_ini--;
						if(nivel_ini<0)
							nivel_ini = 0;
					}
					else if(cursor==1) {
						bloco_ini--;
						if(bloco_ini<0)
							bloco_ini = 0;
					}
					else if(cursor==2 && som!=SEM)
						som ^= LIGA;
					else if(cursor==3 && musica!=SEM) {
						musica ^= LIGA;
						if(midi_pos>=0)
							stop_midi();
						else
							toca_musica(OPCOES);
					}
					else if(cursor==4) {
						musica_modo--;
						if(musica_modo<M_REPETE)
							musica_modo = M_RANDOM;
					}
					else if(cursor==5 && musica_modo==M_REPETE) {
						musica_atual--;
						if(musica_atual<BGM_BK_01)
							musica_atual = BGM_Z64_05;
					}
					toca_som(S_RODA);
					break;
				case KEY_RIGHT :
					if(cursor==0) {
						nivel_ini++;
						if(nivel_ini>9)
							nivel_ini = 9;
					}
					else if(cursor==1) {
						bloco_ini++;
						if(bloco_ini>12)
							bloco_ini = 12;
					}
					else if(cursor==2 && som!=SEM)
						som ^= LIGA;
					else if(cursor==3 && musica!=SEM) {
						musica ^= LIGA;
						if(midi_pos>=0)
							stop_midi();
						else
							toca_musica(OPCOES);
					}
					else if(cursor==4) {
						musica_modo++;
						if(musica_modo>M_RANDOM)
							musica_modo = M_REPETE;
					}
					else if(cursor==5 && musica_modo==M_REPETE) {
						musica_atual++;
						if(musica_atual>BGM_Z64_05)
							musica_atual = BGM_BK_01;
					}
					toca_som(S_RODA);
					break;
				case KEY_ENTER :
					toca_som(S_ENTER);
					break;
				case KEY_ESC :
					som = som_ant;
					musica = mus_ant;
					musica_modo = m_ant;
					nivel_ini = nivel_ini_ant;
					bloco_ini = bloco_ini_ant;
					break;
				case KEY_F12 :
					screen_shot();
					break;
				default :
					ch = 0;
					break;
			}
		} while (ch==0);
	} while(ch!=KEY_ENTER && ch!=KEY_ESC);
	if(midi_pos>=0)
		stop_midi();
}

/* verifica se h musica tocando e se no toca a prxima */
void verifica_musica(void)
{
	if( midi_pos>=0 || musica==SEM || musica==DESL)
		return;
	if(t_espera == 0 && !primeira_vez) {
		musica_atual = prox_musica();
		t_espera = tempo + T_ESPERA;
	}
	else if(t_espera<=tempo) {
		if(musica_modo == M_REPETE)
			play_midi((MIDI *)audio[musica_atual].dat, 1);
		else
			play_midi((MIDI *)audio[musica_atual].dat, 0);
		t_espera = 0;
	}
	primeira_vez = 0;
}

/* retorna o ndice para a prxima msica */
int prox_musica(void)
{
	int m=musica_atual;
	switch(musica_modo) {
		case M_REPETE :
			if(musica_atual<BGM_BK_01 || musica_atual>BGM_Z64_05)
				m = BGM_BK_01;
			break;
		case M_NORMAL :
			m++;
			if(m > BGM_Z64_05)
				m = BGM_BK_01;
			break;
		case M_RANDOM :
			m = (rand() % (BGM_Z64_05+1))+BGM_BK_01;
			break;
	}
	return m;
}

/* toca msicas de introduo, opes e menu principal */
void toca_musica(int n)
{
	if(musica==SEM || musica==DESL)
		return;
	switch(n) {
		case INTRO :
			play_midi((MIDI *)audio[n].dat, FALSE);
			break;
		case OPCOES :
			play_looped_midi((MIDI *)audio[n].dat, 5, 101);
			break;
		case RECORDES :
			play_midi((MIDI *)audio[n].dat, TRUE);
			break;
		case NOVO_RECORDE :
			play_midi((MIDI *)audio[n].dat, FALSE);
			break;
		case CREDITOS :
			play_midi((MIDI *)audio[n].dat, TRUE);
			break;
	}
}

/* toca os efeitos sonoros */
void toca_som(int n)
{
	if(som==SEM || som==DESL)
		return;
	play_sample((SAMPLE *)audio[n].dat, 255, 128, 1000, FALSE);
}

/* menu principal */
void menu(void)
{
	BITMAP *tit;
	int cursor, opcao, limpa;
	opcao = -1;
	cursor = 0;
	limpa=1;
	tit = (BITMAP *)graficos[T_TETRIS].dat;
	do	{
		if(limpa) {
			toca_musica(INTRO);
			acquire_screen();
			desenha_fundo();
			text_mode(-1);
			desenha_borda(screen, 100, 165, 220, 225, 15);
			draw_sprite(screen, tit, 160-(tit->w/2), 20);
			release_screen();
		}
		acquire_screen();
		if(cursor == 0)
			textout_centre(screen, font, "Jogar", 160, 170, 55);
		else
			textout_centre(screen, font, "Jogar", 160, 170, 0);
		if(cursor == 1)
			textout_centre(screen, font, "Opes", 160, 180, 55);
		else
			textout_centre(screen, font, "Opes", 160, 180, 0);
		if(cursor == 2)
			textout_centre(screen, font, "Recordes", 160, 190, 55);
		else
			textout_centre(screen, font, "Recordes", 160, 190, 0);
		if(cursor == 3)
			textout_centre(screen, font, "Crditos", 160, 200, 55);
		else
			textout_centre(screen, font, "Crditos", 160, 200, 0);
		if(cursor == 4)
			textout_centre(screen, font, "Sair", 160, 210, 55);
		else
			textout_centre(screen, font, "Sair", 160, 210, 0);
		release_screen();
		if(limpa) {
			limpa=0;
			fade_in(*pal, 4);
			clear_keybuf();
		}
		switch(readkey()>>8) {
			case KEY_UP :
				cursor--;
				if(cursor<0)
					cursor = 4;
				toca_som(S_RODA);
				break;
			case KEY_DOWN :
				cursor++;
				if(cursor>4)
					cursor=0;
				toca_som(S_RODA);
				break;
			case KEY_ENTER :
				opcao = cursor;
				toca_som(S_ENTER);
				rest(500);
				break;
			case KEY_F12 :
				screen_shot();
				break;
		}
		switch(opcao) {
			case 0 :
				if(midi_pos>=0)
					stop_midi();
				fade_out(4);
				jogar();
				limpa = 1;
				opcao = -1;
				fade_out(4);
				verificar_recordes();
				mostrar_recordes();
				fade_out(4);
				break;
			case 1 :
				if(midi_pos>=0)
					stop_midi();
				fade_out(4);
				opcoes();
				limpa = 1;
				opcao = -1;
				fade_out(4);
				break;
			case 2 :
				if(midi_pos>=0)
					stop_midi();
				fade_out(4);
				mostrar_recordes();
				limpa = 1;
				opcao = -1;
				fade_out(4);
				break;
			case 3 :
				if(midi_pos>=0)
					stop_midi();
				fade_out(4);
				creditos();
				limpa = 1;
				opcao = -1;
				fade_out(4);
				break;
		}
	} while(opcao != 4);
	fade_out(4);
}

/* mostra os crditos */
void creditos(void)
{
	int nl, max, i, pos;
	const int maxx = 40;
	char str_tmp[41];
	char str[5000];
	BITMAP *buf_txt, *tit;
	nl=0;
	max=0;
	strcpy(str, "Tetris verso 1.1\n\n\n\nprogramado por\nEduardo \"Dudaskank\"\n\n\n");
	strcat(str, "grficos por\nEduardo \"Dudaskank\"\nDo site Artexturas\n\n\n");
	strcat(str, "msicas de\nBanjo Kazooie\nFinal Fantasy VI\n007 - Goldeneye\n");
	strcat(str, "Mario Kart 64\nSuper Mario 64\nThe legeng of Zelda - Ocarina of Time\n\n\n");
	strcat(str, "testado por\nEduardo \"Dudaskank\"\nRafael Machado\nHugo Leonardo\n\n\n");
	strcat(str, "agradecimentos especiais\nAos meus amigos\nE aos aniversariantes da semana\n");
	strcat(str, "James Y.\n(o mais ninja)\nRoberta P.\n(a mais linda)\n\n\n\n\n");
	strcat(str, "dvidas, sugestes e reclamaes em\nbr.geocities.com/dudaskank\ndudaskank@yahoo.com");
	/* este primeiro lao apenas conta o n de linhas e colunas necessrios para
	   mostrar a string */
	for(i=0, pos=0; i<strlen(str); i++, pos++) {
		if(str[i] == '\n') {
			nl++;
			if(max<pos)
				max = pos;
			if(max>maxx)
				max = maxx;
			pos = -1;
		}
		if(strlen(str)-1 == i) {
			nl++;
			if(max<pos)
				max = pos;
			if(max>maxx)
				max = maxx;
			pos = -1;
		}
	}
	/* cria o buffer e agora imprime nele */
	buf_txt = create_bitmap(max*8, nl*8+1);
	clear_to_color(buf_txt, 15);
	nl = 0;
	text_mode(-1);
	acquire_bitmap(buf_txt);
	for(i=0, pos=0; i<strlen(str); i++, pos++) {
		if(str[i] == '\n') {
			if(pos>maxx)
				str_tmp[maxx] = 0;
			else
				str_tmp[pos] = 0;
			pos = -1;
			if(islower(str_tmp[0]))
				textout_centre(buf_txt, font, str_tmp, max*4, nl*8, 23);
			else
				textout_centre(buf_txt, font, str_tmp, max*4, nl*8, 53);
			nl++;
		}
		else {
			if(pos<maxx)
				str_tmp[pos] = str[i];
		}
		if(strlen(str)-1 == i) {
			if(pos>maxx-1)
				str_tmp[maxx] = 0;
			else
				str_tmp[pos+1] = 0;
			pos = -1;
			if(islower(str_tmp[0]))
				textout_centre(buf_txt, font, str_tmp, max*4, nl*8, 23);
			else
				textout_centre(buf_txt, font, str_tmp, max*4, nl*8, 53);
			nl++;
		}
	}
	release_bitmap(buf_txt);
	acquire_screen();
	clear(screen);
	desenha_fundo();
	desenha_borda(screen, 155-max*4, 105, 165+max*4, 225, 15);
	toca_musica(CREDITOS);
	tit = (BITMAP *)graficos[T_CREDITOS].dat;
	draw_sprite(screen, tit, 160-(tit->w/2), 20);
	release_screen();
	fade_in(*pal, 4);
	clear_keybuf();
	/* para no ter que multiplicar toda hora pelos mesmos nmeros */
	nl *= 8;
	pos = i = -120;
	max *= 4;
	tempo = 0;
	do {
		pos = -120 + (tempo/3);
		if(pos != i); {
			acquire_screen();
			blit(buf_txt, screen, 0, pos, 160-max, 105, max+max, 120);
			release_screen();
			i = pos;
		}
	} while(!keypressed() && pos < nl);
}

/* tira uma foto da tela */
void screen_shot(void)
{
	PALETTE pal;
	int t1, t2, i;
	char str[80];

	t1 = timer;
	t2 = tempo;
	if(midi_pos>=0)
		midi_pause();
	for(i=0; i<1000; i++) {
		sprintf(str, "ss%04d.pcx", i);
		if(!exists(str))
			break;
	}
	get_palette(pal);
	save_bitmap(str, screen, pal);
	if(midi_pos>=0)
		midi_resume();
	timer = t1;
	tempo = t2;
}


/* inicializa tudo o que for necessrio */
void inicia_tudo(void)
{
	/* faz mostrar os caracteres ASC II com acentos */
	set_uformat(U_ASCII);
	/* inicializando o bsico */
	allegro_init();

	/* entrando no modo grfico */
	fade_out(4);
	if(set_gfx_mode(GFX_AUTODETECT, 320, 240, 0, 0)) {
		allegro_message("ERRO! %s", allegro_error);
		exit(1);
	}

	srand(time(NULL));
	install_keyboard();
	install_timer();
	LOCK_VARIABLE(timer);
	LOCK_VARIABLE(tempo);
	LOCK_FUNCTION(timer_inc);
	/* timer e tempo incrementado a cada 50 milisegundos (20 frames por segundo) */
	install_int_ex(timer_inc, BPS_TO_TIMER(FPS));
	/* muda a velocidade de repeties do teclado */
	set_keyboard_rate( (int)(1000/FPS)*TEC_T1, (int)(1000/FPS)*TEC_T2 );

	/* carrega os grficos do jogo */
	graficos = load_datafile("graficos.dat");
	if(!graficos) {
		allegro_exit();
		allegro_message("ERRO! No foi encontrado o arquivo Graficos.dat\n");
		exit(1);
	}
	pal = (PALETTE *)graficos[_PALETA].dat;
	/* criando tabelas para acelerar rotinas grficas */
	create_rgb_table(&rgb_table, *pal, NULL);
	rgb_map = &rgb_table;
	create_trans_table(&trans_table, *pal, 128, 128, 128, NULL);
	color_map = &trans_table;

	/* verificando o som */
	if(!detect_digi_driver(DIGI_AUTODETECT))
		som = SEM;
	else
		som = LIGA;
	if(!detect_midi_driver(MIDI_AUTODETECT))
		musica = SEM;
	else
		musica = LIGA;
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
	musica_modo = M_NORMAL;
	musica_atual = BGM_BK_01;
	primeira_vez = 1;
	/* carregando udio */
	if(som != SEM || musica != SEM) {
		audio = load_datafile("audio.dat");
		if(!audio) {
			remove_sound();
			som = musica = SEM;
			allegro_message("Arquivo Audio.dat no encontrado\n");
		}
		else {
			vol_s = vol_m = 255;
			set_volume(vol_s, vol_m);
		}
	}

	/* se o arquivo de recordes no existe, cria um novo */
	if(!exists("Recordes.rec"))
		cria_arquivo_recordes();

	set_palette(black_palette);
	nivel_ini = 0;
	bloco_ini = 0;
}

/* libera a memria alocada previamente por inicia_tudo() */
void fecha_tudo(void)
{
	unload_datafile(graficos);
	if(audio)
		unload_datafile(audio);
}


int main(void)
{
	inicia_tudo();
	menu();
	fecha_tudo();
	allegro_exit();
	return 0;
} END_OF_MAIN();