/*-------------------------------------------------------------------------------------*/
/*          Nitrito v0.2 - carga_tex.c - Archivo carga y prepara texturas              */
/*                                                                                     */
/*                     Peazo de juego de coches 3d en opengl                           */
/*                                                                                     */
/*          Jou! Aqui empieza la accin. Hoy es: Sun Jan 27 17:28:23 2002              */
/*-------------------------------------------------------------------------------------*/

#define TEX_W 64
#define TEX_H 64



#include <stdio.h>
#include <math.h>
#include <allegro.h>
#include <alleggl.h>


#include "nitrito.h"
#include "carga_tex.h"


GLuint textura[40];
GLuint textura1[5];

void prepara_texs(void)
{
	int i;
	DATAFILE *datafile, *datafile1;

	
	datafile  = load_datafile("../data/texturas.dat");
	datafile1 = load_datafile("../data/texturas1.dat");
	
	for(i=0;i<=35;i++)
	{
		if(i>=23 && i<=28) textura[i] = carga_tex_128(datafile[i].dat);
		else if (i==34 || i==35) textura[i] = carga_tex_128(datafile[i].dat);
		else textura[i] = carga_tex(datafile[i].dat);
			
	}
	textura1[0]= carga_tex_res(datafile1[0].dat,256,256);
	textura1[1]= carga_tex_res(datafile1[1].dat,512,512);
	
	
} 

GLuint carga_tex (BITMAP *bmp)
{
	BITMAP *bmp2;
	int w, h;
	GLuint tex;

	w = TEX_W;
	h = TEX_H;
	bmp2 = create_bitmap (w, h);
	stretch_blit (bmp, bmp2, 0, 0, bmp->w, bmp->h, 0, 0, w, h);
	destroy_bitmap (bmp);

	allegro_gl_begin();
	glEnable (GL_DITHER);
	glEnable (GL_TEXTURE_2D);
	//glEnable (GL_BLEND);
	glShadeModel(GL_SMOOTH);
	glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
	glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);

	tex = allegro_gl_make_texture (bmp2);
	allegro_gl_end();

	
	destroy_bitmap (bmp2);

	return tex;
};

GLuint carga_tex_128 (BITMAP *bmp)
{
	BITMAP *bmp2;
	int w, h;
	GLuint tex;

	w = 128;
	h = 128;
	bmp2 = create_bitmap (w, h);
	stretch_blit (bmp, bmp2, 0, 0, bmp->w, bmp->h, 0, 0, w, h);
	destroy_bitmap (bmp);

	allegro_gl_begin();
	glEnable (GL_DITHER);
	glEnable (GL_TEXTURE_2D);
	//glEnable (GL_BLEND);
	glShadeModel(GL_SMOOTH);
	glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
	glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);

	tex = allegro_gl_make_texture (bmp2);
	allegro_gl_end();

	
	destroy_bitmap (bmp2);

	return tex;
};

GLuint carga_tex_res (BITMAP *bmp,int w,int h)
{
	BITMAP *bmp2;
	GLuint tex;
	
	bmp2 = create_bitmap (w, h);
	stretch_blit (bmp, bmp2, 0, 0, bmp->w, bmp->h, 0, 0, w, h);
	destroy_bitmap (bmp);

	allegro_gl_begin();
	glEnable (GL_DITHER);
	glEnable (GL_TEXTURE_2D);
	//glEnable (GL_BLEND);
	glShadeModel(GL_SMOOTH);
	glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
	glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);

	tex = allegro_gl_make_texture (bmp2);
	allegro_gl_end();

	
	destroy_bitmap (bmp2);

	return tex;
};

GLuint carga_tex_a (char* archivo)
{
	PALETTE pal;
	BITMAP *bmp, *bmp2;
	int w, h;
	GLuint tex;

	bmp = load_bitmap (archivo, pal);
	if (!bmp) {
		allegro_message ("Error loading %s",archivo);
		exit (1);
	}
	w = TEX_W;
	h = TEX_H;
	bmp2 = create_bitmap (w, h);
	stretch_blit (bmp, bmp2, 0, 0, bmp->w, bmp->h, 0, 0, w, h);
	destroy_bitmap (bmp);

	allegro_gl_begin();
	glEnable (GL_DITHER);
	glEnable (GL_TEXTURE_2D);
	//glEnable (GL_BLEND);
	glShadeModel(GL_SMOOTH);
	glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
	glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);

	tex = allegro_gl_make_texture (bmp2);
	allegro_gl_end();

	//glDisable (GL_BLEND);
	destroy_bitmap (bmp2);

	return tex;
};

GLuint carga_tex_a_128 (char* archivo)
{
	PALETTE pal;
	BITMAP *bmp, *bmp2;
	int w, h;
	GLuint tex;

	bmp = load_bitmap (archivo, pal);
	if (!bmp) {
		allegro_message ("Error loading %s",archivo);
		exit (1);
	}
	w = 128;
	h = 128;
	bmp2 = create_bitmap (w, h);
	stretch_blit (bmp, bmp2, 0, 0, bmp->w, bmp->h, 0, 0, w, h);
	destroy_bitmap (bmp);

	allegro_gl_begin();
	glEnable (GL_DITHER);
	glEnable (GL_TEXTURE_2D);
	//glEnable (GL_BLEND);
	glShadeModel(GL_SMOOTH);
	glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
	glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);

	tex = allegro_gl_make_texture (bmp2);
	allegro_gl_end();

	
	destroy_bitmap (bmp2);

	return tex;
};

GLuint carga_tex_a_res (char* archivo,int w,int h)
{
	PALETTE pal;
	BITMAP *bmp, *bmp2;
	GLuint tex;

	bmp = load_bitmap (archivo, pal);
	if (!bmp) {
		allegro_message ("Error loading %s",archivo);
		exit (1);
	}
	bmp2 = create_bitmap (w, h);
	stretch_blit (bmp, bmp2, 0, 0, bmp->w, bmp->h, 0, 0, w, h);
	destroy_bitmap (bmp);

	allegro_gl_begin();
	glEnable (GL_DITHER);
	glEnable (GL_TEXTURE_2D);
	//glEnable (GL_BLEND);
	glShadeModel(GL_SMOOTH);
	glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
	glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);

	tex = allegro_gl_make_texture (bmp2);
	allegro_gl_end();

	
	destroy_bitmap (bmp2);

	return tex;
};











