/*-------------------------------------------------------------------------------------*/
/*              Nitrito v0.2 - teclado.c - Lee el taclado y calcula fisicas            */
/*                                                                                     */
/*                     Peazo de juego de coches 3d en opengl                           */
/*                                                                                     */
/*          Jou! Aqui empieza la accin. Hoy es: Sun Jan 27 17:28:23 2002              */
/*-------------------------------------------------------------------------------------*/

#include <allegro.h>
#include <math.h>


#include "nitrito.h"
#include "teclado.h"
#include "render.h"
#include "mapas.h"

float vel_vert = 0;
float vel_front = 0;

float cabeza;

int colisionx = FALSE;
int colisionz = FALSE;

int casilla_actual;
int casillax;
int casillaz;

struct vectores{
	float x,z,y,a,m;
} u,vel,ftotal,fmotor,ffreno,faire,fsuelo_l,fsuelo_f; 


float rpm             =  0.00;
float fuerza_motor    =  0.06;
float mu_aire         =  0.002; 
float mu_suelo        =  0.03; 
float fuerza_freno    =  0.02;
float fuerza_gravedad = -0.01;

float vel_a           =  0.00;
float vel_ruedas      =  0.02;
float beta            =  0.02;


void teclado(void)
{
	int piso;
	int i;
	float vt;
	
	u.x=-sin(camara.yangle*3.14/180);
	u.z=cos(camara.yangle*3.14/180);
	u.y=sin(camara.xangle*3.14/180);
		
	if(vel.z==0) vel.a=0;
	else vel.a=atan(vel.x/vel.z)*180/3.14;
	
	if(vel.z==0 && vel.x==0) vel.m=0;
	else vel.m=sqrt(pow(vel.x,2)+pow(vel.z,2));
	
	if(camara.yangle>360) camara.yangle-=360;
	if(camara.yangle<0) camara.yangle+=360;
	beta=vel.a-camara.yangle;
	
	
	if (key[KEY_UP]) 										//ACELERA Y FRENA
	{
		if(rpm!=0.0) 
		{
			if(rpm<22)
			{
				rpm=rpm+0.3;
			}
		}
		else rpm+=0.3;
			
		fmotor.x = u.x * fuerza_motor*rpm/100;
		fmotor.z = u.z * fuerza_motor*rpm/100;  
		//fmotor.y = u.y * fuerza_motor*rpm/100; 
	}
	else
	{
		fmotor.x = u.x * fuerza_motor*rpm/100;
		fmotor.z = u.z * fuerza_motor*rpm/100;  
		if(rpm>0) 
		{
			rpm-=0.3;
			if(rpm<0) rpm=0;
		}
	}
	if (key[KEY_DOWN])
	{
		if(rpm>0) 
		{
			rpm-=0.4;
			if(rpm<0) rpm=0;
		}
		ffreno.x = -vel.x * fuerza_freno; 
		ffreno.z = -vel.z * fuerza_freno; 
	}
	else if(!key[KEY_DOWN])
	{
		ffreno.x = 0;
		ffreno.z = 0;  
		ffreno.y = 0; 
	}
	
	if (key[KEY_RIGHT])
	{
		if(vel_a<5) 
		{
			vel_a+=0.6;
		}
	}
	if (key[KEY_LEFT])
	{
		if(key[KEY_LCONTROL]) {if(vel_a>-7) vel_a-=0.6;}
		else {if(vel_a>-5) vel_a-=0.6;}
	}
	
	if(key[KEY_LCONTROL])
	{
		fmotor.x/=2;
		fmotor.z/=2;
		if(vel_a>0)
		{
			vel_a-=0.1;
			if(vel_a<0) vel_a=0;
		
		}
		if(vel_a<0)
		{
			vel_a+=0.1;
			if(vel_a>0) vel_a=0;
		
		}
		rpm/=1.1;
	}
	else
	{
		if(vel_a>0)
		{
			vel_a-=0.3;
			if(vel_a<0) vel_a=0;
		}
		if(vel_a<0)
		{
			vel_a+=0.3;
			if(vel_a>0) vel_a=0;
		}
	}
	if (key[KEY_SPACE])
	{
		vel.y=0.3;
	}
	
	faire.x = -mu_aire * vel.x * abs (vel.x);
	faire.z = -mu_aire * vel.z * abs (vel.z);
	faire.y = -mu_aire * vel.y * abs (vel.y);
	
	/*fsuelo_l.x = -mu_suelo * sin(90-beta*3.14/180)*vel.m;
	fsuelo_l.z = -mu_suelo * cos(90-beta*3.14/180)*vel.m;*/
	//fsuelo.y = -mu_suelo * vel.y;
	
	fsuelo_l.x = -mu_suelo * vel.x;
	fsuelo_l.z = -mu_suelo * vel.z;
	
	ftotal.x = fmotor.x + ffreno.x + faire.x + fsuelo_l.x;
	ftotal.z = fmotor.z + ffreno.z + faire.z + fsuelo_l.z;
	ftotal.y = fmotor.y + ffreno.y + faire.y + fuerza_gravedad;

	vel.x += ftotal.x*2;
	vel.z += ftotal.z*2;
	vel.y += ftotal.y;
		
	camara.dist_z += vel.z;
	camara.dist_x += vel.x;
	camara.dist_y += vel.y;
	camara.yangle += vel_a;
	//camara.xangle = -vel.y*30;
	
	if(cabeza>360) cabeza=0;
		else cabeza+=4;
	
	
	for(i=0;i<2;i++)
	{
		if(i==0)
		{
		casillax=(int)floor((camara.dist_x+vel.x)/3);
		casillaz=(int)floor(camara.dist_z/3);
		casilla_actual = mapa[(int)floor(-(camara.dist_z)/3)+1][(int)floor(-(camara.dist_x+vel.x)/3)];			
		}
		if(i==1)
		{
		casillax=(int)floor(camara.dist_x/3);
		casillaz=(int)floor((camara.dist_z+vel.z)/3);
		casilla_actual = mapa[(int)floor(-(camara.dist_z+vel.z)/3)+1][(int)floor(-(camara.dist_x)/3)];			
		}		
		
		vt=vel.y;
		
		piso=0;
		if(casilla_actual>=200 && casilla_actual<400)
		{
			piso=1;
			casilla_actual-=200;
			
		}
		if(casilla_actual>=400 && casilla_actual<600)
		{
			piso=2;
			casilla_actual-=400;
			
		}
		if(casilla_actual>=600 && casilla_actual<800)
		{
			piso=3;
			casilla_actual-=600;
			
		}
		if(casilla_actual>=800 && casilla_actual<1000)
		{
			piso=4;
			casilla_actual-=800;
			
		}
		
		if(casilla_actual<=100
		||  casilla_actual==129)  //suleo normal, arboles, etc...
		{
			if(camara.dist_y<1+piso)
			{
				camara.dist_y=1+piso;
				vel.y=0;
			}
		}
		else if(casilla_actual==101
			||  casilla_actual==116
			||  casilla_actual==120) //trampolines y rampas
		{
			if(camara.dist_y<2+piso)
			{
				vel.y=(((camara.dist_z-casillaz*3)+3)/3)-camara.dist_y+piso;
			}
		}
		else if(casilla_actual==102
			||  casilla_actual==117
			||  casilla_actual==121)
		{
			if(camara.dist_y<2+piso)
			{
				vel.y=-((camara.dist_z-casillaz*3)/3)+2-camara.dist_y+piso;
			}
		}
		else if(casilla_actual==103
			||  casilla_actual==118
			||  casilla_actual==122)
		{
			if(camara.dist_y<2+piso)
			{
				vel.y=-((camara.dist_x-casillax*3)/3)+2-camara.dist_y+piso;
			}
		}
		else if(casilla_actual==104
			||  casilla_actual==119
			||  casilla_actual==123)
		{
			if(camara.dist_y<2+piso)
			{
				vel.y=(((camara.dist_x-casillax*3)+3)/3)-camara.dist_y+piso;
			}
		}
		else if(casilla_actual==105 /*muros*/
			||  casilla_actual==106
			||  casilla_actual==107
			||  casilla_actual==108
			||  casilla_actual==109
			||  casilla_actual==110
			||  casilla_actual==111
			||  casilla_actual==112
			||  casilla_actual==113
			||  casilla_actual==114
			||  casilla_actual==115) 
		{
			if(camara.dist_y<2.5+piso)
			{	
				vel.y=2.5-camara.dist_y+piso;
			}
			if(camara.dist_y<1+piso)
			{	
				camara.dist_y=1+piso;
			}
		}
		else if(casilla_actual==124 /*casa 6 de alto*/
			||  casilla_actual==125
			||  casilla_actual==126
			||  casilla_actual==127
			||  casilla_actual==128
			||  casilla_actual==132) 
		{
			if(camara.dist_y<7+piso)
			{	
				vel.y=7-camara.dist_y+piso;
			}
			if(camara.dist_y<1+piso)
			{	
				camara.dist_y=1+piso;
			}
		}
		else if(casilla_actual==130
			|| casilla_actual==131) //casa 12 de alto (2 pisos) o cuatro, segun se mire. 
		{
			if(camara.dist_y<13+piso)
			{	
				vel.y=13-camara.dist_y+piso;
			}
			if(camara.dist_y<1+piso)
			{	
				camara.dist_y=1+piso;
			}
		}
		else if(casilla_actual<=133)  //rampas esquina
		{
			if(camara.dist_y<2+piso)
			{
				vel.y=minimo(-((camara.dist_x-casillax*3)/3)+2-camara.dist_y+piso,-((camara.dist_z-casillaz*3)/3)+2-camara.dist_y+piso);		
			}
		}
		else if(casilla_actual<=134)  //rampas esquina
		{
			if(camara.dist_y<2+piso)
			{
				vel.y=minimo((((camara.dist_x-casillax*3)+3)/3)-camara.dist_y+piso,-((camara.dist_z-casillaz*3)/3)+2-camara.dist_y+piso);		
			}
		}
		else if(casilla_actual<=135)  //rampas esquina
		{
			if(camara.dist_y<2+piso)
			{
				vel.y=minimo(-((camara.dist_x-casillax*3)/3)+2-camara.dist_y+piso,(((camara.dist_z-casillaz*3)+3)/3)-camara.dist_y+piso);		
			}
		}
		else if(casilla_actual<=136)  //rampas esquina
		{
			if(camara.dist_y<2+piso)
			{
				vel.y=minimo((((camara.dist_x-casillax*3)+3)/3)-camara.dist_y+piso,(((camara.dist_z-casillaz*3)+3)/3)-camara.dist_y+piso);		
			}
		}
		else vel.y=0;
			
		if(i==0)
		{
			if(vel.x<=0 && vel.y>0.7) 
			{
				colisionx = TRUE;
				vel.x=-ftotal.x-vel.x/4;
				vel.y=vt;
				if(!key[KEY_UP]) rpm/=4;
					else rpm/=2;
			}	
			else if(vel.x>0 && vel.y>0.7) 
			{
				colisionx = TRUE;
				vel.x=-ftotal.x-vel.x/4;
				vel.y=vt;
				if(!key[KEY_UP]) rpm/=4;
					else rpm/=2;
			}
			else colisionx=FALSE;		
				
		}
		if(i==1)
		{
			if(vel.z<=0 && vel.y>0.7) 
			{
				colisionz = TRUE;
				vel.z=-ftotal.z-vel.z/4;
				vel.y=vt;
				if(!key[KEY_UP])rpm/=4;
					else rpm/=2;

			}	
			else if(vel.z>0 && vel.y>0.7) 
			{
				colisionz = TRUE;
				vel.z=-ftotal.z-vel.z/4;
				vel.y=vt;
				if(!key[KEY_UP])rpm/=4;
					else rpm/=2;

			}
			else colisionz=FALSE;			
		}
	}
	
	if(camara.dist_x>-1 || camara.dist_x<-149) 
	{
		colisionx = TRUE;
		colisionx = TRUE;
		vel.x=-vel.x*1.1;
		vel.y=vt;
		if(!key[KEY_UP]) rpm/=4;
			else rpm/=2;

	}
	if(camara.dist_z>2 || camara.dist_z<-146) 
	{
		colisionz = TRUE;
		vel.z=-vel.z*1.1;
		vel.y=vt;
		if(!key[KEY_UP]) rpm/=4;
			else rpm/=2;
	}

	if(colisionz==TRUE) camara.dist_z += vel.z;
	if(colisionx==TRUE) camara.dist_x += vel.x;
	
	vel_vert =vel.m;
	vel_front=rpm;

}

