/*-------------------------------------------------------------------------------------*/
/*                   Nitrito v0.2 - main.c - Archivo principal                         */
/*                                                                                     */
/*                     Peazo de juego de coches 3d en opengl                           */
/*                                                                                     */
/*          Jou! Aqui empieza la accin. Hoy es: Sun Jan 27 17:28:23 2002              */
/*-------------------------------------------------------------------------------------*/


#include <stdio.h>
#include <math.h>
#include <allegro.h>
#include <alleggl.h>


#include "nitrito.h"
#include "carga_tex.h" 
#include "render.h" 
#include "teclado.h"
#include "mapas.h"
#include "fuentes.h"
#include "sonido.h"
#include "menu.h"

#define FPS 35



cam camara;

int frame;
volatile int contador_frames;
volatile int contador_frames2;

void cuenta_frames(void)
{
	contador_frames++;
}
END_OF_FUNCTION(cuenta_frames);

void segundos(void)
{
	contador_frames=0; 
	contador_frames2=0;
}
END_OF_FUNCTION(segundos);

GLfloat fogcolor[4]= {0.5f,0.5f,0.5f,1.0f}; 

float minimo(float a, float b)
{
	if(a<b) return a;
	else return b;
}

int main()

{

	
	allegro_init();
	install_keyboard();
	install_timer();
	install_sound(DIGI_AUTODETECT,MIDI_NONE,0);
	set_volume(200,0);
	install_allegro_gl();

	allegro_gl_clear_settings();
	allegro_gl_set (AGL_Z_DEPTH, 16);
	allegro_gl_set (AGL_DOUBLEBUFFER, 1);
	allegro_gl_set (AGL_STENCIL_DEPTH, 1);
	allegro_gl_set (AGL_RENDERMETHOD, 1);
	allegro_gl_set (AGL_WINDOWED, FALSE);
	allegro_gl_set (AGL_SUGGEST, AGL_Z_DEPTH | AGL_DOUBLEBUFFER | AGL_STENCIL_DEPTH
			| AGL_RENDERMETHOD);

	set_color_depth (16);
	if (set_gfx_mode(GFX_OPENGL, 640, 480, 0, 0) < 0) {
		allegro_message ("Error poniendo el modo grafico:\n%s\n", allegro_error);
		return -1;
	}

	allegro_gl_set_texture_format(GL_RGB16);
	allegro_gl_use_alpha_channel(TRUE);
	
		
	LOCK_FUNCTION(cuenta_frames);
	LOCK_FUNCTION(segundos);
	LOCK_VARIABLE(contador_frames);
	LOCK_VARIABLE(contador_frames2);	
	
	install_int (cuenta_frames, 1000/FPS);
	install_int (segundos, 1000);

	allegro_gl_screen_mode (AGL_MODE_DIRECT);
	

	allegro_gl_begin();
	glClearColor (0.5, 0.5, 0.5, 1);
	glShadeModel (GL_SMOOTH);
	glPolygonMode (GL_FRONT, GL_FILL);
	glPolygonMode (GL_BACK, GL_POINTS);
	glEnable (GL_DEPTH_TEST);
	glCullFace (GL_BACK);
	glEnable (GL_CULL_FACE);
	
	allegro_gl_end();
	carga_fuentes();
	prepara_texs();
	selecciona_mapa(1);
	inicializa_camara();
	posiciona_camara();
	carga_sonidos();
	menu();
	
	while(!key[KEY_ESC]) 
	{
		teclado();
		posiciona_camara();
		renderiza();
		reproduce_sonidos();
		contador_frames2++;
		frame=contador_frames2;
		while(contador_frames2>contador_frames);
		
	}

	

	allegro_exit();

	return (0);
} 

END_OF_MAIN();


