/*
 *  Surround.
 * 
 *  Written  10-14 November, 1997.
 *  Modified 14 November, 2000.
 */

#include <stdio.h>
#include <allegro.h>
#include <jgmod.h>

BITMAP *dbuf;
BITMAP *status_bar;
char level[1024];
char music[1024];

/* samples and music */

enum {
    SND_WIN1,
    SND_WIN2,
    SND_WIN3,
    SND_DEATH1,
    SND_DEATH2,
    SND_MAX
};

char *sound_files[SND_MAX] = {
    "win.wav",
    "win2.wav",
    "win3.wav",
    "death.wav",
    "death2.wav"
};

SAMPLE *sounds[SND_MAX];
JGMOD *mod;

/* game variables */

int done;
int num_worms;
int wrapping;
int no_lives;
int restart;
int speed;
int lives;

struct {
    int x, y;
    int xv, yv;
    int dead;
    int lives;
    int wins;
} worm[4];

struct {
    int up;
    int down;
    int left;
    int right;
} controls[4] = {
    { KEY_UP, KEY_DOWN, KEY_LEFT, KEY_RIGHT },
    { KEY_W, KEY_S, KEY_A, KEY_D },
    { KEY_U, KEY_J, KEY_H, KEY_K },
    { KEY_HOME, KEY_END, KEY_DEL, KEY_PGDN }
};

/*
 *  The game.
 */

void give_lives()
{
    int p;

    for (p = 0; p < num_worms; p++)
	if (!no_lives)
	    worm[p].lives = lives;
	else 
	    worm[p].wins = 0;
}

void init_worms()
{
    int p;

    for (p = 0; p < num_worms; p++) {
	worm[p].xv = worm[p].yv = 0;

	worm[p].dead = 0;
	if (!no_lives && (worm[p].lives < 0))
	    worm[p].dead = 1;

	/* 
	 * 0 | 2
	 * --+--
	 * 3 | 1
	 */

	if (p == 0 || p == 2)
	    worm[p].y = 50;
	else
	    worm[p].y = 180 - 50;

	if (p == 0 || p == 3) {
	    worm[p].x = 50;
	    worm[p].xv = 1;
	}
	else {
	    worm[p].x = 320 - 50;
	    worm[p].xv = -1;
	}
    }
}

void inline draw(int x, int y, int worm)
{
    rect(dbuf, x, y, x + 1, y + 1, worm + 1);
}

void get_inputs()
{
    int p;

    for (p = 0; p < num_worms; p++) {
	if (key[controls[p].up]) {
	    if (!worm[p].yv) {
		worm[p].xv = 0;
		worm[p].yv = -1;
	    }
	}
	else if (key[controls[p].down]) {
	    if (!worm[p].yv) {
		worm[p].xv = 0;
		worm[p].yv = 1;
	    }
	}
	else if (key[controls[p].left]) {
	    if (!worm[p].xv) {
		worm[p].xv = -1;
		worm[p].yv = 0;
	    }
	}
	else if (key[controls[p].right]) {
	    if (!worm[p].xv) {
		worm[p].xv = 1;
		worm[p].yv = 0;
	    }
	}
    }
}

void move_worms()
{
    int p;

    for (p = 0; p < num_worms; p++)
	if (!worm[p].dead) {
	    worm[p].x += worm[p].xv * 2;
	    worm[p].y += worm[p].yv * 2;
	}
}

void check_wrap()
{
    int p;

    if (!wrapping) return;

    for (p = 0; p < num_worms; p++) {
	if (worm[p].x < 2) worm[p].x = 316;
	if (worm[p].y < 2) worm[p].y = 176;
	if (worm[p].x > 316) worm[p].x = 2;
	if (worm[p].y > 176) worm[p].y = 2;
    }
}

inline int getpx(BITMAP *bmp, int x, int y)
{
    if ((x < 0) || (x >= bmp->w) ||
	(y < 0) || (y >= bmp->h))
	return !wrapping;
    else
	return getpixel(bmp, x, y);
}

void play_death_sound()
{
    play_sample(sounds[SND_DEATH1 + (rand() % 2)], 255, 128, 1000, FALSE);
}
 
void check_collisions()
{
    int p, q;

    for (p = 0; p < num_worms; p++) {
	int hit = 0;

	if (worm[p].yv < 0) {	/* up */
	    if (getpx(dbuf, worm[p].x, worm[p].y) ||
		getpx(dbuf, worm[p].x + 1, worm[p].y))
		hit = 1;
	}
	else if (worm[p].yv > 0) { /* down */
	    if (getpx(dbuf, worm[p].x, worm[p].y + 1) ||
		getpx(dbuf, worm[p].x + 1, worm[p].y + 1))
		hit = 1;
	}
	else if (worm[p].xv < 0) { /* left */
	    if (getpx(dbuf, worm[p].x, worm[p].y) ||
		getpx(dbuf, worm[p].x, worm[p].y + 1))
		hit = 1;
	}
	else if (worm[p].xv > 0) { /* right */
	    if (getpx(dbuf, worm[p].x + 1, worm[p].y) ||
		getpx(dbuf, worm[p].x + 1, worm[p].y + 1))
		hit = 1;
	}

	if (hit) {
	    worm[p].dead = 1;
	    worm[p].x -= worm[p].xv * 2;
	    worm[p].y -= worm[p].yv * 2;
	    play_death_sound();
	}
	else {
	    for (q = 0; q < num_worms; q++)
		if ((p != q) && ((worm[p].x == worm[q].x) && (worm[p].y == worm[q].y))) {
		    worm[p].dead = worm[q].dead = 1;
		    draw(worm[p].x, worm[p].y, p); /* hack */
		    play_death_sound();
		}
	}
    }
}

void draw_worms()
{
    int p;

    for (p = 0; p < num_worms; p++) {
	if (!worm[p].dead)
	    draw(worm[p].x, worm[p].y, p);
    }
}

void display_status()
{
    int save, p;

    blit(status_bar, dbuf, 0, 0, 0, 200 - 20, 320, 20);

    save = text_mode(-1);
    
    for (p = 0; p < num_worms; p++)
	if (no_lives)
	    textprintf(dbuf, font, 20 + p * 80, 186, 0, "WINS: %d", worm[p].wins);
	else {
	    if (worm[p].dead)
		textout(dbuf, font, "DEAD", 20 + p * 80, 186, 0);
	    else
		textprintf(dbuf, font, 20 + p * 80, 186, 0, "LIVES:%d", worm[p].lives);
	}

    text_mode(save);
}

void continue_game()
{
    PALETTE pal;

    rest(250);
    dbuf = load_pcx(level, pal);
    if (!dbuf) exit(1);
    init_worms();
}

void check_for_winner()
{
    int p, alive = 0, winner = 0;

    for (p = 0; p < num_worms; p++)
	if (worm[p].lives >= 0) 
	    alive++, winner = p;

    if (alive == 1) {
	char s[80];

	play_sample(sounds[SND_WIN1 + random() % 3], 255, 128, 1000, FALSE);
	sprintf(s, "Player %d wins!", winner + 1);
	alert(s, "", "", "Ok", NULL, 13, 0);
	done = 1;
    }
    else if (alive == 0) {
	alert("Draw game!", "", "", "Ok", NULL, 13, 0);
	done = 1;
    }
    else {
	continue_game();
    }
}

void game_loop()
{
    PALETTE pal;
    int p, dead;

    show_mouse(NULL);

    dbuf = load_pcx(level, pal);
    if (!dbuf) goto end;

    set_palette(pal);
    gui_fg_color = makecol(0, 0, 0);
    gui_bg_color = makecol(255, 255, 255);

    give_lives();
    init_worms();

    done = 0;

    while (!done) {
	get_inputs();
	move_worms();
	check_wrap();
	check_collisions();

	draw_worms();
	display_status();
	blit(dbuf, screen, 0, 0, 0, 0, 320, 200);

	/* count deaths */
	dead = 0;
	for (p = 0; p < num_worms; p++)
	    if (no_lives) {
		if (worm[p].dead)
		    dead++;
	    }
	    else {
		if (worm[p].dead && (worm[p].lives >= 0))
		    dead++;
	    }

	/* check end of match */
	if (dead == (num_worms - 1) || (restart && dead)) { 
	    if (no_lives) {
		for (p = 0; p < num_worms; p++)
		    if (!worm[p].dead)
			worm[p].wins++;

		continue_game();
	    }
	    else {
		for (p = 0; p < num_worms; p++)
		    if (worm[p].dead)
			worm[p].lives--;

		check_for_winner();
	    }
	}
	else if (dead == num_worms) {
	    if (!no_lives) {
		for (p = 0; p < num_worms; p++)
		    worm[p].lives--;
		check_for_winner();
	    }
	    continue_game();
	}

	rest(speed);

	if (key[KEY_ESC])
	    done = 1;
    }

    destroy_bitmap(dbuf);

  end:
    
    show_mouse(screen);
    clear_keybuf();
}


/*
 *  Menu.
 */

char *player_list(int index, int *list_size);
int select_proc(int msg, DIALOG *d, int c);
int play_proc(int msg, DIALOG *d, int c);
void set_menu_colours();

DIALOG main_dlg[] =
{
    /* (dialog proc) (x) (y) (w) (h) (fg) (bg) (key) (flags) (d1) (d2) (dp) (dp2) (dp3) */
    { d_clear_proc, 0, 0, 320, 200 },

    { d_list_proc, 40, 40, 9 * 12, 28, 0, 0, 0, 0, 0, 0, player_list },
    { select_proc, 40, 80, 9 * 12, 12, 0, 0, 0, 0, 0, 0, "SELECT LEVEL",
      "Select level", "[level]" },
    { select_proc, 40, 96, 9 * 12, 12, 0, 0, 0, 0, 0, 0, "SELECT MUSIC",
      "Select music", "[music]" },

    { d_radio_proc, 40, 120, 9 * 6, 12, 0, 0, 0, 0, 3, 0, "SLOW" },
    { d_radio_proc, 40, 134, 9 * 6, 12, 0, 0, 0, 0, 3, 0, "NORMAL" },
    { d_radio_proc, 40, 148, 9 * 6, 12, 0, 0, 0, 0, 3, 0, "FAST" },

    { d_text_proc, 160, 40, 0, 0, 0, 0, 0, 0, 0, 0, "AFTER EVERY DEATH" },
    { d_radio_proc, 180, 50, 9 * 7, 12, 0, 0, 0, 0, 0, 0, "CONTINUE" },
    { d_radio_proc, 180, 64, 9 * 8, 12, 0, 0, 0, 0, 0, 0, "RESTART" },

    { d_radio_proc, 180, 90, 9 * 7, 12, 0, 0, 0, 0, 1, 0, "5 LIVES" },
    { d_radio_proc, 180, 104, 9 * 9, 12, 0, 0, 0, 0, 1, 0, "10 LIVES" },
    { d_radio_proc, 180, 118, 9 * 11, 12, 0, 0, 0, 0, 1, 0, "NO LIVES" },

    { d_check_proc, 180, 140, 9 * 7, 12, 0, 0, 0, 0, 0, 0, "WRAP" },

    { play_proc, 80, 170, 9 * 7, 12, 0, 0, 0, 0, 0, 0, "PLAY!" },
    { d_button_proc, 180, 170, 9 * 7, 12, 0, 0, 0, D_EXIT, 0, 0, "EXIT" },

    { d_text_proc, 140, 5, 0, 0, 0, 0, 0, 0, 0, 0, "SURROUND" },
    { NULL }
};

#define DLG_PLAYERS     1
#define DLG_SLOW        4
#define DLG_NORMAL      5
#define DLG_FAST        6
#define DLG_CONTINUE    8
#define DLG_RESTART     9
#define DLG_5LIVES      10
#define DLG_10LIVES     11
#define DLG_NOLIVES     12
#define DLG_WRAP        13

char *player_list(int index, int *list_size)
{
    char *str[] = {
	"2 PLAYERS",
	"3 PLAYERS",
	"4 PLAYERS"
    };

    if (index < 0) {
	*list_size = 3;
	return NULL;
    }
    
    return str[index];
}

int select_proc(int msg, DIALOG *d, int c)
{
    char path[1024];

    if ((msg == MSG_KEY) || (msg == MSG_CLICK)) {
	d_button_proc(msg, d, c);
	
	if (!strcmp(d->dp3, "[level]")) {
	    strcpy(path, level);
	    if (file_select(d->dp2, path, "lev"))
		strcpy(level, path);
	}
	else {
	    strcpy(path, music);
	    if (file_select(d->dp2, path, "mod;xm;s3m;it;jgm")) {
		strcpy(music, path);
		if (mod) destroy_mod(mod);
		if ((mod = load_mod(music)))
		    play_mod(mod, TRUE);
	    }
	}
	
	d->flags ^= D_SELECTED;
	return D_REDRAW;
    }
    
    return d_button_proc(msg, d, c);
}

int play_proc(int msg, DIALOG *d, int c)
{
    if ((msg == MSG_KEY) || (msg == MSG_CLICK)) {
	d_button_proc(msg, d, c);
	    
	wrapping  = main_dlg[DLG_WRAP].flags & D_SELECTED;
	num_worms = main_dlg[DLG_PLAYERS].d1 + 2;
	no_lives  = main_dlg[DLG_NOLIVES].flags & D_SELECTED;
	restart   = main_dlg[DLG_RESTART].flags & D_SELECTED;

	if (main_dlg[DLG_SLOW].flags & D_SELECTED)
	    speed = 30;
	else if (main_dlg[DLG_NORMAL].flags & D_SELECTED)
	    speed = 20;
	else
	    speed = 10;

	if (main_dlg[DLG_5LIVES].flags & D_SELECTED)
	    lives = 4;
	else if (main_dlg[DLG_10LIVES].flags & D_SELECTED)
	    lives = 9;

	game_loop();
	
	set_menu_colours();

	d->flags ^= D_SELECTED;
	return D_REDRAW;
    }

    return d_button_proc(msg, d, c);
}

void set_menu_colours()
{
    int black, white;
    
    set_palette(desktop_palette);
    gui_fg_color = black = makecol(0, 0, 0);
    gui_bg_color = white = makecol(255, 255, 255);
    set_dialog_color(main_dlg, black, white);
}

void main_menu()
{
    set_menu_colours();
    
    main_dlg[DLG_5LIVES].flags  = D_SELECTED;
    main_dlg[DLG_CONTINUE].flags = D_SELECTED;
    main_dlg[DLG_NORMAL].flags   = D_SELECTED;

    do_dialog(main_dlg, -1);
}

/*
 *  Data loading.
 */

char exe_path[1024];

char *dirs[] =
{
    ".",
    exe_path,
#ifdef ALLEGRO_UNIX
    "/usr/local/share/surround",
    "/usr/share/surround",
#endif
    NULL
};

char *find_resource(char *dest, char *filename)
{
    char path[1024], **dir;
    
    for (dir = dirs; *dir; dir++) {
	sprintf(path, "%s/%s", *dir, filename);
	if (exists(path)) return strcpy(dest, path);
    }
    
    return NULL;    
}

BITMAP *load_bitmap_dirs(char *filename, PALETTE pal)
{
    char path[1024];
    return find_resource(path, filename) ? load_bitmap(path, pal) : 0;
}

SAMPLE *load_sample_dirs(char *filename)
{
    char path[1024];
    return find_resource(path, filename) ? load_sample(path) : 0;
}

void load_sounds()
{
    int i;
    for (i = 0; i < SND_MAX; i++)
	sounds[i] = load_sample_dirs(sound_files[i]);
}

void free_sounds()
{
    int i;
    for (i = 0; i < SND_MAX; i++)
	if (sounds[i]) destroy_sample(sounds[i]);
}

/*
 *  Main.
 */

int main(int argc, char *argv[])
{
    allegro_init();
    install_timer();
    install_keyboard();
    install_mouse();
    reserve_voices(32, 0);
    install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);
    install_mod(24);
    if (set_gfx_mode(GFX_AUTODETECT, 320, 200, 0, 0) < 0)
	return 1;

    replace_filename(exe_path, argv[0], "", sizeof exe_path);
    if (!find_resource(level, "blank.lev"))
	return 1;
    if (!(status_bar = load_bitmap_dirs("status.pcx", 0)))
	return 1;
    load_sounds();
    if (find_resource(music, "testmus.mod"))
	if ((mod = load_mod(music))) play_mod(mod, TRUE);

    main_menu();

    if (mod) destroy_mod(mod);
    free_sounds();
    destroy_bitmap(status_bar);
    return 0;
}

END_OF_MAIN();
