#include "main.h"

#include "shot.h"

#include "attacker.h"

#include "defense.h"

#include "explosion.h"

#include "lander.h"

Shot *Shot::first = 0;

void Shot::deleteall() { deletesome((Entity **)&first); }
void Shot::displayall() { displaysome((Entity **)&first); }
void Shot::moveall(float d) { movesome((Entity **)&first, d); }

Shot::Shot(float r_, float h_) : Entity(r_, h_, 4, (Entity **)&first) {		
			
	hd = 100;
	if(!no_sound) play_sample((SAMPLE *)(data[SHOT_WAV].dat), 255, 127, 1000, 0);
}

void Shot::move(float d) {
	
	h += hd * d;
			
	if(h > 240) {
		dead = true;
	}
	
	rh2xy();
	
	if(Attacker::collidefirst(this)) {
		dead = true;
		
		new Explosion(r, h);
						
	}
	
	if(Lander::collidefirst(this)) {
		dead = true;
		
		new Explosion(r, h);
						
	}
	
	if(Defense::collidefirst(this)) {
		dead = true;
		
		new Explosion(r, h);
	}		
		
}

void Shot::display() {		
	
	//circlefill(page, int(x + 320), int(240 - y), int(R), makecol(0, 127, 0));
	rotate_sprite(page, (BITMAP *)(data[SHOT_BMP].dat),
		int(x + 320 - R), int(240 - y - R), ftofix(r * -128 / pi + 64));
}