#include "main.h"

#include "ticker.h"

#include "unit.h"

#include "game.h"

BITMAP *page = 0;
BITMAP *background = 0;

DATAFILE *data;

bool no_sound = false;

int fps = 0;

int main() {
	
	allegro_init();
	
	set_color_depth(8);
	set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);
	
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, 0);
	
	set_volume_per_voice(1);
	
	PALETTE pal;
	
	int n = 0;
	pal[n].r = 63;
	pal[n].g = 0;
	pal[n].b = 63;
	for(; n < 1 + 6 * 7 * 6; n++) {
		pal[n].r = ((n-1) % 6) * 63 / 5;
		pal[n].g = (((n-1) / 6) % 7) * 63 / 6;
		pal[n].b = ((n-1) / 42) * 63 / 5;
	}
	int m = n;
	for(; n < 256; n++) {
		pal[n].r = (2 + n - m) * 63 / 5;
		pal[n].g = (2 + n - m) * 31 / 5;
		pal[n].b = (2 + n - m) * 15 / 5;
	}
	
	set_palette(pal);
	
	BITMAP *video = create_video_bitmap(640, 480);
	
	page = create_bitmap(640, 480);
	
	background = create_bitmap(640, 480);
	
	set_color_conversion(
		(COLORCONV_TOTAL | COLORCONV_DITHER | COLORCONV_KEEP_TRANS)
		& (~COLORCONV_32A_TO_8) );
			
	
	rgb_map = new RGB_MAP;
	
	get_palette(pal);
	
	create_rgb_table(rgb_map, pal, 0);
		
	data = load_datafile("dat.dat");
	
	blit((BITMAP *)(data[BACK_BMP].dat), background, 0, 0, 0, 0, 640, 480);
					
	set_alpha_blender();
	
	install_keyboard();
	
	Ticker *ticker = new Ticker();
	
	game = new Game();	
	
	Unit *unit = game;
	
	unit->enter(1);
	game->done = 2;
	game->next_level = true;
	
	int frames = 0;
		
	int ot = ticker->ticks();
	
	int frametime = ot;
	
	while(true) {
		int nt = ticker->ticks();
		
		float d = float(nt - ot) / 1000.0;
						
		int r = unit->run(d);				
		if(r == -1) break;
		
		unit->display();
		
		frames++;
		if(nt - frametime > 1000) {
			frametime += 1000;
			fps = frames;
			frames = 0;
		}
		
		
		blit(page, video, 0, 0, 0, 0, 640, 480);
						
		ot = nt;
	}
	
	unit->leave();
	
	delete unit;
	
	delete ticker;
	
	return 0;
} END_OF_MAIN();