#include "main.h"

#include "lander.h"

#include "ashot.h"

#include "explosion.h"

#include "game.h"

Lander *Lander::first = 0;

void Lander::deleteall() { deletesome((Entity **)&first); }
void Lander::displayall() { displaysome((Entity **)&first); }
void Lander::moveall(float d) { movesome((Entity **)&first, d); }

Lander::Lander(float r_, float h_) : Entity(r_, h_, 20, (Entity **)&first) {				
	
	reloading = 4;		
	shootdelay = 4;
	health = 2;
	
	hd = -2;
	rd = 0.3;
}

bool Lander::collide(Entity *coll) {
	float q = (x - coll->x) * (x - coll->x) + (y - coll->y) * (y - coll->y);
	return q < R * R + coll->R * coll->R;
}

bool Lander::collidefirst(Entity *coll) {	
	for(Lander *a = first; a; a = (Lander *)a->next) {
		if(a->collide(coll)) {
			a->health--;
			
			new Explosion(a->r, a->h);
			
			return true;
		}
	}
	return false;
}

void Lander::move(float d) {
	reloading -= d;
	
	r += rd * d;
	h += hd * d;
			
	if(h < 60) {
		h = 60;
		game->defender->dead = true;;
	}
			
	if(reloading < 0) {
		reloading = shootdelay;
		
		new AShot(r, h - R);
	}
	
	if(health <= 0) dead = true;
	
	rh2xy();
}

void Lander::display() {		
	
	//circlefill(page, int(x + 320), int(240 - y), int(R), makecol(255, 0, 255));	
	rotate_sprite(page, (BITMAP *)(data[LANDER_BMP].dat),
		int(x + 320 - R), int(240 - y - R), ftofix(r * -128 / pi - 64));	
}