#include "game.h"

#include "main.h"

#include "defender.h"

#include "defense.h"

#include "explosion.h"

#include "lander.h"

#include "attacker.h"

Game *game = 0;

int Game::run(float d) {
	if(key[KEY_ESC]) return -1;	
	
	while(keypressed()) {
		int k = readkey();
		int c = k & 255;
		if(c == 's') no_sound = !no_sound;
	}	
	
	Explosion::moveall(d);
						
	if(done > 0) {
		done -= d;
		return 0;
	} 
			
	defender->move(d);
	
	Lander::moveall(d);
	Attacker::moveall(d);
	
	AShot::moveall(d);
	Shot::moveall(d);
	
	Defense::moveall(d);	
		
	if(next_level || game_over) {			
		if(wave <= 10) {
			leave();
			enter(wave);	
		}
	} else {
		
		if(Lander::first == 0 && Attacker::first == 0) {
			wave++;
			next_level = true;
			done = 2;
		}
			if(defender->dead) {
			game_over = true;
			done = 2;
		}
	}
		
	return 0;	
}

void Game::display() {
	blit(background, page, 0, 0, 0, 0, 640, 480);
	
	//circlefill(page, 320, 240, 50, makecol(0, 0, 255));
	draw_sprite(page, (BITMAP *)(data[WORLD_BMP].dat), 320 - 50, 240 - 50);
			
	defender->display();
	Lander::displayall();
	Attacker::displayall();
	AShot::displayall();
	Shot::displayall();
	Defense::displayall();
	Explosion::displayall();
	
	//textprintf_centre(page, font, 320, 240, -1, "%d %d %.2f", fps, wave, done);
	if(done) {
		int n = wave;
		if(game_over) n = 0;
		if(n > 11) n = 11;
		BITMAP *b = (BITMAP *)(data[MESSAGE_BMP].dat);
		masked_blit(b, page, 0, n * b->h / 12, 320 - b->w / 2, 240 - b->h / 24, b->w, b->h / 12 - 4);
	}		
	
}

void Game::enter(int wave_) {
	defender = new Defender();
	
	done = 0;
	
	next_level = 0;
	game_over = 0;
	
	wave = wave_;	
	
	if(wave > 10) return;
				
	float radius = 240 - 20;
	float angle = 0;
	
	int N = int(1 + float(wave) * 1.6);
	
	for(int n = 0; n < N; n++) {
		 new Lander(angle, radius);
		 angle += 2 * pi / float(N);
	}	
	
	radius = 240 - 40 - 15;
	angle = 0;
	
	N = int(1 + float(wave) * 1.6);
	
	for(int n = 0; n < N; n++) {
		 new Attacker(angle, radius);
		 angle += 2 * pi / float(N);
	}	
	
	radius = 80;
	for(int m = 0; m < 3; m++) {
		int e = m & 1;
		angle = e * pi / 60;
		for(int n = 0; n < 60; n++) {
			if(n < 60 * 1 / 6 - e || 
			   (n >= 60 * 2 / 6 && n < 60 * 3 / 6 - e) ||
			   (n >= 60 * 4 / 6 && n < 60 * 5 / 6 - e)) {
				new Defense(angle, radius);
			}
		 	angle += pi / 30;
		}			
		radius += 8;
	}
}

void Game::leave() {
	delete defender;
	Lander::deleteall();
	Attacker::deleteall();
	AShot::deleteall();
	Shot::deleteall();
	Defense::deleteall();
	Explosion::deleteall();
}