#include "main.h"

#include "explosion.h"

Explosion *Explosion::first = 0;

void Explosion::deleteall() { deletesome((Entity **)&first); }
void Explosion::displayall() { displaysome((Entity **)&first); }
void Explosion::moveall(float d) { movesome((Entity **)&first, d); }

Explosion::Explosion(float r_, float h_) : Entity(r_, h_, 25, (Entity **)&first) {		
			
	t = 0;
	
	if(!no_sound) play_sample((SAMPLE *)(data[EXPL_WAV].dat), 255, 127, 1000, 0);
}

void Explosion::move(float d) {
	t += d;
	
	if(t > 1) {
		dead = true;
	}
		
}

void Explosion::display() {
	//circlefill(page, int(x + 320), int(240 - y), int(R), makecol(0, 127, 0));
	
	int f = int(t * 16.0);
	if(f > 15) f = 15;
	
	DATAFILE *ex = (DATAFILE *)(data[EXPLOSION_DAT].dat);
	
	BITMAP *b = create_bitmap_ex(32, 50, 50);
	
	blit(page, b, int(x + 320 - R), int(240 - y - R), 0, 0, 50, 50);
						
	draw_trans_sprite(b, (BITMAP *)(ex[f].dat), 0, 0);
	
	blit(b, page, 0, 0, int(x + 320 - R), int(240 - y - R), 50, 50);
	
   destroy_bitmap(b);
	
}