#ifndef _ENTITY_H_
#define _ENTITY_H_

#include "common.h"

class Entity {	
public:
	float x, y;
	float r, h;
	float rd, hd;
	
	float R, H;
			
	bool dead;
	
	Entity *next;
	
	Entity();
	Entity(float r_, float h_, float R, Entity **first);
	
	virtual void move(float d) = 0;
	virtual void display() = 0;	
	
	void rh2xy();
	void xy2rh();			
	
	void restore(void);
	
	void add(Entity **first);	
	static void deletesome(Entity **first);
	static void movesome(Entity **first, float d);
	static void displaysome(Entity **first);		
			
};

#endif