#include "entity.h"

Entity::Entity() {}

Entity::Entity(float r_, float h_, float R_, Entity **first) {
		
	r = r_;
	h = h_;
	R = R_;
	H = 0;
	rd = 0;
	hd = 0;		
			
	rh2xy();
	add(first);		
	
	dead = false;	
}

void Entity::xy2rh() {
	r = atan2(y, x);
	h = sqrt(x * x + y * y);
}

void Entity::rh2xy() {
	
	x = cos(r) * h;
	y = sin(r) * h;
		
}

void Entity::add(Entity **first) {
	next = *first;
	*first = this;	
}

void Entity::deletesome(Entity **first) {
	Entity *nex;
	for(Entity *a = *first; a; a = nex) {
		nex = a->next;
		delete a;
	}
	*first = 0;	
}

void Entity::displaysome(Entity **first) {
	for(Entity *a = *first; a; a = a->next) {
		a->display();
	}
}

void Entity::movesome(Entity **first, float d) {
	Entity *nex, *prv = 0;
	for(Entity *a = *first; a; a = nex) {			
		nex = a->next;
		
		a->move(d);
		
		if(a->dead) {
			if(prv) {
				prv->next = nex;
			} else {
				*first = nex;
			}		
			delete a;
		} else {
			prv = a;		
		}		
	}
}