#include "main.h"

#include "defense.h"

Defense *Defense::first = 0;

void Defense::deleteall() { deletesome((Entity **)&first); }
void Defense::displayall() { displaysome((Entity **)&first); }
void Defense::moveall(float d) { movesome((Entity **)&first, d); }

Defense::Defense(float r_, float h_) : Entity(r_, h_, 4, (Entity **)&first) {					
	
	health = 1;
}

bool Defense::collide(Entity *coll) {
	float q = (x - coll->x) * (x - coll->x) + (y - coll->y) * (y - coll->y);
	return q < R * R + coll->R * coll->R;
}

bool Defense::collidefirst(Entity *coll) {	
	for(Defense *a = first; a; a = (Defense *)a->next) {
		if(a->collide(coll)) {
			a->health--;
			return true;
		}
	}
	return false;
}

void Defense::move(float d) {				
		
	if(health <= 0) dead = true;
}

void Defense::display() {
	//circlefill(page, int(x + 320), int(240 - y), int(R), makecol(0, 255, 255));			
	rotate_sprite(page, (BITMAP *)(data[DEFENSE_BMP].dat),
		int(x + 320 - R), int(240 - y - R), ftofix(r * -128 / pi + 64));
}