#include "main.h"

#include "defender.h"

#include "shot.h"

#include "ashot.h"

#include "attacker.h"

#include "lander.h"

#include "explosion.h"

Defender::Defender() {
	x = 0;
	y = 50;
	R = 10;
	rd = 0;
	hd = 0;
	dead = 0;
	
	xy2rh();
	
	reloading = 0;
}


bool Defender::collide(Entity *coll) {
	float q = (x - coll->x) * (x - coll->x) + (y - coll->y) * (y - coll->y);
	bool c = q < R * R + coll->R * coll->R;
	if(c) dead = true;
	return c;
}

void Defender::move(float d) {
			
	if(reloading > 0) reloading -= d;
	
	if(key[KEY_LEFT]) {
		r += d;				
	}
	
	if(key[KEY_RIGHT]) {
		r -= d;				
	}
	
	rh2xy();
	
	if(key[KEY_SPACE]) {
		if(!dead) 
		if(reloading <= 0) {
			reloading = 0.25;
									
			new Shot(r, h + R);
		}
	}
			
	if(Attacker::collidefirst(this)) {
		dead = true;
		
		new Explosion(x, y);
	}
	
	if(Lander::collidefirst(this)) {
		dead = true;
		
		new Explosion(x, y);
	}
		
}

void Defender::display() {
	//circlefill(page, int(x + 320), int(240 - y), int(R), makecol(0, 255, 0));
	if(!dead)
	rotate_sprite(page, (BITMAP *)(data[DEFENDER_BMP].dat),
		int(x + 320 - R), int(240 - y - R), ftofix(r * -128 / pi + 64));
}