#include "main.h"

#include "attacker.h"

#include "ashot.h"

#include "explosion.h"

#include "defense.h"

#include "game.h"

Attacker *Attacker::first = 0;

void Attacker::deleteall() { deletesome((Entity **)&first); }
void Attacker::displayall() { displaysome((Entity **)&first); }
void Attacker::moveall(float d) { movesome((Entity **)&first, d); }

Attacker::Attacker(float r_, float h_) : Entity(r_, h_, 15, (Entity **)&first) {					
	
	reloading = 3;		
	shootdelay = 3;
	health = 1;
	
	hd = -2;
	rd = 0.5;
}

bool Attacker::collide(Entity *coll) {
	float q = (x - coll->x) * (x - coll->x) + (y - coll->y) * (y - coll->y);
	return q < R * R + coll->R * coll->R;
}

bool Attacker::collidefirst(Entity *coll) {	
	for(Attacker *a = first; a; a = (Attacker *)a->next) {
		if(a->collide(coll)) {
			a->health--;
			
			new Explosion(a->r, a->h);
			
			return true;
		}
	}
	return false;
}

void Attacker::move(float d) {
	reloading -= d;
			
	r += rd * d;
	
	h += hd * d; 
	
	if(h < 60) {
		h = 60;
		game->defender->dead = true;
	}
						
	if(reloading < 0) {
		reloading = shootdelay + h / 240;
						
		new AShot(r, h - R);
		
		rd = -rd;
	}
	
	//Defense::collidefirst(this);
	
	if(health <= 0) dead = true;
	
	rh2xy();
}

void Attacker::display() {
			
	//circlefill(page, int(x + 320), int(240 - y), int(R), makecol(255, 0, 255));	
	rotate_sprite(page, (BITMAP *)(data[ATTACKER_BMP].dat),
		int(x + 320 - R), int(240 - y - R), ftofix(r * -128 / pi + 64));	
}