#include "main.h"

#include "game.h"

#include "ashot.h"

#include "defense.h"

#include "explosion.h"

AShot *AShot::first = 0;

void AShot::deleteall() { deletesome((Entity **)&first); }
void AShot::displayall() { displaysome((Entity **)&first); }
void AShot::moveall(float d) { movesome((Entity **)&first, d); }

AShot::AShot(float r_, float h_) : Entity(r_, h_, 3, (Entity **)&first) {			
	hd = -100;
	if(!no_sound) play_sample((SAMPLE *)(data[SHOT_WAV].dat), 255, 127, 1000, 0);
}

void AShot::move(float d) {
	
	h += hd * d;
							
	if(h < 50) {
		dead = true;
		
		new Explosion(r, h);
	}
	
	if(Defense::collidefirst(this)) {
		dead = true;
		
		new Explosion(r, h);
	}
	
	if(game->defender->collide(this)) {
		dead = true;
		
		new Explosion(r, h);
	}
	
	rh2xy();
}

void AShot::display() {
			
	//circlefill(page, int(x + 320), int(240 - y), int(R), makecol(255, 0, 0));
	rotate_sprite(page, (BITMAP *)(data[ASHOT_BMP].dat),
		int(x + 320 - R), int(240 - y - R), ftofix(r * -128 / pi + 64));
}