/* sfh - shit from heaven
 * Copyright (C) 2002 David A. Capello
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <allegro.h>
#include "data.h"
#include "game.h"
#include "level.h"
#include "linklist.h"
#include "people.h"



typedef struct SHIT
{
  int time;
  float x, y, z;
} SHIT;

static LINKLIST *mierda;



void init_shit(void)
{
  mierda = create_linklist(sizeof(SHIT));
}



void shutdown_shit(void)
{
  delete_linklist(mierda);
}



void update_shit(void)
{
  SHIT *shit, *next;

  for (shit=getfirst_linkitem(mierda); shit; shit=next) {
    next = getnext_linkitem(mierda, shit);

    shit->time++;

    shit->z = 1.0 - 0.2 * ((float)shit->time/FPS) * ((float)shit->time/FPS);
    if (shit->z <= FLOOR_Z) {
      hit_people(
        GSCREEN_W/2 + (shit->x - GSCREEN_W/2) * FLOOR_Z,
        GSCREEN_H/2 + (shit->y - GSCREEN_H/2) * FLOOR_Z);

      remove_linkitem(mierda, shit);
    }
  }
}



void draw_shit(BITMAP *bmp, int first)
{
  BITMAP *sprite;
  SHIT *shit;
  int x, y;

  sprite = the_bitmaps[SHIT1_PCX];

  for (shit=getfirst_linkitem(mierda); shit;
       shit=getnext_linkitem(mierda, shit)) {
    if (first) {
      /* draw the shadow */
      x = GSCREEN_W/2 + (shit->x - GSCREEN_W/2) * FLOOR_Z;
      y = GSCREEN_H/2 + (shit->y - GSCREEN_H/2) * FLOOR_Z;
      rectfill(bmp, x, y, x+1, y+1, makecol(0, 0, 0));
    }
    else {
      /* draw the shit */
      x = GSCREEN_W/2 + (shit->x - GSCREEN_W/2) * shit->z;
      y = GSCREEN_H/2 + (shit->y - GSCREEN_H/2) * shit->z;
      pivot_scaled_sprite(bmp, sprite, x, y, sprite->w/2, sprite->h/2,
        itofix(1),
        ftofix(0.25 + 0.75 * (shit->z - FLOOR_Z) / (1.0 - FLOOR_Z)));
    }
  }
}



void add_shit(float x, float y)
{
  SHIT *shit = insert_linkitem(mierda);

  shit->time = 0;
  shit->x = x;
  shit->y = y;
  shit->z = 1.0;
}


