/* sfh - shit from heaven
 * Copyright (C) 2002 David A. Capello
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <allegro.h>
#include "game.h"
#include "linklist.h"
#include "player.h"



typedef struct SCORE
{
  int time;
  int x, y;
  int digit;
} SCORE;

static LINKLIST *puntaje;



void init_scorer(void)
{
  puntaje = create_linklist(sizeof(SCORE));
}



void shutdown_scorer(void)
{
  delete_linklist(puntaje);
}



void update_scorer(void)
{
  SCORE *score, *next;

  for (score=getfirst_linkitem(puntaje); score; score=next) {
    next = getnext_linkitem(puntaje, score);

    score->time++;
    if (score->time > FPS*2)
      remove_linkitem(puntaje, score);
  }
}



void draw_scorer(BITMAP *bmp)
{
  int lifes = get_player_lifes();
  int score_num = get_player_score();
  int food = get_player_food();
  int x1, y1, x2, y2;
  BITMAP *sprite;
  SCORE *score;
  int c;

  text_mode(-1);

  /* food */
  textout_right(bmp, font, "FOOD", GSCREEN_W-1, 5, makecol(0, 0, 0));
  textout_right(bmp, font, "FOOD", GSCREEN_W-2, 4, makecol(32, 196, 255));

  x2 = GSCREEN_W - 37;
  x1 = x2 - 64;
  y1 = 4;
  y2 = y1 + text_height(font) - 1;

  rect(bmp, x1, y1, x2, y2, makecol(0, 0, 0));
  if (food > 0)
    rectfill(bmp, x1+1, y1+1, x1+1+(x2-x1-2)*food/1000, y2-1, makecol(255, 0, 0));

  /* score */
  textprintf(bmp, font, 5, GSCREEN_H-9, makecol(0, 0, 0), "SCORE: %d", score_num);
  textprintf(bmp, font, 4, GSCREEN_H-10, makecol(196, 255, 196), "SCORE: %d", score_num);

  /* lifes */
  if (lifes >= 0) {
    textprintf(bmp, font, 5, GSCREEN_H-18, makecol(0, 0, 0), "LIFES: %d", lifes);
    textprintf(bmp, font, 4, GSCREEN_H-19, makecol(255, 196, 32), "LIFES: %d", lifes);
  }
  else {
    textout(bmp, font, "YOU ARE DEAD", 5, GSCREEN_H-18, makecol(0, 0, 0));
    textout(bmp, font, "YOU ARE DEAD", 4, GSCREEN_H-19, makecol(255, 196, 32));

    /* game over */
    sprite = create_bitmap(8*9, 8);
    clear(sprite);

    for (c=0; c<=8; c++) {
      textout(sprite, font, "GAME OVER", 0, 0,
        makecol(255*c/8, 0, 0));

      pivot_scaled_sprite(bmp, sprite,
        GSCREEN_W/2, GSCREEN_H/2,
        sprite->w/2, sprite->h/2,
        itofix(0), ftofix(3.0+(1.0)*c/8));
    }

    textout(sprite, font, "GAME OVER", 0, 0, makecol(255, 255, 0));
    pivot_scaled_sprite(bmp, sprite,
      GSCREEN_W/2, GSCREEN_H/2,
      sprite->w/2, sprite->h/2,
      itofix(0), ftofix(4.0));

    destroy_bitmap(sprite);
  }

  /* dynamic score */
  for (score=getfirst_linkitem(puntaje); score;
       score=getnext_linkitem(puntaje, score)) {
    x1 = score->x;

    if (score->time < FPS/2)
      y1 = score->y - text_height(font)/2 - 16 * score->time / (FPS/2);
    else
      y1 = score->y - text_height(font)/2 - 16;

    textprintf_centre(bmp, font, x1+1, y1+1, makecol(0, 0, 0), "%d", score->digit);
    textprintf_centre(bmp, font, x1, y1, makecol(255, 255, 255), "%d", score->digit);
  }
}



void add_score(int x, int y, int digit)
{
  SCORE *score = insert_linkitem(puntaje);

  score->time = 0;
  score->x = x;
  score->y = y;
  score->digit = digit;
}


